/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.roundaround.custompaintings.client.gui.FiltersState;
import me.roundaround.custompaintings.client.registry.ClientPaintingRegistry;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1534;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class PaintingEditState {
    private final class_310 client;
    private final HashMap<String, PackData> allPaintings = new HashMap();
    private final HashMap<String, Boolean> canStayHashMap = new HashMap();
    private final int paintingId;
    private final class_2338 blockPos;
    private final class_2350 facing;
    private final FiltersState filtersState;
    private PackData currentPack = null;
    private PaintingData currentPainting = PaintingData.EMPTY;
    private List<PaintingData> currentPaintings = List.of();
    private StateChangedListener stateChangedListener = null;
    private static final Predicate<class_1297> DECORATION_PREDICATE = class_12972 -> class_12972 instanceof class_1530;

    public PaintingEditState(class_310 class_3102, int n, class_2338 class_23382, class_2350 class_23502) {
        this.client = class_3102;
        this.paintingId = n;
        this.blockPos = class_23382;
        this.facing = class_23502;
        this.filtersState = new FiltersState(this::canStay);
        this.populatePaintings();
    }

    public void clearStateChangedListener() {
        this.setStateChangedListener(null);
    }

    public void setStateChangedListener(StateChangedListener stateChangedListener) {
        this.stateChangedListener = stateChangedListener;
        if (this.stateChangedListener != null) {
            this.stateChangedListener.onPaintingsListChanged();
            this.stateChangedListener.onCurrentPaintingChanged();
        }
    }

    public FiltersState getFilters() {
        return this.filtersState;
    }

    public Collection<PackData> getPacks() {
        return this.allPaintings.values();
    }

    public void updatePaintingList() {
        if (this.currentPack == null) {
            return;
        }
        List<PaintingData> list = this.currentPaintings;
        this.currentPaintings = this.currentPack.paintings().stream().filter(this.filtersState).toList();
        if (list.size() == this.currentPaintings.size()) {
            boolean bl = false;
            for (int i = 0; i < this.currentPaintings.size(); ++i) {
                if (list.get(i).idEquals(this.currentPaintings.get(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        if (this.stateChangedListener != null) {
            this.stateChangedListener.onPaintingsListChanged();
        }
        if (!this.currentPaintings.contains(this.currentPainting)) {
            this.setCurrentPainting(this.currentPaintings.isEmpty() ? PaintingData.EMPTY : this.currentPaintings.getFirst());
        }
    }

    public List<PaintingData> getCurrentPaintings() {
        return this.currentPaintings;
    }

    public boolean areAnyPaintingsFiltered() {
        if (this.currentPack == null) {
            return false;
        }
        return this.currentPaintings.size() < this.currentPack.paintings().size();
    }

    public boolean hasPaintingsToIterate() {
        return this.currentPaintings.size() > 1;
    }

    public void setPreviousPainting() {
        if (!this.hasPaintingsToIterate()) {
            return;
        }
        int n = this.currentPaintings.indexOf(this.currentPainting);
        if (n == -1) {
            this.setCurrentPainting(this.currentPaintings.getLast());
            return;
        }
        this.setCurrentPainting(n - 1);
    }

    public void setNextPainting() {
        if (!this.hasPaintingsToIterate()) {
            return;
        }
        int n = this.currentPaintings.indexOf(this.currentPainting);
        if (n == -1) {
            this.setCurrentPainting(this.currentPaintings.getFirst());
            return;
        }
        this.setCurrentPainting(n + 1);
    }

    public int getPaintingId() {
        return this.paintingId;
    }

    public PackData getCurrentPack() {
        return this.currentPack;
    }

    public PaintingData getCurrentPainting() {
        return this.currentPainting;
    }

    public void setCurrentPack(String string) {
        if (!this.allPaintings.containsKey(string)) {
            return;
        }
        this.setCurrentPack(this.allPaintings.get(string));
    }

    public void setCurrentPack(PackData packData) {
        this.currentPack = packData;
        this.updatePaintingList();
    }

    public void setCurrentPainting(int n) {
        int n2 = this.currentPaintings.size();
        if (n2 < 1) {
            this.setCurrentPainting(PaintingData.EMPTY);
        }
        if (n2 == 1) {
            this.setCurrentPainting(this.currentPaintings.getFirst());
        }
        this.setCurrentPainting(this.currentPaintings.get((n2 + n) % n2));
    }

    public void setCurrentPainting(PaintingData paintingData) {
        PaintingData paintingData2 = this.currentPainting;
        this.currentPainting = paintingData;
        if (this.stateChangedListener != null && !paintingData2.idEquals(this.currentPainting)) {
            this.stateChangedListener.onCurrentPaintingChanged();
        }
    }

    public void populatePaintings() {
        if (!this.allPaintings.isEmpty()) {
            return;
        }
        this.createVanillaPack();
        this.createUnplaceableVanillaPack();
        this.allPaintings.putAll(ClientPaintingRegistry.getInstance().getActivePacks().stream().collect(Collectors.toMap(PackData::id, Function.identity())));
        this.allPaintings.entrySet().removeIf(entry -> ((PackData)entry.getValue()).paintings().isEmpty());
        this.allPaintings.values().forEach(packData -> packData.paintings().forEach(paintingData -> {
            String string = paintingData.width() + "x" + paintingData.height();
            if (!this.canStayHashMap.containsKey(string)) {
                this.canStayHashMap.put(string, this.canStay((PaintingData)paintingData));
            }
        }));
    }

    protected void createVanillaPack() {
        String string = "minecraft";
        List<PaintingData> list = ClientPaintingRegistry.getInstance().getAllVanilla();
        this.allPaintings.put(string, PackData.virtual(string, (class_2561)class_2561.method_43471((String)"custompaintings.pack.minecraft.name"), (class_2561)class_2561.method_43471((String)"custompaintings.pack.minecraft.name"), list));
    }

    protected void createUnplaceableVanillaPack() {
        String string = "minecraft_unplaceable";
        List<PaintingData> list = ClientPaintingRegistry.getInstance().getAllVanillaUnplaceable();
        this.allPaintings.put(string, PackData.virtual(string, (class_2561)class_2561.method_43471((String)"custompaintings.pack.unplaceable.name"), (class_2561)class_2561.method_43471((String)"custompaintings.pack.unplaceable.name"), list));
    }

    public boolean canStay() {
        return this.canStay(this.getCurrentPainting());
    }

    public boolean canStay(PaintingData paintingData) {
        String string = paintingData.width() + "x" + paintingData.height();
        if (this.canStayHashMap.containsKey(string)) {
            return this.canStayHashMap.get(string);
        }
        boolean bl = this.canStay(paintingData.width(), paintingData.height());
        this.canStayHashMap.put(string, bl);
        return bl;
    }

    public boolean canStay(int n, int n2) {
        class_238 class_2383;
        class_1937 class_19372 = Objects.requireNonNull(this.client.field_1724).method_37908();
        if (!class_19372.method_18026(class_2383 = this.getBoundingBox(n, n2))) {
            return false;
        }
        int n3 = Math.max(1, n);
        int n4 = Math.max(1, n2);
        class_2338 class_23382 = this.blockPos.method_10093(this.facing.method_10153());
        class_2350 class_23502 = this.facing.method_10160();
        class_2338.class_2339 class_23392 = new class_2338.class_2339();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                class_23392.method_10101((class_2382)class_23382).method_10104(class_23502, i - (n3 - 1) / 2).method_10104(class_2350.field_11036, j - (n4 - 1) / 2);
                class_2680 class_26802 = class_19372.method_8320((class_2338)class_23392);
                if (class_26802.method_51367() || class_2312.method_9999((class_2680)class_26802)) continue;
                return false;
            }
        }
        class_1297 class_12972 = class_19372.method_8469(this.paintingId);
        class_1534 class_15342 = class_12972 instanceof class_1534 ? (class_1534)class_12972 : null;
        return class_19372.method_8333((class_1297)class_15342, class_2383, DECORATION_PREDICATE).isEmpty();
    }

    private class_238 getBoundingBox(int n, int n2) {
        double d = (double)this.blockPos.method_10263() + 0.5 - (double)this.facing.method_10148() * 0.46875 + (double)this.facing.method_10160().method_10148() * this.offsetForEven(n);
        double d2 = (double)this.blockPos.method_10264() + 0.5 + this.offsetForEven(n2);
        double d3 = (double)this.blockPos.method_10260() + 0.5 - (double)this.facing.method_10165() * 0.46875 + (double)this.facing.method_10160().method_10165() * this.offsetForEven(n);
        double d4 = (double)(this.facing.method_10166() == class_2350.class_2351.field_11051 ? n : 1) / 32.0;
        double d5 = (double)n2 / 32.0;
        double d6 = (double)(this.facing.method_10166() == class_2350.class_2351.field_11051 ? 1 : n) / 32.0;
        return new class_238(d - d4, d2 - d5, d3 - d6, d + d4, d2 + d5, d3 + d6);
    }

    private double offsetForEven(int n) {
        return n % 32 == 0 ? 0.5 : 0.0;
    }

    public static interface StateChangedListener {
        public void onPaintingsListChanged();

        public void onCurrentPaintingChanged();
    }
}

