/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.screen;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.gui.screen.PacksLoadedListener;
import me.roundaround.custompaintings.client.gui.widget.LoadingButtonWidget;
import me.roundaround.custompaintings.client.gui.widget.SpriteWidget;
import me.roundaround.custompaintings.client.gui.widget.VersionStamp;
import me.roundaround.custompaintings.client.network.ClientNetworking;
import me.roundaround.custompaintings.client.registry.ClientPaintingRegistry;
import me.roundaround.custompaintings.client.toast.CustomSystemToasts;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.Alignment;
import me.roundaround.custompaintings.roundalib.client.gui.util.Axis;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.util.Spacing;
import me.roundaround.custompaintings.roundalib.client.gui.widget.FlowListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.NarratableEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.DrawableWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.util.StringUtil;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class PacksScreen
extends class_437
implements PacksLoadedListener {
    private static final class_2561 TITLE_MANAGE = class_2561.method_43471((String)"custompaintings.packs.manage");
    private static final class_2561 TITLE_VIEW = class_2561.method_43471((String)"custompaintings.packs.view");
    private static final class_2561 LIST_INACTIVE = class_2561.method_43471((String)"custompaintings.packs.inactive");
    private static final class_2561 LIST_ACTIVE = class_2561.method_43471((String)"custompaintings.packs.active");
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 120;
    private static final int LIST_WIDTH = 200;
    private static final class_2960 SELECT_TEXTURE = class_2960.method_60656((String)"transferable_list/select");
    private static final class_2960 SELECT_HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"transferable_list/select_highlighted");
    private static final class_2960 UNSELECT_TEXTURE = class_2960.method_60656((String)"transferable_list/unselect");
    private static final class_2960 UNSELECT_HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"transferable_list/unselect_highlighted");
    private final ThreeSectionLayoutWidget layout = new ThreeSectionLayoutWidget(this);
    private final class_437 parent;
    private final boolean editMode;
    private final ArrayList<PackData> inactivePacks = new ArrayList();
    private final ArrayList<PackData> activePacks = new ArrayList();
    private final HashSet<String> toActivate = new HashSet();
    private final HashSet<String> toDeactivate = new HashSet();
    private PackList inactiveList;
    private PackList activeList;
    private LoadingButtonWidget reloadButton;

    public PacksScreen(class_437 class_4372, boolean bl) {
        super(bl ? TITLE_MANAGE : TITLE_VIEW);
        this.parent = class_4372;
        this.editMode = bl;
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.resetPacks();
        boolean bl = this.field_22787.method_1542();
        this.layout.addHeader(this.field_22793, this.field_22785);
        if (bl) {
            this.layout.addHeader(this.field_22793, (class_2561)class_2561.method_43471((String)"custompaintings.packs.drop").method_27692(class_124.field_1080));
        }
        if (this.editMode) {
            this.layout.getBody().flowAxis(Axis.HORIZONTAL).spacing(30);
            this.inactiveList = this.layout.addBody(new PackList(this.field_22787, 200, this.layout.getBodyHeight(), LIST_INACTIVE, SELECT_TEXTURE, SELECT_HIGHLIGHTED_TEXTURE, this::activatePack, this.inactivePacks), (linearLayoutWidget, packList) -> packList.method_55445(200, linearLayoutWidget.method_25364()));
            this.activeList = this.layout.addBody(new PackList(this.field_22787, 200, this.layout.getBodyHeight(), LIST_ACTIVE, UNSELECT_TEXTURE, UNSELECT_HIGHLIGHTED_TEXTURE, this::deactivatePack, this.activePacks), (linearLayoutWidget, packList) -> packList.method_55445(200, linearLayoutWidget.method_25364()));
            this.reloadButton = this.layout.addFooter(new LoadingButtonWidget(0, 0, 120, 20, class_2561.method_30163((String)"Reload Packs"), class_41852 -> this.reloadPacks()));
            class_4185 class_41853 = this.layout.addFooter(class_4185.method_46430((class_2561)class_2561.method_43471((String)"custompaintings.packs.open"), class_41852 -> this.openPackDir()).method_46432(120).method_46431());
            if (!bl) {
                class_41853.field_22763 = false;
                class_41853.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"custompaintings.packs.open.notInWorld")));
            }
        } else {
            this.activeList = this.layout.addBody(new PackList(this.field_22787, this.layout, LIST_ACTIVE, this.activePacks));
        }
        this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24334, class_41852 -> this.method_25419()).method_46432(120).method_46431());
        VersionStamp.create(this.field_22793, this.layout);
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_29638(List<Path> list) {
        assert (this.field_22787 != null);
        if (!this.field_22787.method_1542()) {
            return;
        }
        List<Path> list2 = list.stream().filter(ResourceUtil::isPaintingPack).toList();
        if (list2.isEmpty()) {
            return;
        }
        Path path = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
        String string = list2.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(bl -> {
            if (bl) {
                boolean bl2 = true;
                this.ensurePacksDirExists(path);
                for (Path path2 : list2) {
                    if (!ResourceUtil.isPaintingPack(path2)) {
                        CustomPaintingsMod.LOGGER.warn("Entry is not a painting pack; skipping: {}", (Object)path2);
                        bl2 = false;
                        continue;
                    }
                    Path path3 = path.resolve(path2.getFileName());
                    try {
                        Files.copy(path2, path3, new CopyOption[0]);
                    }
                    catch (IOException iOException) {
                        CustomPaintingsMod.LOGGER.warn(String.format("Failed to copy painting pack from %s to %s", path2, path3), (Throwable)iOException);
                        bl2 = false;
                    }
                }
                if (!bl2) {
                    CustomSystemToasts.addPackCopyFailure(this.field_22787, path.toString());
                }
                this.reloadPacks();
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"custompaintings.packs.copyConfirm"), class_2561.method_30163((String)string)));
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        if (!this.toActivate.isEmpty() || !this.toDeactivate.isEmpty()) {
            this.reloadPacks();
        }
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void onPacksLoaded() {
        if (this.reloadButton != null) {
            this.reloadButton.setLoading(false);
        }
        this.resetPacks();
    }

    @Override
    public void onPackTexturesInitialized() {
        if (this.inactiveList != null) {
            this.inactiveList.refresh();
        }
        if (this.activeList != null) {
            this.activeList.refresh();
        }
    }

    private void resetPacks() {
        this.inactivePacks.clear();
        this.activePacks.clear();
        this.toActivate.clear();
        this.toDeactivate.clear();
        ClientPaintingRegistry clientPaintingRegistry = ClientPaintingRegistry.getInstance();
        this.inactivePacks.addAll(clientPaintingRegistry.getInactivePacks());
        this.activePacks.addAll(clientPaintingRegistry.getActivePacks());
        this.resetLists();
    }

    private void resetLists() {
        if (this.inactiveList != null) {
            this.inactiveList.setPacks(this.inactivePacks);
        }
        if (this.activeList != null) {
            this.activeList.setPacks(this.activePacks);
        }
    }

    private void activatePack(PackData packData) {
        if (!this.editMode) {
            return;
        }
        if (this.inactivePacks.remove(packData)) {
            this.activePacks.add(packData);
            String string = packData.packFileUid();
            this.toDeactivate.remove(string);
            this.toActivate.add(string);
            this.resetLists();
        }
    }

    private void deactivatePack(PackData packData) {
        if (!this.editMode) {
            return;
        }
        if (this.activePacks.remove(packData)) {
            this.inactivePacks.add(packData);
            String string = packData.packFileUid();
            this.toActivate.remove(string);
            this.toDeactivate.add(string);
            this.resetLists();
        }
    }

    private void reloadPacks() {
        if (this.reloadButton != null) {
            this.reloadButton.setLoading(true);
        }
        class_156.method_27958().execute(() -> ClientNetworking.sendReloadPacket(List.copyOf(this.toActivate), List.copyOf(this.toDeactivate)));
    }

    private void openPackDir() {
        assert (this.field_22787 != null);
        if (!this.field_22787.method_1542()) {
            return;
        }
        Path path = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
        this.ensurePacksDirExists(path);
        class_156.method_668().method_673(path.toUri());
    }

    private void ensurePacksDirExists(Path path) {
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn(String.format("Failed to create packs directory %s", path), (Throwable)iOException);
        }
    }

    private static class PackList
    extends NarratableEntryListWidget<Entry> {
        private final class_2561 title;
        private final class_2960 buttonTexture;
        private final class_2960 highlightedButtonTexture;
        private final Consumer<PackData> transferAction;
        private final ArrayList<PackData> packs = new ArrayList();

        public PackList(class_310 class_3102, int n, int n2, class_2561 class_25612, class_2960 class_29602, class_2960 class_29603, Consumer<PackData> consumer, Collection<PackData> collection) {
            super(class_3102, 0, 0, n, n2);
            this.title = class_25612;
            this.buttonTexture = class_29602;
            this.highlightedButtonTexture = class_29603;
            this.transferAction = consumer;
            this.packs.addAll(collection);
            this.setShouldHighlightSelectionDuringHover(true);
            Objects.requireNonNull(class_3102.field_1772);
            Spacing spacing = this.contentPadding.expand(Spacing.of((int)(9.0f * 1.5f), 0, 0, 0));
            this.setContentPadding(spacing);
            this.init();
        }

        public PackList(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget, class_2561 class_25612, Collection<PackData> collection) {
            super(class_3102, threeSectionLayoutWidget);
            this.title = class_25612;
            this.buttonTexture = null;
            this.highlightedButtonTexture = null;
            this.transferAction = null;
            this.packs.addAll(collection);
            this.setShouldHighlightHover(false);
            this.setShouldHighlightSelection(false);
            this.setAlternatingRowShading(true);
            Objects.requireNonNull(class_3102.field_1772);
            Spacing spacing = this.contentPadding.expand(Spacing.of((int)(9.0f * 1.5f), 0, 0, 0));
            this.setContentPadding(spacing);
            this.init();
        }

        @Override
        protected void renderEntries(class_332 class_3322, int n, int n2, float f) {
            class_327 class_3272 = this.client.field_1772;
            class_5250 class_52502 = class_2561.method_43473().method_10852(this.title).method_27695(new class_124[]{class_124.field_1073, class_124.field_1067});
            int n3 = this.method_46426() + this.method_25368() / 2;
            int n4 = this.method_46427() + this.getContentTop();
            Objects.requireNonNull(class_3272);
            int n5 = (n4 - 9) / 2;
            GuiUtil.drawText(class_3322, class_3272, (class_2561)class_52502, n3, n5, -1, false, 0, Alignment.CENTER);
            super.renderEntries(class_3322, n, n2, f);
        }

        public void setPacks(Collection<PackData> collection) {
            this.packs.clear();
            this.packs.addAll(collection);
            this.init();
        }

        public void refresh() {
            this.init();
        }

        private void init() {
            this.clearEntries();
            for (PackData packData : this.packs) {
                this.addEntry(PackEntry.factory(this.client.field_1772, packData, this.buttonTexture, this.highlightedButtonTexture, this.transferAction));
            }
            this.method_48222();
        }

        private static class PackEntry
        extends Entry {
            private static final int HEIGHT = 40;
            private static final int PACK_ICON_SIZE = 32;
            private final PackData pack;
            private final class_2960 buttonTexture;
            private final class_2960 highlightedButtonTexture;
            private final Consumer<PackData> transferAction;
            private final SpriteWidget icon;
            private final DrawableWidget button;

            protected PackEntry(int n, int n2, int n3, int n4, class_327 class_3272, PackData packData, class_2960 class_29602, class_2960 class_29603, Consumer<PackData> consumer) {
                super(n, n2, n3, n4, 40);
                this.pack = packData;
                this.buttonTexture = class_29602;
                this.highlightedButtonTexture = class_29603;
                this.transferAction = consumer;
                LinearLayoutWidget linearLayoutWidget3 = this.addLayout(LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlign(Alignment.CENTER), linearLayoutWidget -> linearLayoutWidget.setPositionAndDimensions(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()));
                this.icon = linearLayoutWidget3.add(SpriteWidget.create(ClientPaintingRegistry.getInstance().getSprite(PackIcons.customId(packData.id()))), (linearLayoutWidget, spriteWidget) -> spriteWidget.method_55445(32, 32));
                linearLayoutWidget3.add(FillerWidget.empty());
                LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().spacing(2);
                linearLayoutWidget4.add(LabelWidget.builder(class_3272, class_2561.method_30163((String)packData.name())).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(LabelWidget.builder(class_3272, (class_2561)class_2561.method_43470((String)packData.id()).method_27692(class_124.field_1080)).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(LabelWidget.builder(class_3272, (class_2561)class_2561.method_43469((String)"custompaintings.packs.paintings", (Object[])new Object[]{packData.paintings().size()})).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(LabelWidget.builder(class_3272, class_2561.method_30163((String)StringUtil.formatBytes(packData.fileSize()))).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368()));
                linearLayoutWidget3.add(linearLayoutWidget4, (linearLayoutWidget, linearLayoutWidget2) -> {
                    int n = this.getContentWidth();
                    n -= (linearLayoutWidget.getChildren().size() - 1) * linearLayoutWidget.getSpacing();
                    for (class_8021 class_80212 : linearLayoutWidget.getChildren()) {
                        if (class_80212 == linearLayoutWidget2) continue;
                        n -= class_80212.method_25368();
                    }
                    linearLayoutWidget2.setWidth(n);
                });
                linearLayoutWidget3.method_48206(class_40682 -> {
                    class_339 cfr_ignored_0 = (class_339)this.addDrawable(class_40682);
                });
                if (this.transferAction == null) {
                    this.button = null;
                    return;
                }
                this.button = this.addDrawable(new DrawableWidget(){

                    protected void method_48579(class_332 class_3322, int n, int n2, float f) {
                        PackEntry packEntry = this;
                        if (!packEntry.method_25405(n, n2) && !packEntry.method_25370()) {
                            return;
                        }
                        class_2960 class_29602 = this.method_49606() ? packEntry.highlightedButtonTexture : packEntry.buttonTexture;
                        class_3322.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -1601138544);
                        class_3322.method_52707(class_10799.field_56883, class_29602, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -1);
                    }

                    public void method_25348(double d, double d2) {
                        transferAction.accept(pack);
                    }

                    @Override
                    protected boolean method_25351(int n) {
                        return n == 0;
                    }
                });
            }

            public static FlowListWidget.EntryFactory<PackEntry> factory(class_327 class_3272, PackData packData, class_2960 class_29602, class_2960 class_29603, Consumer<PackData> consumer) {
                return (n, n2, n3, n4) -> new PackEntry(n, n2, n3, n4, class_3272, packData, class_29602, class_29603, consumer);
            }

            @Override
            public class_2561 getNarration() {
                return class_2561.method_30163((String)this.pack.name());
            }

            @Override
            public void method_48222() {
                super.method_48222();
                if (this.button != null) {
                    this.button.method_55444(this.icon.method_25368(), this.icon.method_25364(), this.icon.method_46426(), this.icon.method_46427());
                }
            }

            @Override
            public boolean method_25402(double d, double d2, int n) {
                if (this.button != null) {
                    this.button.method_25402(d, d2, n);
                }
                return true;
            }
        }

        private static abstract class Entry
        extends NarratableEntryListWidget.Entry {
            protected Entry(int n, int n2, int n3, int n4, int n5) {
                super(n, n2, n3, n4, n5);
            }
        }
    }
}

