/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.entity.decoration.painting;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.roundaround.custompaintings.util.CustomId;
import net.minecraft.class_124;
import net.minecraft.class_1535;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class PaintingData {
    public static final PaintingData EMPTY = new PaintingData(null, 0, 0);
    public static final Codec<PaintingData> CODEC = RecordCodecBuilder.create(instance -> PaintingData.mapBaseCodecFields(instance).apply((Applicative)instance, PaintingData::new));
    public static final class_9139<ByteBuf, PaintingData> PACKET_CODEC = class_9139.method_64265(CustomId.PACKET_CODEC, PaintingData::id, (class_9139)class_9135.field_49675, PaintingData::width, (class_9139)class_9135.field_49675, PaintingData::height, (class_9139)class_9135.field_48554, PaintingData::name, (class_9139)class_9135.field_48554, PaintingData::artist, (class_9139)class_9135.field_48547, PaintingData::vanilla, (class_9139)class_9135.field_48547, PaintingData::unknown, PaintingData::new);
    public static final String PACK_NBT_KEY = "custompaintings:pack";
    public static final String PAINTING_NBT_KEY = "custompaintings:painting";
    private final CustomId id;
    private final int width;
    private final int height;
    @NotNull
    private final String name;
    @NotNull
    private final String artist;
    private final boolean vanilla;
    private final boolean unknown;

    public PaintingData(CustomId customId, int n, int n2, @NotNull String string, @NotNull String string2, boolean bl, boolean bl2) {
        assert (string != null);
        assert (string2 != null);
        this.id = customId;
        this.width = n;
        this.height = n2;
        this.name = string;
        this.artist = string2;
        this.vanilla = bl;
        this.unknown = bl2;
    }

    public PaintingData(CustomId customId, int n, int n2) {
        this(customId, n, n2, "", "");
    }

    public PaintingData(CustomId customId, int n, int n2, @NotNull String string, @NotNull String string2) {
        this(customId, n, n2, string, string2, false, false);
    }

    public PaintingData(class_1535 class_15352) {
        this(CustomId.from(class_15352.comp_2672()), class_15352.comp_2670(), class_15352.comp_2671(), class_15352.comp_2672().method_12832(), "", true, false);
    }

    public class_1535 toVariant() {
        return new class_1535(this.width(), this.height(), CustomId.toIdentifier(this.id()), Optional.of(this.getNameText()), Optional.of(this.getArtistText()));
    }

    public int getScaledWidth() {
        return this.width() * 16;
    }

    public int getScaledHeight() {
        return this.height() * 16;
    }

    public int getScaledWidth(int n, int n2) {
        float f = Math.min((float)n / (float)this.width(), (float)n2 / (float)this.height());
        return Math.round(f * (float)this.width());
    }

    public int getScaledHeight(int n, int n2) {
        float f = Math.min((float)n / (float)this.width(), (float)n2 / (float)this.height());
        return Math.round(f * (float)this.height());
    }

    public boolean isEmpty() {
        return this.id() == null;
    }

    public boolean hasName() {
        return this.vanilla() || !this.name().isEmpty();
    }

    public boolean hasArtist() {
        return this.vanilla() || !this.artist().isEmpty();
    }

    public boolean hasLabel() {
        return this.hasName() || this.hasArtist();
    }

    public class_5250 getNameText() {
        if (!this.hasName()) {
            return class_2561.method_43473();
        }
        if (this.vanilla()) {
            return class_2561.method_43471((String)this.id().toTranslationKey("painting", "title")).method_27692(class_124.field_1054);
        }
        return class_2561.method_43470((String)this.name()).method_27692(class_124.field_1076);
    }

    public class_5250 getArtistText() {
        if (!this.hasArtist()) {
            return class_2561.method_43473();
        }
        if (this.vanilla()) {
            return class_2561.method_43471((String)this.id().toTranslationKey("painting", "author")).method_27692(class_124.field_1056);
        }
        return class_2561.method_43470((String)this.artist).method_27692(class_124.field_1056);
    }

    public class_2561 getLabel() {
        if (!this.hasLabel()) {
            return class_2561.method_43473();
        }
        if (!this.hasArtist()) {
            return this.getNameText();
        }
        if (!this.hasName()) {
            return this.getArtistText();
        }
        return class_2561.method_43473().method_10852((class_2561)this.getNameText()).method_27693(" - ").method_10852((class_2561)this.getArtistText());
    }

    public List<class_2561> getLabelAsLines() {
        if (!this.hasLabel()) {
            return List.of();
        }
        if (!this.hasArtist()) {
            return List.of(this.getNameText());
        }
        if (!this.hasName()) {
            return List.of(this.getArtistText());
        }
        return List.of(this.getNameText(), this.getArtistText());
    }

    public class_2561 getIdText() {
        class_5250 class_52502 = class_2561.method_43470((String)("(" + this.id().resource() + ")"));
        if (this.hasLabel()) {
            class_52502 = class_52502.method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
        }
        return class_52502;
    }

    public class_2561 getDimensionsText() {
        return class_2561.method_43469((String)"custompaintings.painting.dimensions", (Object[])new Object[]{this.width, this.height});
    }

    public List<class_2561> getInfoLines() {
        ArrayList<class_2561> arrayList = new ArrayList<class_2561>();
        if (this.hasLabel()) {
            arrayList.add(this.getLabel());
        }
        arrayList.add(this.getIdText());
        arrayList.add(this.getDimensionsText());
        return arrayList;
    }

    public class_5250 getTooltipNameText() {
        if (!this.hasName()) {
            return class_2561.method_43470((String)this.id().resource()).method_27692(class_124.field_1076);
        }
        return this.getNameText();
    }

    public Optional<class_5250> getTooltipArtistText() {
        if (!this.hasArtist()) {
            return Optional.empty();
        }
        return Optional.of(class_2561.method_43470((String)this.artist()).method_27692(class_124.field_1080));
    }

    public class_5250 getTooltipDimensionsText() {
        return class_2561.method_43469((String)"painting.dimensions", (Object[])new Object[]{this.width, this.height});
    }

    public PaintingData setId(CustomId customId) {
        return new PaintingData(customId, this.width, this.height, this.name, this.artist, this.vanilla, this.unknown);
    }

    public PaintingData setWidth(int n) {
        return new PaintingData(this.id, n, this.height, this.name, this.artist, this.vanilla, this.unknown);
    }

    public PaintingData setHeight(int n) {
        return new PaintingData(this.id, this.width, n, this.name, this.artist, this.vanilla, this.unknown);
    }

    public PaintingData setDimensions(int n, int n2) {
        return new PaintingData(this.id, n, n2, this.name, this.artist, this.vanilla, this.unknown);
    }

    public PaintingData setName(@NotNull String string) {
        return new PaintingData(this.id, this.width, this.height, string, this.artist, this.vanilla, this.unknown);
    }

    public PaintingData setArtist(@NotNull String string) {
        return new PaintingData(this.id, this.width, this.height, this.name, string, this.vanilla, this.unknown);
    }

    public PaintingData setLabel(@NotNull String string, @NotNull String string2) {
        return new PaintingData(this.id, this.width, this.height, string, string2, this.vanilla, this.unknown);
    }

    public PaintingData markUnknown() {
        return new PaintingData(this.id, this.width, this.height, this.name, this.artist, this.vanilla, true);
    }

    public boolean isMismatched(PaintingData paintingData) {
        return this.isMismatched(paintingData, MismatchedCategory.EVERYTHING);
    }

    public boolean isMismatched(PaintingData paintingData, MismatchedCategory mismatchedCategory) {
        return switch (mismatchedCategory.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.width() != paintingData.width() || this.height() != paintingData.height()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (!this.name().equals(paintingData.name()) || !this.artist().equals(paintingData.artist()) || this.vanilla() != paintingData.vanilla()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> this.width() != paintingData.width() || this.height() != paintingData.height() || !this.name().equals(paintingData.name()) || !this.artist().equals(paintingData.artist());
        };
    }

    public boolean idEquals(PaintingData paintingData) {
        return Objects.equals(this.id(), paintingData.id());
    }

    public CustomId id() {
        return this.id;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public String name() {
        return this.name;
    }

    public String artist() {
        return this.artist;
    }

    public boolean vanilla() {
        return this.vanilla;
    }

    public boolean unknown() {
        return this.unknown;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PaintingData)) {
            return false;
        }
        PaintingData paintingData = (PaintingData)object;
        return this.width == paintingData.width && this.height == paintingData.height && this.vanilla == paintingData.vanilla && Objects.equals(this.name, paintingData.name) && Objects.equals(this.id, paintingData.id) && Objects.equals(this.artist, paintingData.artist);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.width, this.height, this.name, this.artist, this.vanilla, this.unknown);
    }

    public String toString() {
        return "PaintingData[id=" + String.valueOf(this.id) + ", width=" + this.width + ", height=" + this.height + ", name=" + this.name + ", artist=" + this.artist + ", vanilla=" + this.vanilla + ", unknown=" + this.unknown + "]";
    }

    public static <T extends PaintingData> Products.P7<RecordCodecBuilder.Mu<T>, CustomId, Integer, Integer, String, String, Boolean, Boolean> mapBaseCodecFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)CustomId.CODEC.fieldOf("Id").forGetter(PaintingData::id), (App)Codec.INT.fieldOf("Width").forGetter(PaintingData::width), (App)Codec.INT.fieldOf("Height").forGetter(PaintingData::height), (App)Codec.STRING.optionalFieldOf("Name", (Object)"").forGetter(PaintingData::name), (App)Codec.STRING.optionalFieldOf("Artist", (Object)"").forGetter(PaintingData::artist), (App)Codec.BOOL.fieldOf("Vanilla").forGetter(PaintingData::vanilla), (App)Codec.BOOL.optionalFieldOf("Unknown", (Object)false).forGetter(PaintingData::unknown));
    }

    public static enum MismatchedCategory {
        SIZE,
        INFO,
        EVERYTHING;

    }
}

