/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file.json;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.roundaround.custompaintings.resource.file.Migration;
import me.roundaround.custompaintings.resource.file.Painting;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.InvalidIdException;

public record CustomPaintingsJson(int format, String id, String name, String description, String sourceLegacyPack, List<Painting> paintings, List<Migration> migrations) {
    public void validateIds() throws InvalidIdException {
        CustomId.validatePart(this.id, "pack");
        int n = 0;
        for (Painting record : this.paintings) {
            record.validateId(n);
            ++n;
        }
        n = 0;
        for (Migration migration : this.migrations) {
            migration.validateIds(n);
            ++n;
        }
    }

    public static class TypeAdapter
    extends com.google.gson.TypeAdapter<CustomPaintingsJson> {
        private final Gson gson = new Gson();
        private final com.google.gson.TypeAdapter<Painting> paintingAdapter = this.gson.getAdapter(Painting.class);
        private final com.google.gson.TypeAdapter<Migration> migrationAdapter = this.gson.getAdapter(Migration.class);

        public void write(JsonWriter jsonWriter, CustomPaintingsJson customPaintingsJson) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name("format");
            jsonWriter.value((long)customPaintingsJson.format());
            jsonWriter.name("id");
            jsonWriter.value(customPaintingsJson.id());
            jsonWriter.name("name");
            jsonWriter.value(customPaintingsJson.name());
            if (customPaintingsJson.description() != null && !customPaintingsJson.description().isBlank()) {
                jsonWriter.name("description");
                jsonWriter.value(customPaintingsJson.description());
            }
            if (customPaintingsJson.sourceLegacyPack() != null && !customPaintingsJson.sourceLegacyPack().isBlank()) {
                jsonWriter.name("sourceLegacyPack");
                jsonWriter.value(customPaintingsJson.sourceLegacyPack());
            }
            jsonWriter.name("paintings");
            jsonWriter.beginArray();
            if (customPaintingsJson.paintings() != null) {
                for (Painting record : customPaintingsJson.paintings()) {
                    this.paintingAdapter.write(jsonWriter, (Object)record);
                }
            }
            jsonWriter.endArray();
            if (customPaintingsJson.migrations() != null && !customPaintingsJson.migrations().isEmpty()) {
                jsonWriter.name("migrations");
                jsonWriter.beginArray();
                for (Migration migration : customPaintingsJson.migrations()) {
                    this.migrationAdapter.write(jsonWriter, (Object)migration);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }

        public CustomPaintingsJson read(JsonReader jsonReader) throws IOException {
            int n = 1;
            String string = "";
            String string2 = "";
            String string3 = null;
            String string4 = null;
            ArrayList<Painting> arrayList = new ArrayList<Painting>();
            ArrayList<Migration> arrayList2 = new ArrayList<Migration>();
            jsonReader.beginObject();
            block18: while (jsonReader.hasNext()) {
                switch (jsonReader.nextName()) {
                    case "format": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        n = jsonReader.nextInt();
                        continue block18;
                    }
                    case "id": {
                        string = jsonReader.nextString();
                        continue block18;
                    }
                    case "name": {
                        string2 = jsonReader.nextString();
                        continue block18;
                    }
                    case "description": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        string3 = jsonReader.nextString();
                        continue block18;
                    }
                    case "sourceLegacyPack": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        string4 = jsonReader.nextString();
                        continue block18;
                    }
                    case "paintings": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            arrayList.add((Painting)this.paintingAdapter.read(jsonReader));
                        }
                        jsonReader.endArray();
                        continue block18;
                    }
                    case "migrations": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            arrayList2.add((Migration)this.migrationAdapter.read(jsonReader));
                        }
                        jsonReader.endArray();
                        continue block18;
                    }
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new CustomPaintingsJson(n, string, string2, string3, string4, List.copyOf(arrayList), List.copyOf(arrayList2));
        }
    }
}

