/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.client.gui.widget;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.roundaround.custompaintings.roundalib.client.gui.layout.LayoutHook;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.util.Spacing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_9017;

@Environment(value=EnvType.CLIENT)
public abstract class FlowListWidget<E extends Entry>
extends class_9017
implements class_8133 {
    protected static final int VANILLA_LIST_WIDTH_S = 220;
    protected static final int VANILLA_LIST_WIDTH_M = 280;
    protected static final int VANILLA_LIST_WIDTH_L = 340;
    protected static final int DEFAULT_SHADE_STRENGTH = 50;
    protected static final int DEFAULT_SHADE_STRENGTH_STRONG = 150;
    protected static final int DEFAULT_SHADE_FADE_WIDTH = 10;
    protected final class_310 client;
    protected final ThreeSectionLayoutWidget parentLayout;
    protected E hoveredEntry;
    protected E selected;
    protected Double scrollUnit;
    protected final LinkedList<E> entries = new LinkedList();
    protected boolean alternatingRowShading = false;
    protected int shadeFadeWidth = 10;
    protected int shadeStrength = 50;
    protected boolean autoPadForShading = true;
    protected int contentHeight = 0;
    protected Spacing contentPadding = Spacing.zero();
    protected int contentMargin = 4;
    protected int rowSpacing = 0;
    protected double scrollAmount = 0.0;
    protected boolean scrolling = false;
    protected int scrollbarX;

    protected FlowListWidget(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget) {
        super(0, threeSectionLayoutWidget.getHeaderHeight(), threeSectionLayoutWidget.method_25368(), threeSectionLayoutWidget.getBodyHeight(), class_5244.field_39003);
        this.client = class_3102;
        this.parentLayout = threeSectionLayoutWidget;
    }

    protected FlowListWidget(class_310 class_3102, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4, class_5244.field_39003);
        this.client = class_3102;
        this.parentLayout = null;
    }

    public <T extends E> T addEntry(EntryFactory<T> entryFactory) {
        E e;
        T t = entryFactory.create(this.entries.size(), this.getContentLeft(), this.getNextEntryTop(), this.getContentWidth());
        if (t == null) {
            return null;
        }
        ((Entry)t).setDefaultAlternatingRowShading(this.alternatingRowShading);
        ((Entry)t).setDefaultRowShadeFadeWidth(this.shadeFadeWidth);
        ((Entry)t).setDefaultRowShadeStrength(this.shadeStrength);
        ((Entry)t).setDefaultAutoPadForShading(this.autoPadForShading);
        boolean bl = this.isScrollbarVisible();
        this.entries.add(t);
        this.calculateContentHeight();
        if (this.isScrollbarVisible() && !bl) {
            this.method_48222();
        }
        if ((e = this.getSelected()) != null) {
            this.ensureVisible(e);
        }
        return t;
    }

    public E removeEntry() {
        E e;
        if (this.entries.isEmpty()) {
            return null;
        }
        boolean bl = this.isScrollbarVisible();
        Entry entry = (Entry)this.entries.removeLast();
        this.calculateContentHeight();
        if (!this.isScrollbarVisible() && bl) {
            this.method_48222();
        }
        if ((e = this.getSelected()) == entry) {
            this.setSelected(null);
        } else if (e != null) {
            this.ensureVisible(e);
        }
        return (E)entry;
    }

    public void clearEntries() {
        this.entries.clear();
        this.contentHeight = this.contentPadding.getVertical();
        this.scrollAmount = 0.0;
        this.selected = null;
    }

    public List<E> method_25396() {
        return this.entries;
    }

    public E getEntry(int n) {
        return (E)((Entry)this.entries.get(n));
    }

    public E getFirst() {
        return (E)((Entry)this.entries.getFirst());
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public void forEachEntry(Consumer<E> consumer) {
        this.entries.forEach(consumer);
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.entries.forEach(consumer);
    }

    public void method_48222() {
        if (this.parentLayout != null) {
            this.method_55444(this.parentLayout.method_25368(), this.parentLayout.getBodyHeight(), 0, this.parentLayout.getHeaderHeight());
        }
        this.calculateContentHeight();
        this.calculateScrollbarX();
        int n = this.getContentTop();
        for (Entry entry : this.entries) {
            entry.method_48229(this.getContentLeft(), n);
            entry.setWidth(this.getContentWidth());
            n += entry.method_25364() + this.rowSpacing;
        }
        this.setScrollAmount(this.getScrollAmount());
        super.method_48222();
    }

    protected void calculateContentHeight() {
        this.contentHeight = this.contentPadding.getVertical() + this.entries.stream().mapToInt(Entry::method_25364).sum() + Math.max(0, this.getEntryCount() - 1) * this.rowSpacing;
    }

    protected void calculateScrollbarX() {
        this.scrollbarX = this.getContentRight() + this.contentMargin;
    }

    public void method_48579(class_332 class_3322, int n, int n2, float f) {
        this.hoveredEntry = this.getEntryAtPosition(n, n2);
        this.renderListBackground(class_3322);
        this.renderList(class_3322, n, n2, f);
        this.renderListBorders(class_3322);
    }

    protected void renderListBackground(class_332 class_3322) {
        class_3322.method_25290(class_10799.field_56883, Textures.listBg(this.client), this.method_46426(), this.method_46427(), (float)this.method_55442(), (float)(this.method_55443() + (int)this.getScrollAmount()), this.method_25368(), this.method_25364(), 32, 32);
    }

    protected void renderList(class_332 class_3322, int n, int n2, float f) {
        class_3322.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        this.renderEntries(class_3322, n, n2, f);
        this.renderScrollBar(class_3322);
        class_3322.method_44380();
    }

    protected void renderEntries(class_332 class_3322, int n, int n2, float f) {
        this.entries.forEach(entry -> {
            if (!this.isEntryVisible(entry)) {
                return;
            }
            this.renderEntry(class_3322, n, n2, f, entry);
        });
    }

    protected void renderEntry(class_332 class_3322, int n, int n2, float f, E e) {
        ((Entry)e).method_25394(class_3322, n, n2, f);
    }

    protected void renderScrollBar(class_332 class_3322) {
        if (!this.isScrollbarVisible()) {
            return;
        }
        int n = this.getScrollbarHandleHeight();
        double d = this.getScrollAmount() / (double)this.getMaxScroll();
        int n2 = this.method_25364() - n;
        int n3 = this.method_46427() + (int)Math.round(d * (double)n2);
        class_3322.method_52706(class_10799.field_56883, Textures.SCROLLBAR_BG, this.scrollbarX, this.method_46427(), 6, this.method_25364());
        class_3322.method_52706(class_10799.field_56883, Textures.SCROLLBAR, this.scrollbarX, n3, 6, n);
    }

    protected void renderListBorders(class_332 class_3322) {
        class_3322.method_25290(class_10799.field_56883, Textures.borderTop(this.client), this.method_46426(), this.method_46427() - 2, 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
        class_3322.method_25290(class_10799.field_56883, Textures.borderBottom(this.client), this.method_46426(), this.method_55443(), 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
    }

    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    public void method_25395(class_364 class_3642) {
        super.method_25395(class_3642);
        if (class_3642 instanceof Entry) {
            Entry entry = (Entry)class_3642;
            this.setSelected(entry);
            if (this.client.method_48186().method_48183()) {
                this.ensureVisible(entry);
            }
        }
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E e) {
        this.selected = e;
    }

    protected boolean isSelectedEntry(int n) {
        return Objects.equals(this.getSelected(), this.method_25396().get(n));
    }

    public void selectFirst() {
        if (this.getEntryCount() > 0) {
            this.setSelected(this.getEntry(0));
        }
    }

    protected E getNeighboringEntry(class_8028 class_80282) {
        return (E)this.getNeighboringEntry(class_80282, entry -> true);
    }

    protected E getNeighboringEntry(class_8028 class_80282, Predicate<E> predicate) {
        return this.getNeighboringEntry(class_80282, predicate, this.getSelected());
    }

    protected E getNeighboringEntry(class_8028 class_80282, Predicate<E> predicate, E e) {
        int n;
        if (this.entries.isEmpty()) {
            return null;
        }
        switch (class_80282) {
            case field_41826: {
                int n2 = -1;
                break;
            }
            case field_41827: {
                int n2 = 1;
                break;
            }
            default: {
                int n2 = n = 0;
            }
        }
        if (n == 0) {
            return null;
        }
        int n3 = e == null ? (n > 0 ? 0 : this.entries.size() - 1) : ((Entry)e).getIndex() + n;
        for (int i = n3; i >= 0 && i < this.entries.size(); i += n) {
            Entry entry = (Entry)this.entries.get(i);
            if (!predicate.test(entry)) continue;
            return (E)entry;
        }
        return null;
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.getHoveredEntry() != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    protected E getHoveredEntry() {
        return this.hoveredEntry;
    }

    protected void appendNarrations(class_6382 class_63822, E e) {
        int n = this.getEntryCount();
        if (n > 1) {
            int n2 = ((Entry)e).getIndex() + 1;
            class_63822.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{n2, n}));
        }
    }

    public boolean method_25405(double d, double d2) {
        return d >= (double)this.method_46426() && d <= (double)this.method_55442() && d2 >= (double)this.method_46427() && d2 <= (double)this.method_55443();
    }

    protected boolean isSelectButton(int n) {
        return n == 0;
    }

    public boolean method_25402(double d, double d2, int n) {
        if (!this.isSelectButton(n)) {
            return false;
        }
        this.updateScrollingState(d, d2, n);
        if (!this.method_25405(d, d2)) {
            return false;
        }
        E e = this.getEntryAtPosition(d, d2);
        if (e != null && e.method_25402(d, d2, n)) {
            E e2 = this.getFocused();
            if (e2 != e && e2 instanceof class_4069) {
                class_4069 class_40692 = (class_4069)e2;
                class_40692.method_25395(null);
            }
            this.method_25395((class_364)e);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double d, double d2, int n) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(d, d2, n);
        }
        return false;
    }

    public boolean method_25403(double d, double d2, int n, double d3, double d4) {
        if (super.method_25403(d, d2, n, d3, d4)) {
            return true;
        }
        if (n != 0 || !this.scrolling) {
            return false;
        }
        if (d2 < (double)this.method_46427()) {
            this.setScrollAmount(0.0);
        } else if (d2 > (double)this.method_55443()) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d5 = Math.max(1, this.getMaxScroll());
            int n2 = this.method_25364() - this.getScrollbarHandleHeight();
            double d6 = Math.max(1.0, d5 / (double)n2);
            this.setScrollAmount(this.getScrollAmount() + d4 * d6);
        }
        return true;
    }

    public boolean method_25401(double d, double d2, double d3, double d4) {
        E e;
        if (this.allowScrollPassThrough() && (e = this.getEntryAtPosition(d, d2)) != null && e.method_25401(d, d2, d3, d4)) {
            return true;
        }
        this.setScrollAmount(this.getScrollAmount() - d4 * this.getScrollUnit());
        return true;
    }

    protected boolean allowScrollPassThrough() {
        return false;
    }

    protected E getEntryAtPosition(double d, double d2) {
        if (!this.method_25405(d, d2)) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!entry.method_25405(d, d2)) continue;
            return (E)entry;
        }
        return null;
    }

    protected boolean isEntryVisible(E e) {
        return ((Entry)e).method_46427() <= this.getContentBottom() && ((Entry)e).getBottom() >= this.getContentTop();
    }

    protected void centerScrollOn(E e) {
        this.setScrollAmount((double)((Entry)e).getContentCenterY() - (double)this.field_22759 * 0.5);
    }

    protected void ensureVisible(E e) {
        if (((Entry)e).method_46427() < this.getContentTop()) {
            this.scroll(((Entry)e).method_46427() - this.getContentTop());
            return;
        }
        if (((Entry)e).getBottom() > this.getContentBottom()) {
            this.scroll(((Entry)e).getBottom() - this.getContentBottom());
        }
    }

    protected boolean isScrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected int method_44395() {
        return this.getContentHeight();
    }

    public void setContentPaddingX(int n) {
        this.contentPadding = this.contentPadding.setHorizontal(n);
    }

    public void setContentPaddingY(int n) {
        this.contentPadding = this.contentPadding.setVertical(n);
    }

    public void setContentPadding(int n) {
        this.contentPadding = Spacing.of(n);
    }

    public void setContentPadding(Spacing spacing) {
        this.contentPadding = spacing;
    }

    public void setRowSpacing(int n) {
        this.rowSpacing = n;
    }

    public int getContentWidth() {
        return Math.min(this.getPreferredContentWidth(), this.getMaxContentWidth());
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getContentTop() {
        return this.method_46427() + this.contentPadding.top();
    }

    public int getContentBottom() {
        return this.method_55443() - this.contentPadding.bottom();
    }

    public int getContentLeft() {
        if (this.doesContentFillWidth()) {
            return this.method_46426() + this.getContentMarginLeft();
        }
        return this.method_46426() + (this.method_25368() - this.getContentWidth()) / 2;
    }

    public int getContentRight() {
        if (this.doesContentFillWidth()) {
            return this.method_55442() - this.getContentMarginRight();
        }
        return this.method_46426() + (this.method_25368() + this.getContentWidth()) / 2;
    }

    protected int getNextEntryTop() {
        if (this.entries.isEmpty()) {
            return this.getContentTop();
        }
        return ((Entry)this.entries.getLast()).getBottom() + this.rowSpacing;
    }

    protected int getPreferredContentWidth() {
        if (this.parentLayout == null || this.method_25368() <= 220) {
            return this.method_25368();
        }
        if (this.method_25368() < 340) {
            return 280;
        }
        return 340;
    }

    protected int getFullGutterWidth() {
        if (!this.isScrollbarVisible()) {
            return this.contentMargin;
        }
        return 6 + 2 * this.contentMargin;
    }

    protected boolean doesContentFillWidth() {
        return this.getPreferredContentWidth() >= this.method_25368() - 2 * this.getFullGutterWidth();
    }

    protected int getGutterWidth() {
        if (!this.isScrollbarVisible()) {
            return this.contentMargin;
        }
        return 6 + (this.doesContentFillWidth() ? 1 : 2) * this.contentMargin;
    }

    protected int getContentMarginLeft() {
        return this.doesContentFillWidth() ? this.contentMargin : this.getGutterWidth();
    }

    protected int getContentMarginRight() {
        return this.getGutterWidth();
    }

    protected int getMaxContentWidth() {
        return this.method_25368() - this.getContentMarginLeft() - this.getContentMarginRight();
    }

    protected int getScrollbarHandleHeight() {
        int n = this.method_25364();
        return class_3532.method_15340((int)(n * n / this.getContentHeight()), (int)32, (int)(n - 8));
    }

    protected void scroll(int n) {
        this.setScrollAmount(this.getScrollAmount() + (double)n);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double d) {
        this.scrollAmount = class_3532.method_15350((double)d, (double)0.0, (double)this.getMaxScroll());
        this.entries.forEach(entry -> entry.setScrollAmount(this.getScrollAmount()));
    }

    public void refreshScrollAmount() {
        this.scrollAmount = class_3532.method_15350((double)this.getScrollAmount(), (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - this.method_25364());
    }

    protected void updateScrollingState(double d, double d2, int n) {
        this.scrolling = n == 0 && d >= (double)this.scrollbarX && d < (double)(this.scrollbarX + 6);
    }

    protected double method_44393() {
        return this.getScrollUnit();
    }

    protected double getScrollUnit() {
        if (this.scrollUnit != null) {
            return this.scrollUnit;
        }
        double d = (double)this.contentHeight / (double)this.entries.size();
        return d / 2.0;
    }

    protected void setAlternatingRowShading(boolean bl) {
        this.alternatingRowShading = bl;
        this.forEachEntry(entry -> entry.setAlternatingRowShading(this.alternatingRowShading));
    }

    protected void setRowShadeFadeWidth(int n) {
        this.shadeFadeWidth = Math.max(n, 0);
        this.forEachEntry(entry -> entry.setRowShadeFadeWidth(this.shadeFadeWidth));
    }

    protected void setRowShadeStrength(int n) {
        this.shadeStrength = Math.clamp((long)n, 0, 255);
        this.forEachEntry(entry -> entry.setRowShadeStrength(this.shadeStrength));
    }

    protected void setRowShadeStrength(float f) {
        this.setRowShadeStrength((int)(f * 255.0f));
    }

    protected void setAutoPadForShading(boolean bl) {
        this.autoPadForShading = bl;
        this.forEachEntry(entry -> entry.setAutoPadForShading(this.autoPadForShading));
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface EntryFactory<E extends Entry> {
        public E create(int var1, int var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    implements class_4068,
    class_8133,
    class_364 {
        protected static final Spacing DEFAULT_MARGIN = Spacing.of(2);
        protected final ArrayList<LayoutRef<?>> layouts = new ArrayList();
        protected final ArrayList<class_4068> drawables = new ArrayList();
        protected final int index;
        protected final int contentHeight;
        protected int x;
        protected int y;
        protected int width;
        protected double scrollAmount = 0.0;
        protected Spacing margin = DEFAULT_MARGIN;
        private boolean defaultForceRowShading = false;
        private boolean defaultAlternatingRowShading = false;
        private int defaultShadeFadeWidth = 10;
        private int defaultShadeStrength = 50;
        private boolean defaultAutoPadForShading = true;
        private Boolean forceRowShading = null;
        private Boolean alternatingRowShading = null;
        private Integer shadeFadeWidth = null;
        private Integer shadeStrength = null;
        private Boolean autoPadForShading = null;

        protected Entry(int n, int n2, int n3, int n4, int n5) {
            this.index = n;
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.contentHeight = n5;
        }

        protected <T extends class_8133> T addLayout(T t) {
            return this.addLayout(t, LayoutHook.noop());
        }

        protected <T extends class_8133> T addLayout(T t, LayoutHook<T> layoutHook) {
            this.layouts.add(new LayoutRef<T>(t, layoutHook));
            return t;
        }

        protected <T extends class_4068> T addDrawable(T t) {
            this.drawables.add(t);
            return t;
        }

        protected void clearChildren() {
            this.layouts.clear();
            this.drawables.clear();
        }

        public List<class_4068> drawables() {
            return this.drawables;
        }

        public List<? extends class_8133> layoutWidgets() {
            return this.layouts.stream().map(LayoutRef::getLayout).toList();
        }

        public void method_48227(Consumer<class_8021> consumer) {
            this.layouts.forEach((Consumer<LayoutRef<?>>)((Consumer<LayoutRef>)layoutRef -> consumer.accept((class_8021)layoutRef.getLayout())));
        }

        public void method_48222() {
            this.layouts.forEach((Consumer<LayoutRef<?>>)((Consumer<LayoutRef>)LayoutRef::refreshPositions));
        }

        public void method_25394(class_332 class_3322, int n, int n2, float f) {
            this.renderBackground(class_3322, n, n2, f);
            this.renderContent(class_3322, n, n2, f);
            this.renderDecorations(class_3322, n, n2, f);
        }

        protected void renderBackground(class_332 class_3322, int n, int n2, float f) {
            if (this.hasRowShading()) {
                this.renderRowShade(class_3322);
            }
        }

        protected void renderRowShade(class_332 class_3322) {
            Entry.renderRowShade(class_3322, this.method_46426(), this.method_46427(), this.getRight(), this.getBottom(), this.getRowShadeFadeWidth(), this.getRowShadeStrength());
        }

        protected static void renderRowShade(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6) {
            int n7 = GuiUtil.genColorInt(0, 0, 0, n6);
            GuiUtil.fillHorizontalGradient(class_3322, n, n2, n + n5, n4, 0, n7);
            class_3322.method_25294(n + n5, n2, n3 - n5, n4, n7);
            GuiUtil.fillHorizontalGradient(class_3322, n3 - n5, n2, n3, n4, n7, 0);
        }

        protected void renderContent(class_332 class_3322, int n, int n2, float f) {
            this.drawables.forEach(class_40682 -> class_40682.method_25394(class_3322, n, n2, f));
        }

        protected void renderDecorations(class_332 class_3322, int n, int n2, float f) {
        }

        protected void setScrollAmount(double d) {
            this.scrollAmount = d;
            this.method_48222();
        }

        public boolean method_25405(double d, double d2) {
            return d >= (double)this.method_46426() && d <= (double)this.getRight() && d2 >= (double)this.method_46427() && d2 <= (double)this.getBottom();
        }

        public class_8030 method_48202() {
            return new class_8030(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }

        public int getIndex() {
            return this.index;
        }

        public int method_25368() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int method_25364() {
            return this.getContentHeight() + this.margin.getVertical();
        }

        public int method_46426() {
            return this.x;
        }

        public void method_46421(int n) {
            this.x = n;
        }

        public int method_46427() {
            return this.y - (int)this.scrollAmount;
        }

        public void method_46419(int n) {
            this.y = n;
        }

        public int getRight() {
            return this.method_46426() + this.method_25368();
        }

        public int getBottom() {
            return this.method_46427() + this.method_25364();
        }

        public void setMarginY(int n) {
            this.margin = this.margin.setVertical(n);
        }

        public void setMarginX(int n) {
            this.margin = this.margin.setHorizontal(n);
        }

        public void setMargin(int n) {
            this.margin = Spacing.of(n);
        }

        public void setMargin(Spacing spacing) {
            this.margin = spacing;
        }

        public int getContentLeft() {
            return this.method_46426() + this.margin.left() + this.getShadingPadding();
        }

        public int getContentRight() {
            return this.getRight() - this.margin.right() - this.getShadingPadding();
        }

        public int getContentWidth() {
            return this.method_25368() - this.margin.getHorizontal() - 2 * this.getShadingPadding();
        }

        public int getContentTop() {
            return this.method_46427() + this.margin.top();
        }

        public int getContentBottom() {
            return this.getBottom() - this.margin.bottom();
        }

        public int getContentHeight() {
            return this.contentHeight;
        }

        public int getContentCenterX() {
            return this.getContentLeft() + this.getContentWidth() / 2;
        }

        public int getContentCenterY() {
            return this.getContentTop() + this.getContentHeight() / 2;
        }

        public int getShadingPadding() {
            return (this.getAlternatingRowShading() || this.getForceRowShading()) && this.getAutoPadForShading() ? this.getRowShadeFadeWidth() : 0;
        }

        public boolean hasRowShading() {
            return this.getAlternatingRowShading() && this.index % 2 == 0 || this.getForceRowShading();
        }

        protected void setForceRowShading(boolean bl) {
            this.forceRowShading = bl;
        }

        protected void setDefaultForceRowShading(boolean bl) {
            this.defaultForceRowShading = bl;
        }

        protected boolean getForceRowShading() {
            return Entry.valueOrDefault(this.forceRowShading, this.defaultForceRowShading);
        }

        protected void setAlternatingRowShading(boolean bl) {
            this.alternatingRowShading = bl;
        }

        protected void setDefaultAlternatingRowShading(boolean bl) {
            this.defaultAlternatingRowShading = bl;
        }

        protected boolean getAlternatingRowShading() {
            return Entry.valueOrDefault(this.alternatingRowShading, this.defaultAlternatingRowShading);
        }

        protected void setRowShadeFadeWidth(int n) {
            this.shadeFadeWidth = n;
        }

        protected void setDefaultRowShadeFadeWidth(int n) {
            this.defaultShadeFadeWidth = n;
        }

        protected int getRowShadeFadeWidth() {
            return Entry.valueOrDefault(this.shadeFadeWidth, this.defaultShadeFadeWidth);
        }

        protected void setRowShadeStrength(int n) {
            this.shadeStrength = n;
        }

        protected void setDefaultRowShadeStrength(int n) {
            this.defaultShadeStrength = n;
        }

        protected int getRowShadeStrength() {
            return Entry.valueOrDefault(this.shadeStrength, this.defaultShadeStrength);
        }

        protected void setAutoPadForShading(boolean bl) {
            this.autoPadForShading = bl;
        }

        protected void setDefaultAutoPadForShading(boolean bl) {
            this.defaultAutoPadForShading = bl;
        }

        protected boolean getAutoPadForShading() {
            return Entry.valueOrDefault(this.autoPadForShading, this.defaultAutoPadForShading);
        }

        private static <T> T valueOrDefault(T t, T t2) {
            return t == null ? t2 : t;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Textures {
        public static final class_2960 SCROLLBAR_BG = class_2960.method_60656((String)"widget/scroller_background");
        public static final class_2960 SCROLLBAR = class_2960.method_60656((String)"widget/scroller");
        public static final class_2960 LIST_BG = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
        public static final class_2960 BORDER_TOP = class_437.field_49895;
        public static final class_2960 BORDER_BOTTOM = class_437.field_49896;
        public static final class_2960 IN_WORLD_LIST_BG = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
        public static final class_2960 IN_WORLD_BORDER_TOP = class_437.field_49897;
        public static final class_2960 IN_WORLD_BORDER_BOTTOM = class_437.field_49898;

        public static class_2960 borderTop(class_310 class_3102) {
            return class_3102.field_1687 == null ? BORDER_TOP : IN_WORLD_BORDER_TOP;
        }

        public static class_2960 borderBottom(class_310 class_3102) {
            return class_3102.field_1687 == null ? BORDER_BOTTOM : IN_WORLD_BORDER_BOTTOM;
        }

        public static class_2960 listBg(class_310 class_3102) {
            return class_3102.field_1687 == null ? LIST_BG : IN_WORLD_LIST_BG;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class LayoutRef<T extends class_8133> {
        private final T layout;
        private final LayoutHook<T> hook;

        public LayoutRef(T t, LayoutHook<T> layoutHook) {
            this.layout = t;
            this.hook = layoutHook;
        }

        public T getLayout() {
            return this.layout;
        }

        public void refreshPositions() {
            if (this.hook != null) {
                this.hook.run(this.layout);
            }
            this.layout.method_48222();
        }
    }
}

