/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server.network;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.network.Networking;
import me.roundaround.custompaintings.network.PaintingAssignment;
import me.roundaround.custompaintings.server.CustomPaintingsServerMod;
import me.roundaround.custompaintings.server.ServerInfo;
import me.roundaround.custompaintings.server.ServerPaintingManager;
import me.roundaround.custompaintings.server.registry.ServerPaintingRegistry;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class ServerNetworking {
    private ServerNetworking() {
    }

    public static void sendSummaryPacketToAll(MinecraftServer minecraftServer, List<PackData> list, String string, Map<CustomId, Boolean> map, boolean bl, int n) {
        minecraftServer.method_3760().method_14571().forEach(class_32222 -> ServerNetworking.sendSummaryPacket(class_32222, list, string, map, bl, n));
    }

    public static void sendSummaryPacket(class_3222 class_32222, List<PackData> list, String string, Map<CustomId, Boolean> map, boolean bl, int n) {
        if (!ServerPlayNetworking.canSend((class_3222)class_32222, (class_2960)Networking.SUMMARY_S2C)) {
            class_32222.method_64398(CustomPaintingsServerMod.getDownloadPrompt());
            return;
        }
        UUID uUID = ServerInfo.getInstance().getServerId();
        ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.SummaryS2C(uUID, list, string, map, bl, n));
    }

    public static void sendDownloadSummaryPacket(class_3222 class_32222, Collection<CustomId> collection, int n, int n2) {
        ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.DownloadSummaryS2C(collection.stream().toList(), n, n2));
    }

    public static void sendEditPaintingPacket(class_3222 class_32222, UUID uUID, int n, class_2338 class_23382, class_2350 class_23502) {
        ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.EditPaintingS2C(uUID, n, class_23382, class_23502));
    }

    public static void sendSetPaintingPacketToAll(class_3218 class_32182, PaintingAssignment paintingAssignment) {
        Networking.SetPaintingS2C setPaintingS2C = new Networking.SetPaintingS2C(paintingAssignment);
        class_32182.method_18456().forEach(class_32222 -> ServerNetworking.sendSetPaintingPacket(class_32222, setPaintingS2C));
    }

    public static void sendSetPaintingPacket(class_3222 class_32222, Networking.SetPaintingS2C setPaintingS2C) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, setPaintingS2C.method_56479())) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)setPaintingS2C);
        }
    }

    public static void sendSyncAllDataPacket(class_3222 class_32222, List<PaintingAssignment> list) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.SyncAllDataS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.SyncAllDataS2C(list));
        }
    }

    public static void sendMigrationFinishPacketToAll(MinecraftServer minecraftServer, CustomId customId, boolean bl) {
        Networking.MigrationFinishS2C migrationFinishS2C = new Networking.MigrationFinishS2C(customId, bl);
        minecraftServer.method_3760().method_14571().forEach(class_32222 -> ServerNetworking.sendMigrationFinishPacket(class_32222, migrationFinishS2C));
    }

    public static void sendMigrationFinishPacket(class_3222 class_32222, Networking.MigrationFinishS2C migrationFinishS2C) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.MigrationFinishS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)migrationFinishS2C);
        }
    }

    public static void sendOpenMenuPacket(class_3222 class_32222) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.OpenMenuS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.OpenMenuS2C());
        }
    }

    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(Networking.HashesC2S.ID, ServerNetworking::handleHashes);
        ServerPlayNetworking.registerGlobalReceiver(Networking.ReloadC2S.ID, ServerNetworking::handleReload);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetPaintingC2S.ID, ServerNetworking::handleSetPainting);
        ServerPlayNetworking.registerGlobalReceiver(Networking.RunMigrationC2S.ID, ServerNetworking::handleRunMigration);
    }

    private static void handleHashes(Networking.HashesC2S hashesC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ServerPaintingRegistry.getInstance().checkPlayerHashes(context.player(), hashesC2S.hashes()));
    }

    private static void handleReload(Networking.ReloadC2S reloadC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (!context.player().method_64475(3)) {
                return;
            }
            ServerInfo serverInfo = ServerInfo.getInstance();
            for (String string : reloadC2S.toActivate()) {
                serverInfo.markPackEnabled(string);
            }
            for (String string : reloadC2S.toDeactivate()) {
                serverInfo.markPackDisabled(string);
            }
            ServerPaintingRegistry.getInstance().reloadPaintingPacks(ServerPaintingManager::syncAllDataForAllPlayers);
        });
    }

    private static void handleSetPainting(Networking.SetPaintingC2S setPaintingC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 class_32222 = context.player();
            class_3218 class_32182 = class_32222.method_51469();
            class_1297 class_12972 = class_32182.method_8469(setPaintingC2S.paintingId());
            if (!(class_12972 instanceof class_1534)) {
                return;
            }
            class_1534 class_15342 = (class_1534)class_12972;
            if (class_15342.custompaintings$getEditor() == null || !class_15342.custompaintings$getEditor().equals(class_32222.method_5667())) {
                return;
            }
            PaintingData paintingData = ServerPaintingRegistry.getInstance().get(setPaintingC2S.dataId());
            if (paintingData == null || paintingData.isEmpty()) {
                class_15342.custompaintings$setEditor(null);
                class_15342.method_64397(class_32182, class_32222.method_48923().method_48802((class_1657)class_32222), 0.0f);
                return;
            }
            if (paintingData.vanilla()) {
                class_15342.custompaintings$setVariant(paintingData.id());
            }
            class_15342.custompaintings$setData(paintingData);
            if (!class_15342.method_6888()) {
                class_15342.custompaintings$setEditor(null);
                class_15342.method_64397(class_32182, class_32222.method_48923().method_48802((class_1657)class_32222), 0.0f);
                return;
            }
            class_32182.custompaintings$getPaintingManager().setPaintingData(class_15342, paintingData);
            class_15342.custompaintings$setEditor(null);
        });
    }

    private static void handleRunMigration(Networking.RunMigrationC2S runMigrationC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ServerPaintingManager.runMigration(context.player(), runMigrationC2S.id()));
    }
}

