/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource;

import java.util.HashMap;
import java.util.List;
import me.roundaround.custompaintings.entity.decoration.painting.MigrationData;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.InvalidIdException;

public record MigrationResource(String id, String description, List<List<String>> pairs) {
    public MigrationData toData(String string) {
        HashMap<CustomId, CustomId> hashMap = new HashMap<CustomId, CustomId>();
        this.pairs.forEach(list -> hashMap.put(CustomId.parse((String)list.getFirst()), CustomId.parse((String)list.getLast())));
        hashMap.entrySet().removeIf(entry -> entry.getKey() == null || entry.getValue() == null);
        return new MigrationData(new CustomId(string, this.id), this.description, hashMap);
    }

    public void validateIds(int n) throws InvalidIdException {
        CustomId.validatePart(this.id, this.migrationErrorStr(n));
        int n2 = 0;
        for (List<String> list : this.pairs) {
            CustomId.validate(list.getFirst(), this.pairErrorStr("from", n, n2));
            CustomId.validate(list.getLast(), this.pairErrorStr("to", n, n2));
            ++n2;
        }
    }

    private String migrationErrorStr(int n) {
        return String.format("migration at index %s", n);
    }

    private String pairErrorStr(String string, int n, int n2) {
        return String.format("'%s' painting in pair at index %s in %s", string, n2, this.migrationErrorStr(n));
    }
}

