/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_9139;

public record Image(Color[] pixels, int width, int height, String hash) {
    public static final class_9139<ByteBuf, Image> PACKET_CODEC = class_9139.method_56438(Image::writeToByteBuf, Image::fromByteBuf);

    public static Image empty() {
        return new Image(new Color[0], 0, 0, "");
    }

    public static Image fromBytes(byte[] byArray, int n, int n2) {
        int n3 = n * n2;
        if (byArray.length < n3 * 4) {
            byArray = Arrays.copyOf(byArray, n3 * 4);
        }
        Color[] colorArray = new Color[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = i * 4;
            colorArray[i] = new Color(byArray[n4], byArray[n4 + 1], byArray[n4 + 2], byArray[n4 + 3]);
        }
        return new Image(colorArray, n, n2, Image.getHash(byArray));
    }

    public static Image fromPixels(Color[] colorArray, int n, int n2) {
        return new Image(colorArray, n, n2, Image.getHash(colorArray));
    }

    public static Image read(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Color[] colorArray = new Color[n * n2];
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                colorArray[Image.getIndex((int)n2, (int)i, (int)j)] = Color.fromARGB(nArray[j * n + i]);
            }
        }
        return new Image(colorArray, n, n2, Image.getHash(colorArray));
    }

    public static Image read(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        return Image.read(bufferedImage);
    }

    public static Image read(byte[] byArray) throws IOException {
        return Image.read(new ByteArrayInputStream(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.hash.equals(image.hash) && this.width == image.width && this.height == image.height;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hash, this.width, this.height);
    }

    public BufferedImage toBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                bufferedImage.setRGB(i, j, this.getARGB(i, j));
            }
        }
        return bufferedImage;
    }

    public class_1011 toNativeImage() {
        class_1011 class_10112 = new class_1011(this.width(), this.height(), false);
        for (int i = 0; i < this.width(); ++i) {
            for (int j = 0; j < this.height(); ++j) {
                class_10112.method_61941(i, j, this.getARGB(i, j));
            }
        }
        return class_10112;
    }

    public byte[] getBytes() {
        return Image.getBytes(this.pixels);
    }

    public int getSize() {
        return this.pixels.length * 4;
    }

    public ByteSource getByteSource() {
        return ByteSource.wrap((byte[])this.getBytes());
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public int getARGB(int n, int n2) {
        return this.getColorInt(n, n2, Color::getARGB);
    }

    public int getABGR(int n, int n2) {
        return this.getColorInt(n, n2, Color::getABGR);
    }

    public Color getPixel(int n, int n2) {
        return this.getPixel(n, n2, Color.transparent());
    }

    public Color getPixel(int n, int n2, Color color) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return color;
        }
        return this.pixels[Image.getIndex(this.height, n, n2)];
    }

    public Image apply(Operation ... operationArray) {
        Hashless hashless = Hashless.fromImage(this);
        for (Operation operation : operationArray) {
            hashless = operation.apply(hashless);
        }
        return hashless.toImage();
    }

    public Image apply(Iterable<Operation> iterable) {
        Hashless hashless = Hashless.fromImage(this);
        for (Operation operation : iterable) {
            hashless = operation.apply(hashless);
        }
        return hashless.toImage();
    }

    public static int getIndex(int n, int n2, int n3) {
        return n2 * n + n3;
    }

    private int getColorInt(int n, int n2, Function<Color, Integer> function) {
        int n3 = this.getIndex(n, n2);
        Color color = this.pixels[n3];
        if (color == null) {
            return 0;
        }
        return function.apply(color);
    }

    private int getIndex(int n, int n2) {
        return Image.getIndex(this.height, n, n2);
    }

    private static byte[] getBytes(Color[] colorArray) {
        byte[] byArray = new byte[colorArray.length * 4];
        for (int i = 0; i < colorArray.length; ++i) {
            byArray[i * 4] = colorArray[i].r;
            byArray[i * 4 + 1] = colorArray[i].g;
            byArray[i * 4 + 2] = colorArray[i].b;
            byArray[i * 4 + 3] = colorArray[i].a;
        }
        return byArray;
    }

    private static String getHash(byte[] byArray) {
        try {
            return ByteSource.wrap((byte[])byArray).hash(Hashing.sha256()).toString();
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Exception raised while generating hash.", (Throwable)iOException);
            return "";
        }
    }

    private static String getHash(Color[] colorArray) {
        return Image.getHash(Image.getBytes(colorArray));
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.width);
        byteBuf.writeInt(this.height);
        byteBuf.writeBytes(this.getBytes());
    }

    public static Image fromByteBuf(ByteBuf byteBuf) {
        int n = byteBuf.readInt();
        int n2 = byteBuf.readInt();
        byte[] byArray = new byte[n * n2 * 4];
        byteBuf.readBytes(byArray);
        return Image.fromBytes(byArray, n, n2);
    }

    public static Color[] generateEmpty(int n, int n2) {
        return Image.generateEmpty(n * n2);
    }

    public static Color[] generateEmpty(int n) {
        Color[] colorArray = new Color[n];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = Color.transparent();
        }
        return colorArray;
    }

    public record Color(byte r, byte g, byte b, byte a) {
        public Color(int n, int n2, int n3, int n4) {
            this((byte)n, (byte)n2, (byte)n3, (byte)n4);
        }

        public static Color fromARGB(int n) {
            return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, n >> 24 & 0xFF);
        }

        public static Color transparent() {
            return new Color(0, 0, 0, 0);
        }

        public Color copy() {
            return new Color(this.r, this.g, this.b, this.a);
        }

        public int getARGB() {
            return Color.getAsInt(this.a, this.r, this.g, this.b);
        }

        public int getABGR() {
            return Color.getAsInt(this.a, this.b, this.g, this.r);
        }

        public Color invert() {
            return new Color(255 - this.getRed(), 255 - this.getGreen(), 255 - this.getBlue(), this.getAlpha());
        }

        public Color darken(float f) {
            int n = (int)(f * 255.0f);
            return new Color(Math.max(0, this.getRed() - n), Math.max(0, this.getGreen() - n), Math.max(0, this.getBlue() - n), this.getAlpha());
        }

        public Color removeAlpha() {
            return new Color((int)this.r, (int)this.g, (int)this.b, -1);
        }

        public boolean isTransparent() {
            return this.a == 0;
        }

        public int getRed() {
            return this.r & 0xFF;
        }

        public int getGreen() {
            return this.g & 0xFF;
        }

        public int getBlue() {
            return this.b & 0xFF;
        }

        public int getAlpha() {
            return this.a & 0xFF;
        }

        public float getRedFloat() {
            return (float)this.getRed() / 255.0f;
        }

        public float getGreenFloat() {
            return (float)this.getGreen() / 255.0f;
        }

        public float getBlueFloat() {
            return (float)this.getBlue() / 255.0f;
        }

        public float getAlphaFloat() {
            return (float)this.getAlpha() / 255.0f;
        }

        public static Color layer(Color color, Color color2) {
            if (color.isTransparent()) {
                return color2;
            }
            if (color2.isTransparent()) {
                return color;
            }
            float f = color.getAlphaFloat();
            float f2 = color2.getAlphaFloat();
            float f3 = f + f2 * (1.0f - f);
            return new Color(Color.floatToInt((float)color.getRed() * f + (float)color2.getRed() * f2 * (1.0f - f) / f3), Color.floatToInt((float)color.getGreen() * f + (float)color2.getGreen() * f2 * (1.0f - f) / f3), Color.floatToInt((float)color.getBlue() * f + (float)color2.getBlue() * f2 * (1.0f - f) / f3), Color.floatToInt(f3));
        }

        public static Color average(Color ... colorArray) {
            return Color.average(Arrays.asList(colorArray));
        }

        public static Color average(Collection<Color> collection) {
            if (collection.isEmpty()) {
                return Color.transparent();
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (Color color : collection) {
                l += (long)color.getRed();
                l2 += (long)color.getGreen();
                l3 += (long)color.getBlue();
                l4 += (long)color.getAlpha();
            }
            return new Color(Math.round((float)l / (float)collection.size()), Math.round((float)l2 / (float)collection.size()), Math.round((float)l3 / (float)collection.size()), Math.round((float)l4 / (float)collection.size()));
        }

        public static Color weightedAverage(Collection<class_3545<Color, Float>> collection) {
            if (collection.isEmpty()) {
                return Color.transparent();
            }
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (class_3545<Color, Float> class_35452 : collection) {
                float f6 = ((Float)class_35452.method_15441()).floatValue();
                f += f6;
                f2 += (float)((Color)class_35452.method_15442()).getRed() * f6;
                f3 += (float)((Color)class_35452.method_15442()).getGreen() * f6;
                f4 += (float)((Color)class_35452.method_15442()).getBlue() * f6;
                f5 += (float)((Color)class_35452.method_15442()).getAlpha() * f6;
            }
            return new Color(Color.floatToInt(f2 / f), Color.floatToInt(f3 / f), Color.floatToInt(f4 / f), Color.floatToInt(f5 / f));
        }

        private static int getAsInt(byte by, byte by2, byte by3, byte by4) {
            return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
        }

        private static int floatToInt(float f) {
            return Math.clamp((long)Math.round(f), 0, 255);
        }
    }

    public record Hashless(Color[] pixels, int width, int height) {
        public Image toImage() {
            return new Image(this.pixels, this.width, this.height, Image.getHash(this.pixels));
        }

        public static Hashless fromImage(Image image) {
            return new Hashless(image.pixels, image.width, image.height);
        }

        public Color getPixel(int n, int n2) {
            return this.getPixel(n, n2, Color.transparent());
        }

        public Color getPixel(int n, int n2, Color color) {
            if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
                return color;
            }
            return this.pixels[Image.getIndex(this.height, n, n2)];
        }

        public Color[] copyPixels() {
            Color[] colorArray = new Color[this.pixels.length];
            for (int i = 0; i < this.pixels.length; ++i) {
                colorArray[i] = this.pixels[i].copy();
            }
            return colorArray;
        }
    }

    public static interface Operation {
        public class_2561 getName();

        public Hashless apply(Hashless var1);

        public static Operation invert() {
            return new Operation(){

                @Override
                public class_2561 getName() {
                    return class_2561.method_30163((String)"Invert");
                }

                @Override
                public Hashless apply(Hashless hashless) {
                    Color[] colorArray = new Color[hashless.pixels.length];
                    for (int i = 0; i < hashless.pixels.length; ++i) {
                        colorArray[i] = hashless.pixels[i].invert();
                    }
                    return new Hashless(colorArray, hashless.width, hashless.height);
                }
            };
        }

        public static Operation scale(int n, int n2) {
            return Operation.scale(n, n2, Resampler.BILINEAR);
        }

        public static Operation scale(final int n, final int n2, final Resampler resampler) {
            return new Operation(){

                @Override
                public class_2561 getName() {
                    return class_2561.method_30163((String)"Scale");
                }

                @Override
                public Hashless apply(Hashless hashless) {
                    Color[] colorArray = new Color[n * n2];
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            colorArray[Image.getIndex((int)n2, (int)i, (int)j)] = resampler.resample(hashless, n, n2, i, j);
                        }
                    }
                    return new Hashless(colorArray, n, n2);
                }
            };
        }

        public static Operation translate(int n, int n2) {
            return Operation.translate(n, n2, Color.transparent());
        }

        public static Operation translate(final int n, final int n2, final Color color) {
            return new Operation(){

                @Override
                public class_2561 getName() {
                    return class_2561.method_30163((String)"Translate");
                }

                @Override
                public Hashless apply(Hashless hashless) {
                    Color[] colorArray = new Color[hashless.pixels.length];
                    for (int i = 0; i < hashless.width; ++i) {
                        for (int j = 0; j < hashless.height; ++j) {
                            colorArray[Image.getIndex((int)hashless.height, (int)i, (int)j)] = hashless.getPixel(i - n, j - n2, color);
                        }
                    }
                    return new Hashless(colorArray, hashless.width, hashless.height);
                }
            };
        }

        public static Operation resize(int n, int n2) {
            return Operation.resize(n, n2, Color.transparent());
        }

        public static Operation resize(final int n, final int n2, final Color color) {
            return new Operation(){

                @Override
                public class_2561 getName() {
                    return class_2561.method_30163((String)"Resize");
                }

                @Override
                public Hashless apply(Hashless hashless) {
                    Color[] colorArray = new Color[n * n2];
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            colorArray[Image.getIndex((int)n2, (int)i, (int)j)] = hashless.getPixel(i, j, color);
                        }
                    }
                    return new Hashless(colorArray, n, n2);
                }
            };
        }

        public static Operation embed(Image image, int n, int n2) {
            return Operation.embed(image, n, n2, false);
        }

        public static Operation embed(final Image image, final int n, final int n2, boolean bl) {
            return new Operation(){

                @Override
                public class_2561 getName() {
                    return class_2561.method_30163((String)"Embed");
                }

                @Override
                public Hashless apply(Hashless hashless) {
                    Color[] colorArray = hashless.copyPixels();
                    for (int i = 0; i < image.width; ++i) {
                        int n3 = i + n;
                        if (n3 < 0 || n3 >= hashless.width) continue;
                        for (int j = 0; j < image.height; ++j) {
                            int n22 = j + n2;
                            if (n22 < 0 || n22 >= hashless.height) continue;
                            Color color = hashless.getPixel(n3, n22);
                            Color color2 = image.getPixel(i, j);
                            colorArray[Image.getIndex((int)hashless.height, (int)n3, (int)n22)] = Color.layer(color2, color);
                        }
                    }
                    return new Hashless(colorArray, hashless.width, hashless.height);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Resampler {
        public static final Resampler NEAREST_NEIGHBOR = (hashless, n, n2, n3, n4) -> {
            int n5 = Math.round((float)n3 * ((float)hashless.width / (float)n));
            int n6 = Math.round((float)n4 * ((float)hashless.height / (float)n2));
            return hashless.pixels[Image.getIndex(hashless.height, n5, n6)];
        };
        public static final Resampler NEAREST_NEIGHBOR_FRAME_PRESERVING = (hashless, n, n2, n3, n4) -> {
            int n5 = n - 1;
            int n6 = n2 - 1;
            int n7 = hashless.width - 1;
            int n8 = hashless.height - 1;
            float f = (float)n5 / 2.0f;
            float f2 = (float)n6 / 2.0f;
            float f3 = (float)n3 * ((float)n7 / (float)n5);
            float f4 = (float)n4 * ((float)n8 / (float)n6);
            int n9 = Math.clamp((float)n3 <= f ? (long)class_3532.method_15375((float)f3) : (long)class_3532.method_15386((float)f3), 0, n7);
            int n10 = Math.clamp((float)n4 <= f2 ? (long)class_3532.method_15375((float)f4) : (long)class_3532.method_15386((float)f4), 0, n8);
            return hashless.pixels[Image.getIndex(hashless.height, n9, n10)];
        };
        public static final Resampler BILINEAR = (hashless, n, n2, n3, n4) -> {
            int n5 = Math.max(1, Math.round((float)hashless.width / (float)n));
            int n6 = Math.max(1, Math.round((float)hashless.height / (float)n2));
            int n7 = n5 * n5 + n6 * n6;
            ArrayList<class_3545<Color, Float>> arrayList = new ArrayList<class_3545<Color, Float>>();
            float f = (float)n3 * ((float)hashless.width / (float)n);
            float f2 = (float)n4 * ((float)hashless.height / (float)n2);
            int n8 = Math.round(f);
            int n9 = Math.round(f2);
            for (int i = -n5; i <= n5; ++i) {
                for (int j = -n6; j <= n6; ++j) {
                    Color color = hashless.getPixel(n8 + i, n9 + j);
                    if (color.isTransparent()) continue;
                    arrayList.add((class_3545<Color, Float>)new class_3545((Object)color, (Object)Float.valueOf((float)(i * i + j * j) / (float)n7)));
                }
            }
            return Color.weightedAverage(arrayList);
        };

        public static Resampler combine(float f, Resampler resampler, Resampler resampler2) {
            return (hashless, n, n2, n3, n4) -> {
                Color color = resampler.resample(hashless, n, n2, n3, n4);
                Color color2 = resampler2.resample(hashless, n, n2, n3, n4);
                return Color.weightedAverage(List.of(new class_3545((Object)color, (Object)Float.valueOf(f)), new class_3545((Object)color2, (Object)Float.valueOf(1.0f - f))));
            };
        }

        public Color resample(Hashless var1, int var2, int var3, int var4, int var5);
    }
}

