/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.legacy;

import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.texture.LoadingSprite;
import me.roundaround.custompaintings.resource.MigrationResource;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.PackResource;
import me.roundaround.custompaintings.resource.PaintingResource;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.resource.file.Metadata;
import me.roundaround.custompaintings.resource.file.Pack;
import me.roundaround.custompaintings.resource.file.PackReader;
import me.roundaround.custompaintings.resource.legacy.LegacyPackCheckResult;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;

public class LegacyPackConverter {
    private static final String CUSTOMPAINTINGS_JSON = "custompaintings.json";
    private static final String ICON_PNG = "icon.png";
    private static LegacyPackConverter instance = null;
    private final HashSet<CustomId> spriteIds = new HashSet();
    private final Executor ioExecutor = class_156.method_27958();
    private class_1059 atlas = null;
    private Path globalOutDir = null;

    private LegacyPackConverter() {
    }

    public static LegacyPackConverter getInstance() {
        if (instance == null) {
            instance = new LegacyPackConverter();
        }
        return instance;
    }

    public class_2960 getAtlasId() {
        if (this.atlas == null) {
            return null;
        }
        return this.atlas.method_24106();
    }

    public class_1058 getMissingSprite() {
        if (this.atlas == null) {
            return null;
        }
        return this.atlas.method_4608(class_1047.method_4539());
    }

    public class_1058 getSprite(String string) {
        return this.getSprite(PackIcons.customId(string));
    }

    public class_1058 getSprite(CustomId customId) {
        if (this.atlas == null) {
            return null;
        }
        if (!this.spriteIds.contains(customId)) {
            return this.getMissingSprite();
        }
        return this.atlas.method_4608(customId.toIdentifier());
    }

    public Path getWorldOutDir() {
        try {
            Path path = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Failed to create output directory for legacy pack conversion.");
            return null;
        }
    }

    public Path getGlobalOutDir() {
        if (this.globalOutDir != null) {
            return this.globalOutDir;
        }
        try {
            Path path = FabricLoader.getInstance().getGameDir().resolve("data").resolve("custompaintings").resolve("converted");
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            this.globalOutDir = path;
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Failed to create output directory for legacy pack conversion.");
        }
        return this.globalOutDir;
    }

    public CompletableFuture<Collection<Metadata>> checkForLegacyPacks(class_310 class_3102) {
        Path path = class_3102.method_1479();
        return CompletableFuture.supplyAsync(() -> this.checkForLegacyPackMetadata(path), this.ioExecutor);
    }

    public CompletableFuture<LegacyPackCheckResult> checkForLegacyPacksAndConvertedIds(class_310 class_3102) {
        Path path = class_3102.method_1479();
        boolean bl = class_3102.method_1542();
        return CompletableFuture.supplyAsync(() -> this.loadAllDataFromFiles(path, bl), this.ioExecutor).thenApplyAsync(legacyPackCheckResult -> {
            this.uploadIconsSpriteAtlas(class_3102, legacyPackCheckResult.metas());
            return legacyPackCheckResult;
        }, (Executor)class_3102);
    }

    private LegacyPackCheckResult loadAllDataFromFiles(Path path, boolean bl) {
        ArrayList<Metadata> arrayList = this.checkForLegacyPackMetadata(path);
        HashMap<String, Path> hashMap = this.lookUpConvertedPacks(this.getGlobalOutDir());
        HashMap<String, Path> hashMap2 = bl ? this.lookUpConvertedPacks(this.getWorldOutDir()) : new HashMap();
        return new LegacyPackCheckResult(arrayList, hashMap, hashMap2);
    }

    private ArrayList<Metadata> checkForLegacyPackMetadata(Path path2) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            directoryStream.forEach(path -> {
                Metadata metadata = PackReader.readMetadata(path);
                if (metadata == null) {
                    return;
                }
                arrayList.add(metadata);
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Error while checking for legacy packs in the resource pack directory...exiting early.");
        }
        return arrayList;
    }

    private HashMap<String, Path> lookUpConvertedPacks(Path path2) {
        HashMap<String, Path> hashMap = new HashMap<String, Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            directoryStream.forEach(path -> {
                try {
                    BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    String string = null;
                    if (basicFileAttributes.isDirectory()) {
                        string = this.readPackFileUidFromDirectory((Path)path);
                    } else if (basicFileAttributes.isRegularFile()) {
                        string = this.readPackFileUidFromZip((Path)path);
                    }
                    if (string != null) {
                        hashMap.put(string, (Path)path);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn((Object)iOException);
            CustomPaintingsMod.LOGGER.warn("Error while looking up list of already-converted packs...exiting early.");
        }
        return hashMap;
    }

    private String readPackFileUidFromDirectory(Path path) {
        SourceLegacyPackWrapper sourceLegacyPackWrapper;
        try {
            sourceLegacyPackWrapper = (SourceLegacyPackWrapper)CustomPaintingsMod.GSON.fromJson((Reader)Files.newBufferedReader(path.resolve(CUSTOMPAINTINGS_JSON)), SourceLegacyPackWrapper.class);
        }
        catch (Exception exception) {
            return null;
        }
        return sourceLegacyPackWrapper.sourceLegacyPack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPackFileUidFromZip(Path path) {
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            SourceLegacyPackWrapper sourceLegacyPackWrapper;
            Object object;
            ZipEntry zipEntry = zipFile.getEntry(CUSTOMPAINTINGS_JSON);
            if (zipEntry == null) {
                String string = null;
                return string;
            }
            try {
                object = zipFile.getInputStream(zipEntry);
                try {
                    sourceLegacyPackWrapper = (SourceLegacyPackWrapper)CustomPaintingsMod.GSON.fromJson((Reader)new InputStreamReader((InputStream)object), SourceLegacyPackWrapper.class);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (Exception exception) {
                String string = null;
                zipFile.close();
                return string;
            }
            object = sourceLegacyPackWrapper.sourceLegacyPack();
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void uploadIconsSpriteAtlas(class_310 class_3102, Collection<Metadata> collection) {
        this.atlas = new class_1059(class_2960.method_60655((String)"custompaintings", (String)"textures/atlas/legacy_pack_icons.png"));
        class_3102.method_1531().method_4616(this.atlas.method_24106(), (class_1044)this.atlas);
        ArrayList<class_7764> arrayList = new ArrayList<class_7764>();
        arrayList.add(class_1047.method_45805());
        collection.forEach(metadata -> {
            if (metadata.icon() == null) {
                return;
            }
            CustomId customId = PackIcons.customId(metadata.pack().id());
            this.spriteIds.add(customId);
            arrayList.add(LegacyPackConverter.getIconSpriteContents(customId.toIdentifier(), metadata.icon()));
        });
        this.atlas.method_45848(class_7766.method_45837((class_1059)this.atlas).method_47663(arrayList, 0, (Executor)class_156.method_18349()));
    }

    public CompletableFuture<Boolean> convertPack(Metadata metadata, Path path) {
        return CompletableFuture.supplyAsync(() -> {
            Object object;
            Pack pack = metadata.pack();
            HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
            if (metadata.icon() != null) {
                hashMap.put(PackIcons.customId(pack.id()), metadata.icon());
            }
            hashMap.putAll(PackReader.readPaintingImages(metadata));
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            pack.paintings().forEach(painting -> hashMap2.put(painting.id(), new PaintingResource(painting.id(), painting.name(), painting.artist(), painting.height(), painting.width())));
            hashMap2.keySet().removeIf(string -> !hashMap.containsKey(new CustomId(pack.id(), (String)string)));
            pack.migrations().forEach(migration -> {
                List<List<String>> list = migration.pairs().stream().map(List::copyOf).toList();
                hashMap3.put(migration.id(), new MigrationResource(migration.id(), migration.description(), list));
            });
            PackResource packResource = new PackResource(1, pack.id(), pack.name(), pack.description(), metadata.fileUid().stringValue(), List.copyOf(hashMap2.values()), List.copyOf(hashMap3.values()));
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    object = path.resolveSibling(path.getFileName().toString() + "_old");
                    if (Files.exists((Path)object, new LinkOption[0])) {
                        Files.delete((Path)object);
                    }
                    Files.move(path, (Path)object, new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                return false;
            }
            try {
                object = new FileOutputStream(path.toFile());
                try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);){
                    LegacyPackConverter.writeCustomPaintingsJson(zipOutputStream, packResource);
                    CustomId customId = PackIcons.customId(packResource.id());
                    if (hashMap.containsKey(customId)) {
                        LegacyPackConverter.writeImage(zipOutputStream, ICON_PNG, (Image)hashMap.get(customId));
                    }
                    for (PaintingResource paintingResource : packResource.paintings()) {
                        CustomId customId2 = new CustomId(packResource.id(), paintingResource.id());
                        if (!hashMap.containsKey(customId2)) continue;
                        LegacyPackConverter.writeImage(zipOutputStream, Paths.get("images", paintingResource.id() + ".png").toString(), (Image)hashMap.get(customId2));
                    }
                }
                finally {
                    ((FileOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn("Failed to automatically convert legacy painting pack {}", (Object)metadata.fileUid().filename());
                return false;
            }
            return true;
        }, this.ioExecutor);
    }

    private static class_7764 getIconSpriteContents(class_2960 class_29602, Image image) {
        if (image == null || image.isEmpty()) {
            return LoadingSprite.generate(class_29602, 16, 16);
        }
        class_1011 class_10112 = image.toNativeImage();
        return new class_7764(class_29602, new class_7771(image.width(), image.height()), class_10112, class_7368.field_38688);
    }

    private static void writeCustomPaintingsJson(ZipOutputStream zipOutputStream, PackResource packResource) throws IOException {
        ZipEntry zipEntry = new ZipEntry(CUSTOMPAINTINGS_JSON);
        zipOutputStream.putNextEntry(zipEntry);
        String string = CustomPaintingsMod.GSON.toJson((Object)packResource);
        byte[] byArray = string.getBytes();
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
    }

    private static void writeImage(ZipOutputStream zipOutputStream, String string, Image image) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        ImageIO.write((RenderedImage)image.toBufferedImage(), "png", zipOutputStream);
    }

    private record SourceLegacyPackWrapper(String sourceLegacyPack) {
    }
}

