/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.client.gui.layout.linear;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import me.roundaround.custompaintings.roundalib.client.gui.layout.LayoutHookWithParent;
import me.roundaround.custompaintings.roundalib.client.gui.layout.SizableLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutCellConfigurator;
import me.roundaround.custompaintings.roundalib.client.gui.util.Alignment;
import me.roundaround.custompaintings.roundalib.client.gui.util.Axis;
import me.roundaround.custompaintings.roundalib.client.gui.util.Spacing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_339;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LinearLayoutWidget
extends SizableLayoutWidget {
    private final List<CellWidget<?>> cells = new ArrayList();
    private Axis flowAxis;
    private Alignment alignSelfX = Alignment.START;
    private Alignment alignSelfY = Alignment.START;
    private int spacing;
    private Spacing padding = Spacing.zero();
    private Alignment contentAlignMain = Alignment.START;
    private Alignment defaultContentAlignOff = Alignment.CENTER;
    private Spacing defaultContentMargin = Spacing.zero();
    private int contentWidth;
    private int contentHeight;

    public LinearLayoutWidget(Axis axis) {
        this(axis, 0, 0, 0, 0);
    }

    public LinearLayoutWidget(Axis axis, int n, int n2) {
        this(axis, 0, 0, n, n2);
    }

    public LinearLayoutWidget(Axis axis, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.flowAxis = axis;
    }

    public static LinearLayoutWidget horizontal() {
        return new LinearLayoutWidget(Axis.HORIZONTAL);
    }

    public static LinearLayoutWidget horizontal(int n, int n2) {
        return new LinearLayoutWidget(Axis.HORIZONTAL, n, n2);
    }

    public static LinearLayoutWidget horizontal(int n, int n2, int n3, int n4) {
        return new LinearLayoutWidget(Axis.HORIZONTAL, n, n2, n3, n4);
    }

    public static LinearLayoutWidget vertical() {
        return new LinearLayoutWidget(Axis.VERTICAL);
    }

    public static LinearLayoutWidget vertical(int n, int n2) {
        return new LinearLayoutWidget(Axis.VERTICAL, n, n2);
    }

    public static LinearLayoutWidget vertical(int n, int n2, int n3, int n4) {
        return new LinearLayoutWidget(Axis.VERTICAL, n, n2, n3, n4);
    }

    public LinearLayoutWidget flowAxis(Axis axis) {
        this.flowAxis = axis;
        return this;
    }

    public LinearLayoutWidget alignSelfX(Alignment alignment) {
        this.alignSelfX = alignment;
        return this;
    }

    public LinearLayoutWidget alignSelfLeft() {
        return this.alignSelfX(Alignment.START);
    }

    public LinearLayoutWidget alignSelfCenterX() {
        return this.alignSelfX(Alignment.CENTER);
    }

    public LinearLayoutWidget alignSelfRight() {
        return this.alignSelfX(Alignment.END);
    }

    public LinearLayoutWidget alignSelfY(Alignment alignment) {
        this.alignSelfY = alignment;
        return this;
    }

    public LinearLayoutWidget alignSelfTop() {
        return this.alignSelfY(Alignment.START);
    }

    public LinearLayoutWidget alignSelfCenterY() {
        return this.alignSelfY(Alignment.CENTER);
    }

    public LinearLayoutWidget alignSelfBottom() {
        return this.alignSelfY(Alignment.END);
    }

    public LinearLayoutWidget alignSelf(Alignment alignment, Alignment alignment2) {
        this.alignSelfX = alignment;
        this.alignSelfY = alignment2;
        return this;
    }

    public LinearLayoutWidget spacing(int n) {
        this.spacing = n;
        return this;
    }

    public LinearLayoutWidget padding(int n) {
        this.padding = Spacing.of(n);
        return this;
    }

    public LinearLayoutWidget padding(int n, int n2) {
        this.padding = Spacing.of(n, n2);
        return this;
    }

    public LinearLayoutWidget padding(int n, int n2, int n3, int n4) {
        this.padding = Spacing.of(n, n2, n3, n4);
        return this;
    }

    public LinearLayoutWidget paddingX(int n) {
        this.padding = this.padding.setHorizontal(n);
        return this;
    }

    public LinearLayoutWidget paddingY(int n) {
        this.padding = this.padding.setVertical(n);
        return this;
    }

    public LinearLayoutWidget padding(Spacing spacing) {
        this.padding = spacing;
        return this;
    }

    public LinearLayoutWidget mainAxisContentAlign(Alignment alignment) {
        this.contentAlignMain = alignment;
        return this;
    }

    public LinearLayoutWidget mainAxisContentAlignStart() {
        return this.mainAxisContentAlign(Alignment.START);
    }

    public LinearLayoutWidget mainAxisContentAlignCenter() {
        return this.mainAxisContentAlign(Alignment.CENTER);
    }

    public LinearLayoutWidget mainAxisContentAlignEnd() {
        return this.mainAxisContentAlign(Alignment.END);
    }

    public LinearLayoutWidget defaultOffAxisContentAlign(Alignment alignment) {
        this.defaultContentAlignOff = alignment;
        return this;
    }

    public LinearLayoutWidget defaultOffAxisContentAlignStart() {
        return this.defaultOffAxisContentAlign(Alignment.START);
    }

    public LinearLayoutWidget defaultOffAxisContentAlignCenter() {
        return this.defaultOffAxisContentAlign(Alignment.CENTER);
    }

    public LinearLayoutWidget defaultOffAxisContentAlignEnd() {
        return this.defaultOffAxisContentAlign(Alignment.END);
    }

    public LinearLayoutWidget defaultContentMargin(Spacing spacing) {
        this.defaultContentMargin = spacing;
        return this;
    }

    public <T extends class_8021> T add(T t) {
        return this.add(t, (Consumer)null);
    }

    public <T extends class_8021> T add(T t, LayoutHookWithParent<LinearLayoutWidget, T> layoutHookWithParent) {
        return this.add(t, (LinearLayoutCellConfigurator<T> linearLayoutCellConfigurator) -> linearLayoutCellConfigurator.layoutHook(layoutHookWithParent));
    }

    public <T extends class_8021> T add(T t, Consumer<LinearLayoutCellConfigurator<T>> consumer) {
        CellWidget<T> cellWidget = new CellWidget<T>(t);
        this.cells.add(cellWidget);
        if (consumer != null) {
            consumer.accept(cellWidget);
        }
        this.method_48222();
        return t;
    }

    public void clearChildren() {
        this.cells.clear();
    }

    public List<class_8021> getChildren() {
        return this.cells.stream().map(cellWidget -> cellWidget.getWidget()).toList();
    }

    public int getUnusedSpace(@Nullable class_8021 class_80212) {
        int n = this.flowAxis == Axis.HORIZONTAL ? this.getInnerWidth() : this.getInnerHeight();
        n -= (this.getChildren().size() - 1) * this.spacing;
        for (class_8021 class_80213 : this.getChildren()) {
            if (class_80213 == class_80212) continue;
            n -= this.flowAxis == Axis.HORIZONTAL ? class_80213.method_25368() : class_80213.method_25364();
        }
        return n;
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.getChildren().forEach(consumer);
    }

    private void calculateContentDimensions() {
        this.contentWidth = switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> this.getMainContentDimension(CellWidget::method_25368);
            case Axis.VERTICAL -> this.getOffContentDimension(CellWidget::method_25368);
        };
        this.contentHeight = switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> this.getOffContentDimension(CellWidget::method_25364);
            case Axis.VERTICAL -> this.getMainContentDimension(CellWidget::method_25364);
        };
    }

    private int getMainContentDimension(ToIntFunction<CellWidget<?>> toIntFunction) {
        int n = Math.max(0, this.cells.size() - 1) * this.spacing;
        return this.cells.stream().mapToInt(toIntFunction).sum() + n;
    }

    private int getOffContentDimension(ToIntFunction<CellWidget<?>> toIntFunction) {
        return this.cells.stream().mapToInt(toIntFunction).max().orElse(0);
    }

    public void method_48222() {
        this.cells.forEach(cellWidget -> cellWidget.onLayout(this));
        this.calculateContentDimensions();
        int n = switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> this.getInnerX() + (int)((float)(this.getInnerWidth() - this.getContentWidth()) * this.contentAlignMain.floatValue());
            case Axis.VERTICAL -> this.getInnerY() + (int)((float)(this.getInnerHeight() - this.getContentHeight()) * this.contentAlignMain.floatValue());
        };
        for (CellWidget<?> cellWidget2 : this.cells) {
            int n2 = switch (this.flowAxis) {
                default -> throw new MatchException(null, null);
                case Axis.HORIZONTAL -> this.getInnerY() + (int)((float)(this.getInnerHeight() - cellWidget2.method_25364()) * this.getCellAlign(cellWidget2).floatValue());
                case Axis.VERTICAL -> this.getInnerX() + (int)((float)(this.getInnerWidth() - cellWidget2.method_25368()) * this.getCellAlign(cellWidget2).floatValue());
            };
            int n3 = n + this.getMainLeadingCellMargin(cellWidget2);
            int n4 = n2 + this.getOffLeadingCellMargin(cellWidget2);
            switch (this.flowAxis) {
                case HORIZONTAL: {
                    cellWidget2.method_48229(n3, n4);
                    break;
                }
                case VERTICAL: {
                    cellWidget2.method_48229(n4, n3);
                }
            }
            n += this.getMainCellDimension(cellWidget2) + this.spacing;
        }
        super.method_48222();
    }

    @Override
    public int method_46426() {
        return this.alignSelfX.getPos(super.method_46426(), this.method_25368());
    }

    @Override
    public int method_46427() {
        return this.alignSelfY.getPos(super.method_46427(), this.method_25364());
    }

    @Override
    public int method_25368() {
        return this.width != 0 ? this.width : this.contentWidth + this.padding.getHorizontal();
    }

    @Override
    public int method_25364() {
        return this.height != 0 ? this.height : this.contentHeight + this.padding.getVertical();
    }

    public int getInnerX() {
        return this.method_46426() + this.padding.left();
    }

    public int getInnerY() {
        return this.method_46427() + this.padding.top();
    }

    public int getInnerWidth() {
        return this.width != 0 ? this.width - this.padding.getHorizontal() : this.contentWidth + this.padding.getHorizontal();
    }

    public int getInnerHeight() {
        return this.height != 0 ? this.height - this.padding.getVertical() : this.contentHeight + this.padding.getVertical();
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private Spacing getCellMargin(CellWidget<?> cellWidget) {
        return cellWidget.margin != null ? cellWidget.margin : this.defaultContentMargin;
    }

    private Alignment getCellAlign(CellWidget<?> cellWidget) {
        return cellWidget.align != null ? cellWidget.align : this.defaultContentAlignOff;
    }

    private int getCellWidth(CellWidget<?> cellWidget) {
        return cellWidget.method_25368() + this.getCellMargin(cellWidget).getHorizontal();
    }

    private int getCellHeight(CellWidget<?> cellWidget) {
        return cellWidget.method_25364() + this.getCellMargin(cellWidget).getVertical();
    }

    private int getMainLeadingCellMargin(CellWidget<?> cellWidget) {
        Spacing spacing = this.getCellMargin(cellWidget);
        return switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> spacing.left();
            case Axis.VERTICAL -> spacing.top();
        };
    }

    private int getOffLeadingCellMargin(CellWidget<?> cellWidget) {
        Spacing spacing = this.getCellMargin(cellWidget);
        return switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> spacing.top();
            case Axis.VERTICAL -> spacing.left();
        };
    }

    private int getMainCellDimension(CellWidget<?> cellWidget) {
        return switch (this.flowAxis) {
            default -> throw new MatchException(null, null);
            case Axis.HORIZONTAL -> this.getCellWidth(cellWidget);
            case Axis.VERTICAL -> this.getCellHeight(cellWidget);
        };
    }

    @Environment(value=EnvType.CLIENT)
    private static class CellWidget<T extends class_8021>
    implements LinearLayoutCellConfigurator<T>,
    class_8021 {
        private final T widget;
        private LayoutHookWithParent<LinearLayoutWidget, T> layoutHook = null;
        private Spacing margin = null;
        private Alignment align = null;

        public CellWidget(T t) {
            this.widget = t;
        }

        @Override
        public T getWidget() {
            return this.widget;
        }

        @Override
        public void layoutHook(LayoutHookWithParent<LinearLayoutWidget, T> layoutHookWithParent) {
            this.layoutHook = layoutHookWithParent;
        }

        @Override
        public void margin(Spacing spacing) {
            this.margin = spacing;
        }

        @Override
        public void align(Alignment alignment) {
            this.align = alignment;
        }

        public void onLayout(LinearLayoutWidget linearLayoutWidget) {
            if (this.layoutHook != null) {
                this.layoutHook.run(linearLayoutWidget, this.widget);
            }
        }

        public void method_46421(int n) {
            this.widget.method_46421(n);
        }

        public void method_46419(int n) {
            this.widget.method_46419(n);
        }

        public int method_46426() {
            return this.widget.method_46426();
        }

        public int method_46427() {
            return this.widget.method_46427();
        }

        public int method_25368() {
            return this.widget.method_25368() + (this.margin != null ? this.margin.getHorizontal() : 0);
        }

        public int method_25364() {
            return this.widget.method_25364() + (this.margin != null ? this.margin.getVertical() : 0);
        }

        public void method_48206(Consumer<class_339> consumer) {
            T t = this.widget;
            if (t instanceof class_339) {
                class_339 class_3392 = (class_339)t;
                consumer.accept(class_3392);
            }
        }
    }
}

