/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.client.gui.widget.config;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.widget.config.Control;
import me.roundaround.custompaintings.roundalib.config.option.FloatConfigOption;
import net.minecraft.class_310;
import net.minecraft.class_342;

public class FloatTextControl
extends Control<Float, FloatConfigOption> {
    private static final List<Character> ALLOWED_SPECIAL_CHARS = List.of(Character.valueOf('.'), Character.valueOf(','));
    private final class_342 textField;

    public FloatTextControl(class_310 class_3102, FloatConfigOption floatConfigOption, int n, int n2) {
        super(class_3102, floatConfigOption, n, n2);
        this.textField = this.add(new class_342(this, class_3102.field_1772, n - 2, n2 - 2, ((FloatConfigOption)this.option).getLabel()){

            public boolean method_25400(char c, int n) {
                if (c == '-' && this.method_1881() > 0) {
                    return false;
                }
                if (!FloatTextControl.isCharAllowed(c)) {
                    return false;
                }
                return super.method_25400(c, n);
            }
        }, (LinearLayoutWidget linearLayoutWidget, T var1_1) -> var1_1.method_55445(linearLayoutWidget.method_25368(), linearLayoutWidget.method_25364()));
        this.textField.method_1852(((FloatConfigOption)this.option).getPendingValueAsString());
        this.textField.method_1880(12);
        this.textField.method_1863(this::onTextChanged);
    }

    @Override
    public void markInvalid() {
        this.textField.method_1868(GuiUtil.ERROR_COLOR);
        super.markInvalid();
    }

    @Override
    public void markValid() {
        this.textField.method_1868(GuiUtil.LABEL_COLOR);
        super.markValid();
    }

    @Override
    protected void update(Float f, boolean bl) {
        this.textField.field_22763 = !bl;
        this.textField.method_1888(!bl);
        try {
            float f2 = this.parseFloat(this.textField.method_1882());
            if (!((FloatConfigOption)this.getOption()).areValuesEqual(f, Float.valueOf(f2))) {
                this.textField.method_1852(((FloatConfigOption)this.getOption()).toString());
            }
        }
        catch (Exception exception) {
            this.textField.method_1852(((FloatConfigOption)this.getOption()).toString());
        }
    }

    private void onTextChanged(String string) {
        try {
            float f = this.parseFloat(string);
            if (((FloatConfigOption)this.option).validate(Float.valueOf(f))) {
                ((FloatConfigOption)this.option).setValue(Float.valueOf(f));
                this.markValid();
            } else {
                this.markInvalid();
            }
        }
        catch (Exception exception) {
            this.markInvalid();
        }
    }

    private float parseFloat(String string) throws ParseException {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        return decimalFormat.parse(string).floatValue();
    }

    private static boolean isCharAllowed(char c) {
        return Character.isDigit(c) || ALLOWED_SPECIAL_CHARS.contains(Character.valueOf(c));
    }
}

