/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.toml;

import me.roundaround.custompaintings.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.io.Utils;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.ArrayParser;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.StringParser;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.TableParser;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.TemporalParser;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.Toml;
import me.roundaround.custompaintings.roundalib.nightconfig.toml.TomlParser;

final class ValueParser {
    private static final char[] END_OF_VALUE = new char[]{'\t', ' ', '#', '\n', '\r', ',', ']', '}'};
    private static final char[] END_OF_VALUE_DATE = new char[]{'\t', '#', '\n', '\r', ',', ']', '}'};
    private static final char[] TRUE_END = new char[]{'r', 'u', 'e'};
    private static final char[] FALSE_END = new char[]{'a', 'l', 's', 'e'};
    private static final char[] ONLY_IN_FP_NUMBER = new char[]{'.', 'e', 'E'};
    private static final char[] FP_INFINITY = new char[]{'i', 'n', 'f'};
    private static final char[] FP_NAN = new char[]{'n', 'a', 'n'};

    static Object parse(CharacterInput characterInput, char c, TomlParser tomlParser, CommentedConfig commentedConfig) {
        switch (c) {
            case '{': {
                return TableParser.parseInline(characterInput, tomlParser, commentedConfig.createSubConfig());
            }
            case '[': {
                return ArrayParser.parse(characterInput, tomlParser, commentedConfig);
            }
            case '\'': {
                if (characterInput.peek() == 39 && characterInput.peek(1) == 39) {
                    characterInput.skipPeeks();
                    return StringParser.parseMultiLiteral(characterInput, tomlParser);
                }
                return StringParser.parseLiteral(characterInput, tomlParser);
            }
            case '\"': {
                if (characterInput.peek() == 34 && characterInput.peek(1) == 34) {
                    characterInput.skipPeeks();
                    return StringParser.parseMultiBasic(characterInput, tomlParser);
                }
                return StringParser.parseBasic(characterInput, tomlParser);
            }
            case 't': {
                return ValueParser.parseTrue(characterInput);
            }
            case 'f': {
                return ValueParser.parseFalse(characterInput);
            }
            case '+': 
            case '-': {
                characterInput.pushBack(c);
                return ValueParser.parseNumber(characterInput.readUntil(END_OF_VALUE));
            }
        }
        characterInput.pushBack(c);
        CharsWrapper charsWrapper = characterInput.readUntil(END_OF_VALUE_DATE);
        if (ValueParser.shouldBeTemporal(charsWrapper)) {
            return TemporalParser.parse(charsWrapper);
        }
        CharsWrapper charsWrapper2 = charsWrapper.trimmedView();
        if (charsWrapper2.isEmpty()) {
            throw new ParsingException("Invalid value containing only whitespaces");
        }
        return ValueParser.parseNumber(charsWrapper2);
    }

    static Object parse(CharacterInput characterInput, TomlParser tomlParser, CommentedConfig commentedConfig) {
        return ValueParser.parse(characterInput, Toml.readNonSpaceChar(characterInput, false), tomlParser, commentedConfig);
    }

    private static boolean shouldBeTemporal(CharsWrapper charsWrapper) {
        return charsWrapper.length() >= 8 && (charsWrapper.get(2) == ':' || charsWrapper.get(4) == '-' && charsWrapper.get(7) == '-');
    }

    private static Number parseNumber(CharsWrapper charsWrapper) {
        long l;
        CharsWrapper charsWrapper2;
        char c = charsWrapper.get(0);
        if (c == '-') {
            charsWrapper2 = charsWrapper.subView(1);
            if (charsWrapper2.contentEquals(FP_INFINITY)) {
                return Double.NEGATIVE_INFINITY;
            }
        } else {
            charsWrapper2 = c == '+' ? charsWrapper.subView(1) : charsWrapper;
        }
        if (charsWrapper2.contentEquals(FP_INFINITY)) {
            return Double.POSITIVE_INFINITY;
        }
        if (charsWrapper2.contentEquals(FP_NAN)) {
            return Double.NaN;
        }
        CharsWrapper charsWrapper3 = charsWrapper;
        int n = 10;
        if (charsWrapper.length() > 2) {
            switch (charsWrapper.subView(0, 2).toString()) {
                case "0x": {
                    n = 16;
                    break;
                }
                case "0b": {
                    n = 2;
                    break;
                }
                case "0o": {
                    n = 8;
                }
            }
            if (n != 10) {
                charsWrapper3 = charsWrapper.subView(2);
            }
        }
        charsWrapper3 = ValueParser.simplifyNumber(charsWrapper3, n);
        if (n == 10 && charsWrapper3.indexOfFirst(ONLY_IN_FP_NUMBER) != -1) {
            if (charsWrapper3.length() > 1) {
                if (charsWrapper3.get(0) == '0' && ValueParser.isDigitChar(charsWrapper3.get(1), 10)) {
                    throw new ParsingException("Invalid leading zero in floating-point number " + String.valueOf(charsWrapper3));
                }
                if (charsWrapper3.length() > 2 && (charsWrapper3.startsWith("-0") || charsWrapper3.startsWith("+0")) && ValueParser.isDigitChar(charsWrapper3.get(2), 10)) {
                    throw new ParsingException("Invalid leading zero (after sign) in floating-point number " + String.valueOf(charsWrapper3));
                }
            }
            try {
                return Utils.parseDouble(charsWrapper3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParsingException("Invalid floating-point value: " + String.valueOf(charsWrapper));
            }
        }
        if (n == 10) {
            if (charsWrapper3.length() > 1 && charsWrapper3.get(0) == '0') {
                throw new ParsingException("Invalid leading zero in base 10 integer " + String.valueOf(charsWrapper3));
            }
            if (charsWrapper3.length() > 2 && (charsWrapper3.startsWith("-0") || charsWrapper3.startsWith("+0")) && ValueParser.isDigitChar(charsWrapper3.get(2), 10)) {
                throw new ParsingException("Invalid leading zero (after sign) in base 10 integer " + String.valueOf(charsWrapper3));
            }
        }
        try {
            l = Utils.parseLong(charsWrapper3, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParsingException("Invalid integer value: " + String.valueOf(charsWrapper));
        }
        int n2 = (int)l;
        if ((long)n2 == l) {
            return n2;
        }
        return l;
    }

    private static boolean isDigitChar(char c, int n) {
        switch (n) {
            case 2: {
                return c == '0' || c == '1';
            }
            case 8: {
                return c >= '0' && c <= '7';
            }
            case 10: {
                return c >= '0' && c <= '9';
            }
            case 16: {
                return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
            }
        }
        throw new IllegalArgumentException("Unsupported base " + n);
    }

    private static CharsWrapper simplifyNumber(CharsWrapper charsWrapper, int n) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(16);
        int n2 = -1;
        for (char c : charsWrapper) {
            switch (c) {
                case '_': {
                    if (n2 == -1) {
                        throw new ParsingException("Invalid leading underscore in number " + String.valueOf(charsWrapper));
                    }
                    if (ValueParser.isDigitChar((char)n2, n)) break;
                    throw new ParsingException("Invalid underscore in number (each underscore must be surrounded by digits): " + String.valueOf(charsWrapper));
                }
                case '.': {
                    if (n2 == -1) {
                        throw new ParsingException("Invalid leading decimal point in number " + String.valueOf(charsWrapper));
                    }
                    if (!ValueParser.isDigitChar((char)n2, n)) {
                        throw new ParsingException("Invalid decimal point in number (each decimal point must be surrounded by digits): " + String.valueOf(charsWrapper));
                    }
                    builder.append(c);
                    break;
                }
                case 'e': {
                    if (n != 16 && !ValueParser.isDigitChar((char)n2, n)) {
                        throw new ParsingException("Invalid sequence " + n2 + "e in number" + String.valueOf(charsWrapper));
                    }
                }
                default: {
                    builder.append(c);
                }
            }
            n2 = c;
        }
        if (n2 == 95) {
            throw new ParsingException("Invalid trailing underscore in number: " + String.valueOf(charsWrapper));
        }
        if (n2 == 46) {
            throw new ParsingException("Invalid trailing decimal point in number: " + String.valueOf(charsWrapper));
        }
        if (n2 == 101 || n2 == 69 || n2 == 45 || n2 == 43) {
            throw new ParsingException("Invalid trailing '" + n2 + "' in number: " + String.valueOf(charsWrapper));
        }
        return builder.build();
    }

    private static Boolean parseFalse(CharacterInput characterInput) {
        CharsWrapper charsWrapper = characterInput.readUntil(END_OF_VALUE);
        if (!charsWrapper.contentEquals(FALSE_END)) {
            throw new ParsingException("Invalid value f" + String.valueOf(charsWrapper) + " - Expected the boolean value false.");
        }
        return false;
    }

    private static Boolean parseTrue(CharacterInput characterInput) {
        CharsWrapper charsWrapper = characterInput.readUntil(END_OF_VALUE);
        if (!charsWrapper.contentEquals(TRUE_END)) {
            throw new ParsingException("Invalid value t" + String.valueOf(charsWrapper) + " - Expected the boolean value true.");
        }
        return true;
    }

    private ValueParser() {
    }
}

