/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server.registry;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.registry.CustomPaintingRegistry;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.resource.file.FileUid;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.resource.file.Metadata;
import me.roundaround.custompaintings.resource.file.Pack;
import me.roundaround.custompaintings.resource.file.PackReader;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.server.ServerInfo;
import me.roundaround.custompaintings.server.network.ImagePacketQueue;
import me.roundaround.custompaintings.server.network.ServerNetworking;
import me.roundaround.custompaintings.util.CustomId;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;

public class ServerPaintingRegistry
extends CustomPaintingRegistry {
    private static final String LOG_FAIL_ALL = "Skipping loading packs due to an error";
    private static final String LOG_LARGE_IMAGE = "Image file for {} is too large, skipping";
    private static final int MAX_SIZE = 0x1000000;
    private static ServerPaintingRegistry instance = null;
    private final HashMap<CustomId, Boolean> finishedMigrations = new HashMap();
    private MinecraftServer server;
    private boolean safeMode = false;
    private int loadErrorOrSkipCount = 0;

    private ServerPaintingRegistry() {
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> {
            if (minecraftServer == this.server) {
                this.clear();
            }
        });
    }

    public static void init(MinecraftServer minecraftServer) {
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        if (minecraftServer == null || !minecraftServer.method_3806()) {
            return;
        }
        serverPaintingRegistry.setServer(minecraftServer);
    }

    public static ServerPaintingRegistry getInstance() {
        if (instance == null) {
            instance = new ServerPaintingRegistry();
        }
        return instance;
    }

    @Override
    protected class_5455 getRegistryManager() {
        return this.server == null ? null : this.server.method_30611();
    }

    @Override
    public void clear() {
        super.clear();
        this.finishedMigrations.clear();
        this.server = null;
    }

    public void setServer(MinecraftServer minecraftServer) {
        if (this.server != null && this.server != minecraftServer) {
            this.clear();
        }
        this.server = minecraftServer;
        this.sendSummaryToAll();
    }

    public void firstLoadPaintingPacks(boolean bl) {
        this.safeMode = bl;
        LoadResult loadResult = this.safeMode ? LoadResult.empty(0) : this.loadPaintingPacks();
        this.loadErrorOrSkipCount = loadResult.erroredOrSkipped();
        this.setPacks(loadResult.packs());
        this.setImages(loadResult.images());
    }

    public void reloadPaintingPacks(Consumer<MinecraftServer> consumer) {
        if (this.server == null || !this.server.method_3806()) {
            return;
        }
        this.safeMode = false;
        CompletableFuture.supplyAsync(this::loadPaintingPacks, (Executor)class_156.method_27958()).thenAcceptAsync(loadResult -> {
            this.loadErrorOrSkipCount = loadResult.erroredOrSkipped();
            this.setPacks(loadResult.packs());
            this.setImages(loadResult.images());
            this.sendSummaryToAll();
            consumer.accept(this.server);
        }, (Executor)this.server);
    }

    public void setImages(HashMap<CustomId, Image> hashMap) {
        this.images.clear();
        this.images.putAll(hashMap);
        this.combinedImageHash = ResourceUtil.hashImages(hashMap);
    }

    public void sendSummaryToAll() {
        ServerNetworking.sendSummaryPacketToAll(this.server, this.packsList, this.combinedImageHash, this.finishedMigrations, this.safeMode, this.loadErrorOrSkipCount);
    }

    public void sendSummaryToPlayer(class_3222 class_32222) {
        ServerNetworking.sendSummaryPacket(class_32222, this.packsList, this.combinedImageHash, this.finishedMigrations, this.safeMode, this.loadErrorOrSkipCount);
    }

    public void checkPlayerHashes(class_3222 class_32222, Map<CustomId, String> map) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        this.images.forEach((customId, image) -> {
            if (image.hash().equals(map.get(customId))) {
                return;
            }
            hashMap.put((CustomId)customId, (Image)image);
        });
        if (hashMap.isEmpty()) {
            CustomPaintingsMod.LOGGER.info("{} has incorrect combined hash, but all correct images. This is likely due to paintings being removed server-side.", (Object)class_32222.method_5477().getString());
            ServerNetworking.sendDownloadSummaryPacket(class_32222, new HashSet<CustomId>(0), 0, 0);
            return;
        }
        CustomPaintingsMod.LOGGER.info("{} needs to download {} image(s). Sending to client.", (Object)class_32222.method_5477().getString(), (Object)hashMap.size());
        ImagePacketQueue.getInstance().add(class_32222, hashMap);
    }

    public void markMigrationFinished(CustomId customId, boolean bl) {
        this.finishedMigrations.put(customId, bl);
    }

    private LoadResult loadPaintingPacks() {
        LoadResult loadResult;
        block9: {
            CustomPaintingsMod.LOGGER.info("Loading painting packs");
            Path path2 = PathAccessor.getInstance().getPerWorldModDir("custompaintings");
            if (path2 == null || Files.notExists(path2, new LinkOption[0])) {
                CustomPaintingsMod.LOGGER.info("Unable to locate packs directory, skipping");
                return LoadResult.empty(0);
            }
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);
            try {
                Set<String> set = ServerInfo.getInstance().getDisabledPacks();
                HashMap<String, PackData> hashMap = new HashMap<String, PackData>();
                HashMap hashMap2 = new HashMap();
                HashMap<CustomId, Image> hashMap3 = new HashMap<CustomId, Image>();
                var var7_10 = new Object(this){
                    int value = 0;
                };
                directoryStream.forEach(path -> {
                    Metadata metadata = PackReader.readMetadata(path);
                    if (metadata == null) {
                        ++var0.value;
                        return;
                    }
                    Pack pack = metadata.pack();
                    String string = pack.id();
                    String string2 = path.getFileName().toString();
                    String string3 = (String)hashMap2.get(string);
                    if (string3 != null) {
                        CustomPaintingsMod.LOGGER.warn("Multiple packs with id \"{}\" detected. Only the first will be kept. Please make sure packs have unique IDs!\nKeeping \"{}\" and discarding \"{}\"", (Object)string, (Object)string3, (Object)string2);
                        ++var0.value;
                        return;
                    }
                    hashMap2.put(string, string2);
                    FileUid fileUid = metadata.fileUid();
                    boolean bl = set.contains(fileUid.stringValue());
                    hashMap.put(string, pack.toData(fileUid, bl));
                    if (metadata.icon() != null) {
                        hashMap3.put(PackIcons.customId(string), metadata.icon());
                    }
                    if (!bl) {
                        HashMap<CustomId, Image> hashMap4 = PackReader.readPaintingImages(metadata);
                        for (Map.Entry<CustomId, Image> entry : hashMap4.entrySet()) {
                            CustomId customId = entry.getKey();
                            Image image = entry.getValue();
                            long l = (long)image.width() * (long)image.height();
                            if (l > 0x1000000L) {
                                CustomPaintingsMod.LOGGER.warn(LOG_LARGE_IMAGE, (Object)customId);
                                continue;
                            }
                            hashMap3.put(customId, image);
                        }
                    }
                });
                CustomPaintingsMod.LOGGER.info("Loaded {} pack(s) with {} painting(s)", (Object)hashMap.size(), (Object)hashMap.values().stream().mapToInt(packData -> packData.paintings().size()).sum());
                loadResult = new LoadResult(hashMap, hashMap3, var7_10.value);
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    CustomPaintingsMod.LOGGER.warn(LOG_FAIL_ALL, (Throwable)iOException);
                    return LoadResult.empty(1);
                }
            }
            directoryStream.close();
        }
        return loadResult;
    }

    private record LoadResult(HashMap<String, PackData> packs, HashMap<CustomId, Image> images, int erroredOrSkipped) {
        public static LoadResult empty(int n) {
            return new LoadResult(new HashMap<String, PackData>(0), new HashMap<CustomId, Image>(0), n);
        }
    }
}

