/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.screen;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.gui.widget.LoadingButtonWidget;
import me.roundaround.custompaintings.client.gui.widget.SpriteWidget;
import me.roundaround.custompaintings.client.gui.widget.VersionStamp;
import me.roundaround.custompaintings.resource.file.Metadata;
import me.roundaround.custompaintings.resource.legacy.LegacyPackConverter;
import me.roundaround.custompaintings.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.Alignment;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.widget.FlowListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.ParentElementEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7413;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class LegacyConvertScreen
extends class_437 {
    private static final class_2561 LABEL_CONVERT = class_2561.method_43471((String)"custompaintings.legacy.entry.convert");
    private static final class_2561 LABEL_RE_CONVERT = class_2561.method_43471((String)"custompaintings.legacy.entry.reConvert");
    private static final class_2561 TOOLTIP_SUCCESS = class_2561.method_43471((String)"custompaintings.legacy.entry.viewOutput");
    private static final class_2561 TOOLTIP_FAILURE = class_2561.method_43471((String)"custompaintings.legacy.entry.error");
    private final ThreeSectionLayoutWidget layout = new ThreeSectionLayoutWidget(this);
    private final class_437 parent;
    private final HashMap<String, ConvertState> globalStates = new HashMap();
    private final HashMap<String, ConvertState> worldStates = new HashMap();
    private LegacyPackList list;
    private Path outDir;
    private HashMap<String, ConvertState> currentStates;

    public LegacyConvertScreen(class_310 class_3102, class_437 class_4372) {
        super((class_2561)class_2561.method_43471((String)"custompaintings.legacy.title"));
        this.parent = class_4372;
        this.setOutDir(class_3102.method_1542());
        LegacyPackConverter.getInstance().checkForLegacyPacksAndConvertedIds(class_3102).orTimeout(30L, TimeUnit.SECONDS).whenCompleteAsync((legacyPackCheckResult, throwable) -> {
            if (throwable != null) {
                CustomPaintingsMod.LOGGER.warn(throwable);
                if (this.list != null) {
                    this.list.showErrorMessage();
                }
                return;
            }
            for (Metadata metadata : legacyPackCheckResult.metas()) {
                Path path;
                String string = metadata.fileUid().stringValue();
                Path path2 = legacyPackCheckResult.globalConvertedIds().get(string);
                if (path2 != null) {
                    this.globalStates.put(string, ConvertState.success(path2));
                }
                if ((path = legacyPackCheckResult.worldConvertedIds().get(string)) == null) continue;
                this.worldStates.put(string, ConvertState.success(path));
            }
            if (this.list != null) {
                this.list.setPacks(this.currentStates, legacyPackCheckResult.metas());
            }
        }, this.field_44944);
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.layout.addHeader(this.field_22793, this.field_22785);
        if (this.field_22787.method_1542()) {
            this.layout.addHeader(class_4286.method_54787((class_2561)class_2561.method_43471((String)"custompaintings.legacy.direct"), (class_327)this.field_22793).method_54791(this::changeOutDir).method_54794(true).method_54788());
        }
        this.list = this.layout.addBody(new LegacyPackList(this.field_22787, this.layout, this::convertPack));
        this.layout.addFooter(class_4185.method_46430((class_2561)class_2561.method_43471((String)"custompaintings.legacy.output"), this::openOutDir).method_46431());
        this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24334, this::close).method_46431());
        VersionStamp.create(this.field_22793, this.layout);
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    private void setOutDir(boolean bl) {
        LegacyPackConverter legacyPackConverter = LegacyPackConverter.getInstance();
        this.outDir = bl ? legacyPackConverter.getWorldOutDir() : legacyPackConverter.getGlobalOutDir();
        this.currentStates = bl ? this.worldStates : this.globalStates;
    }

    private void changeOutDir(class_4286 class_42862, boolean bl) {
        this.setOutDir(bl);
        this.list.updateAllStates(this.currentStates);
    }

    private void convertPack(LegacyPackList.PackEntry packEntry) {
        Metadata metadata = packEntry.getMeta();
        Path path = this.outDir.resolve(LegacyConvertScreen.cleanFilename(metadata.fileUid().filename()) + ".zip");
        packEntry.markLoading();
        LegacyPackConverter.getInstance().convertPack(metadata, path).orTimeout(30L, TimeUnit.SECONDS).whenCompleteAsync((bl, throwable) -> {
            ConvertState convertState;
            if (bl == null || !bl.booleanValue() || throwable != null) {
                if (throwable != null) {
                    CustomPaintingsMod.LOGGER.warn(throwable);
                }
                convertState = ConvertState.failed();
            } else {
                convertState = ConvertState.success(path);
            }
            this.currentStates.put(metadata.fileUid().stringValue(), convertState);
            packEntry.setState(convertState);
        }, this.field_44944);
    }

    private void openOutDir(class_4185 class_41852) {
        if (this.outDir != null) {
            class_156.method_668().method_673(this.outDir.toUri());
        }
    }

    private void close(class_4185 class_41852) {
        this.method_25419();
    }

    private static String cleanFilename(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static class LegacyPackList
    extends ParentElementEntryListWidget<Entry> {
        private final Consumer<PackEntry> convert;

        public LegacyPackList(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget, Consumer<PackEntry> consumer) {
            super(class_3102, threeSectionLayoutWidget);
            this.convert = consumer;
            this.addEntry(LoadingEntry.factory(class_3102.field_1772));
        }

        public void showErrorMessage() {
            this.clearEntries();
            this.addEntry(ErrorEntry.factory(this.client.field_1772));
            this.method_48222();
        }

        public void setPacks(HashMap<String, ConvertState> hashMap, Collection<Metadata> collection) {
            this.clearEntries();
            if (collection.isEmpty()) {
                this.addEntry(EmptyEntry.factory(this.client.field_1772));
                return;
            }
            for (Metadata metadata : collection) {
                ConvertState convertState = hashMap.getOrDefault(metadata.fileUid().stringValue(), ConvertState.none());
                this.addEntry(PackEntry.factory(this.client.field_1772, convertState, metadata, this.convert));
            }
            this.method_48222();
        }

        public void updateAllStates(HashMap<String, ConvertState> hashMap) {
            this.entries.forEach(entry -> {
                if (entry instanceof PackEntry) {
                    PackEntry packEntry = (PackEntry)entry;
                    packEntry.setState(hashMap.getOrDefault(packEntry.getMeta().fileUid().stringValue(), ConvertState.none()));
                }
            });
        }

        private static class LoadingEntry
        extends Entry {
            private static final int HEIGHT = 36;
            private static final class_2561 LOADING_TEXT = class_2561.method_43471((String)"custompaintings.legacy.loading");
            private final class_327 textRenderer;

            protected LoadingEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4, 36);
                this.textRenderer = class_3272;
            }

            public static FlowListWidget.EntryFactory<LoadingEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new LoadingEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            protected void renderContent(class_332 class_3322, int n, int n2, float f) {
                int n3 = this.getContentCenterX() - this.textRenderer.method_27525((class_5348)LOADING_TEXT) / 2;
                int n4 = this.getContentTop();
                int n5 = this.getContentHeight();
                Objects.requireNonNull(this.textRenderer);
                int n6 = n4 + (n5 - 9) / 2;
                class_3322.method_51439(this.textRenderer, LOADING_TEXT, n3, n6, GuiUtil.LABEL_COLOR, false);
                String string = class_7413.method_43449((long)class_156.method_658());
                n3 = this.getContentCenterX() - this.textRenderer.method_1727(string) / 2;
                Objects.requireNonNull(this.textRenderer);
                class_3322.method_51433(this.textRenderer, string, n3, n6 += 9, -8355712, false);
            }
        }

        private static class ErrorEntry
        extends Entry {
            private static final int HEIGHT = 36;
            private static final class_2561 MESSAGE_LINE_1 = class_2561.method_43471((String)"custompaintings.legacy.error1");
            private static final class_2561 MESSAGE_LINE_2 = class_2561.method_43471((String)"custompaintings.legacy.error2");
            private final LabelWidget label;

            protected ErrorEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4, 36);
                this.label = LabelWidget.builder(class_3272, List.of(MESSAGE_LINE_1, MESSAGE_LINE_2)).position(this.getContentCenterX(), this.getContentCenterY()).dimensions(this.getContentWidth(), this.getContentHeight()).alignSelfCenterX().alignSelfCenterY().alignTextCenterX().alignTextCenterY().hideBackground().showShadow().color(-65536).build();
                this.addDrawable(this.label);
            }

            public static FlowListWidget.EntryFactory<ErrorEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new ErrorEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            public void method_48222() {
                this.label.batchUpdates(() -> {
                    this.label.method_48229(this.getContentCenterX(), this.getContentCenterY());
                    this.label.method_55445(this.getContentWidth(), this.getContentHeight());
                });
            }
        }

        private static class EmptyEntry
        extends Entry {
            private static final int HEIGHT = 36;
            private static final class_2561 MESSAGE = class_2561.method_43471((String)"custompaintings.legacy.none");
            private final LabelWidget label;

            protected EmptyEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4, 36);
                this.label = LabelWidget.builder(class_3272, MESSAGE).position(this.getContentCenterX(), this.getContentCenterY()).dimensions(this.getContentWidth(), this.getContentHeight()).alignSelfCenterX().alignSelfCenterY().alignTextCenterX().alignTextCenterY().hideBackground().showShadow().build();
                this.addDrawable(this.label);
            }

            public static FlowListWidget.EntryFactory<EmptyEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new EmptyEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            public void method_48222() {
                this.label.batchUpdates(() -> {
                    this.label.method_48229(this.getContentCenterX(), this.getContentCenterY());
                    this.label.method_55445(this.getContentWidth(), this.getContentHeight());
                });
            }
        }

        private static class PackEntry
        extends Entry {
            private static final int HEIGHT = 48;
            private static final int PACK_ICON_SIZE = 36;
            private static final int CONVERT_BUTTON_SIZE = 80;
            private static final int STATUS_BUTTON_SIZE = 20;
            private static final class_2561 LINE_NAME = class_2561.method_43471((String)"custompaintings.legacy.entry.name");
            private static final class_2561 LINE_DESCRIPTION = class_2561.method_43471((String)"custompaintings.legacy.entry.desc");
            private static final class_2561 LINE_FILE = class_2561.method_43471((String)"custompaintings.legacy.entry.file");
            private static final class_2561 NONE_PLACEHOLDER = class_2561.method_43471((String)"custompaintings.legacy.entry.emptyField").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
            private final Metadata meta;
            private final LoadingButtonWidget convertButton;
            private final IconButtonWidget statusButton;
            private Path outPath;

            protected PackEntry(int n, int n2, int n3, int n4, class_327 class_3272, ConvertState convertState, Metadata metadata, Consumer<PackEntry> consumer) {
                super(n, n2, n3, n4, 48);
                this.meta = metadata;
                this.outPath = convertState.path;
                LinearLayoutWidget linearLayoutWidget3 = this.addLayout(LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlign(Alignment.CENTER), linearLayoutWidget -> linearLayoutWidget.setPositionAndDimensions(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()));
                linearLayoutWidget3.add(SpriteWidget.create(LegacyPackConverter.getInstance().getSprite(this.meta.pack().id())), (linearLayoutWidget, spriteWidget) -> spriteWidget.method_55445(36, 36));
                linearLayoutWidget3.add(FillerWidget.empty());
                LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().spacing(4);
                int n5 = Stream.of(LINE_FILE, LINE_NAME, LINE_DESCRIPTION).mapToInt(arg_0 -> ((class_327)class_3272).method_27525(arg_0)).max().orElse(1);
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_FILE, this.meta.fileUid().filename()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_NAME, this.meta.pack().name()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_DESCRIPTION, this.meta.pack().description()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget3.add(linearLayoutWidget4, (linearLayoutWidget, linearLayoutWidget2) -> {
                    int n = this.getContentWidth();
                    n -= (linearLayoutWidget.getChildren().size() - 1) * linearLayoutWidget.getSpacing();
                    for (class_8021 class_80212 : linearLayoutWidget.getChildren()) {
                        if (class_80212 == linearLayoutWidget2) continue;
                        n -= class_80212.method_25368();
                    }
                    linearLayoutWidget2.setWidth(n);
                });
                linearLayoutWidget3.add(FillerWidget.empty());
                Status status = convertState.status;
                this.convertButton = linearLayoutWidget3.add(new LoadingButtonWidget(0, 0, 80, 20, status.getButtonLabel(), class_41852 -> consumer.accept(this)));
                this.statusButton = linearLayoutWidget3.add(IconButtonWidget.builder(status.getTexture(), 18).dimensions(20).tooltip(status.getTooltip()).onPress(class_41852 -> {
                    if (this.outPath == null) {
                        return;
                    }
                    class_156.method_668().method_673(this.outPath.getParent().toUri());
                }).build());
                if (status == Status.NONE) {
                    this.statusButton.field_22764 = false;
                } else {
                    this.statusButton.field_22763 = status == Status.SUCCESS;
                }
                linearLayoutWidget3.method_48206(class_40682 -> {
                    class_339 cfr_ignored_0 = (class_339)this.addDrawableChild(class_40682);
                });
            }

            private LinearLayoutWidget textLine(class_327 class_3272, int n, class_2561 class_25612, String string) {
                LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2);
                class_2561 class_25613 = string == null || string.isBlank() ? NONE_PLACEHOLDER : class_2561.method_30163((String)string);
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, class_25612).hideBackground().showShadow().color(-6250336).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(n));
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, class_25613).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368() - linearLayoutWidget.getSpacing() - n));
                return linearLayoutWidget2;
            }

            public static FlowListWidget.EntryFactory<PackEntry> factory(class_327 class_3272, ConvertState convertState, Metadata metadata, Consumer<PackEntry> consumer) {
                return (n, n2, n3, n4) -> new PackEntry(n, n2, n3, n4, class_3272, convertState, metadata, consumer);
            }

            public Metadata getMeta() {
                return this.meta;
            }

            public void markLoading() {
                this.convertButton.setLoading(true);
            }

            public void setState(ConvertState convertState) {
                this.convertButton.setLoading(false);
                this.convertButton.method_25355(convertState.status.getButtonLabel());
                if (convertState.status == Status.NONE) {
                    this.statusButton.field_22764 = false;
                } else {
                    this.outPath = convertState.path;
                    this.statusButton.field_22764 = true;
                    this.statusButton.field_22763 = convertState.status == Status.SUCCESS;
                    this.statusButton.setTexture(convertState.status.getTexture());
                    this.statusButton.method_47400(class_7919.method_47407((class_2561)convertState.status.getTooltip()));
                }
            }
        }

        private static abstract class Entry
        extends ParentElementEntryListWidget.Entry {
            protected Entry(int n, int n2, int n3, int n4, int n5) {
                super(n, n2, n3, n4, n5);
            }
        }
    }

    private static class ConvertState {
        public Status status;
        public Path path;

        private ConvertState(Status status, Path path) {
            this.status = status;
            this.path = path;
        }

        public static ConvertState success(Path path) {
            return new ConvertState(Status.SUCCESS, path);
        }

        public static ConvertState none() {
            return new ConvertState(Status.NONE, null);
        }

        public static ConvertState failed() {
            return new ConvertState(Status.FAILURE, null);
        }
    }

    private static enum Status {
        NONE(LABEL_CONVERT, (class_2561)class_2561.method_43473(), null),
        SUCCESS(LABEL_RE_CONVERT, TOOLTIP_SUCCESS, class_2960.method_60656((String)"pending_invite/accept")),
        FAILURE(LABEL_CONVERT, TOOLTIP_FAILURE, class_2960.method_60656((String)"pending_invite/reject"));

        private final class_2561 buttonLabel;
        private final class_2561 tooltip;
        private final class_2960 texture;

        private Status(class_2561 class_25612, class_2561 class_25613, class_2960 class_29602) {
            this.buttonLabel = class_25612;
            this.tooltip = class_25613;
            this.texture = class_29602;
        }

        public class_2561 getButtonLabel() {
            return this.buttonLabel;
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }
}

