/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.screen;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.roundaround.custompaintings.client.gui.widget.LoadingButtonWidget;
import me.roundaround.custompaintings.client.gui.widget.SpriteWidget;
import me.roundaround.custompaintings.client.gui.widget.VersionStamp;
import me.roundaround.custompaintings.client.network.ClientNetworking;
import me.roundaround.custompaintings.client.registry.ClientPaintingRegistry;
import me.roundaround.custompaintings.entity.decoration.painting.MigrationData;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.Alignment;
import me.roundaround.custompaintings.roundalib.client.gui.widget.FlowListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.ParentElementEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.custompaintings.util.CustomId;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class MigrationsScreen
extends class_437 {
    private static final int BUTTON_WIDTH = 200;
    private static final class_2561 LABEL_RUN = class_2561.method_43471((String)"custompaintings.migrate.entry.run");
    private static final class_2561 LABEL_RE_RUN = class_2561.method_43471((String)"custompaintings.migrate.entry.reRun");
    private static final class_2561 TOOLTIP_SUCCESS = class_2561.method_43471((String)"custompaintings.migrate.entry.success");
    private static final class_2561 TOOLTIP_FAILURE = class_2561.method_43471((String)"custompaintings.migrate.entry.error");
    private final ThreeSectionLayoutWidget layout = new ThreeSectionLayoutWidget(this);
    private final class_437 parent;
    private MigrationList list;

    protected MigrationsScreen(class_437 class_4372) {
        super((class_2561)class_2561.method_43471((String)"custompaintings.migrate.title"));
        this.parent = class_4372;
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.layout.addHeader(this.field_22793, this.field_22785);
        this.list = this.layout.addBody(new MigrationList(this.field_22787, this.layout, ClientPaintingRegistry.getInstance().getMigrations().values(), ClientPaintingRegistry.getInstance().getFinishedMigrations(), this::runMigration));
        this.layout.addFooter(class_4185.method_46430((class_2561)class_5244.field_24334, this::close).method_46432(200).method_46431());
        VersionStamp.create(this.field_22793, this.layout);
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public void onMigrationFinished(CustomId customId, boolean bl) {
        this.list.markMigrationFinished(customId, bl);
    }

    private void close(class_4185 class_41852) {
        this.method_25419();
    }

    private void runMigration(MigrationList.MigrationEntry migrationEntry) {
        class_156.method_27958().execute(() -> ClientNetworking.sendRunMigrationPacket(migrationEntry.getMigrationId()));
        migrationEntry.markLoading();
    }

    private static class MigrationList
    extends ParentElementEntryListWidget<Entry> {
        public MigrationList(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget, Collection<MigrationData> collection, Map<CustomId, Boolean> map, Consumer<MigrationEntry> consumer) {
            super(class_3102, threeSectionLayoutWidget);
            if (collection.isEmpty()) {
                this.addEntry(EmptyEntry.factory(this.client.field_1772));
                return;
            }
            for (MigrationData migrationData : collection) {
                this.addEntry(MigrationEntry.factory(this.client.field_1772, migrationData, Status.of(map.get(migrationData.id())), consumer));
            }
            this.method_48222();
        }

        public void markMigrationFinished(CustomId customId, boolean bl) {
            for (Entry entry : this.entries) {
                MigrationEntry migrationEntry;
                if (!(entry instanceof MigrationEntry) || !(migrationEntry = (MigrationEntry)entry).getMigrationId().equals(customId)) continue;
                migrationEntry.markFinished(bl);
            }
        }

        private static class EmptyEntry
        extends Entry {
            private static final int HEIGHT = 36;
            private static final class_2561 MESSAGE = class_2561.method_43471((String)"custompaintings.migrate.none");
            private final LabelWidget label;

            protected EmptyEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
                super(n, n2, n3, n4, 36);
                this.label = LabelWidget.builder(class_3272, MESSAGE).position(this.getContentCenterX(), this.getContentCenterY()).dimensions(this.getContentWidth(), this.getContentHeight()).alignSelfCenterX().alignSelfCenterY().alignTextCenterX().alignTextCenterY().hideBackground().showShadow().build();
                this.addDrawable(this.label);
            }

            public static FlowListWidget.EntryFactory<EmptyEntry> factory(class_327 class_3272) {
                return (n, n2, n3, n4) -> new EmptyEntry(n, n2, n3, n4, class_3272);
            }

            @Override
            public void method_48222() {
                this.label.batchUpdates(() -> {
                    this.label.method_48229(this.getContentCenterX(), this.getContentCenterY());
                    this.label.method_55445(this.getContentWidth(), this.getContentHeight());
                });
            }
        }

        private static class MigrationEntry
        extends Entry {
            private static final int HEIGHT = 48;
            private static final int PACK_ICON_SIZE = 36;
            private static final int RUN_BUTTON_SIZE = 80;
            private static final int STATUS_BUTTON_SIZE = 20;
            private static final class_2561 LINE_SOURCE = class_2561.method_43471((String)"custompaintings.migrate.entry.source");
            private static final class_2561 LINE_ID = class_2561.method_43471((String)"custompaintings.migrate.entry.id");
            private static final class_2561 LINE_DESCRIPTION = class_2561.method_43471((String)"custompaintings.migrate.entry.desc");
            private static final class_2561 LINE_PAIRS = class_2561.method_43471((String)"custompaintings.migrate.entry.pairs");
            private static final class_2561 NONE_PLACEHOLDER = class_2561.method_43471((String)"custompaintings.migrate.entry.emptyField").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
            private final MigrationData migration;
            private final LoadingButtonWidget runButton;
            private final IconButtonWidget statusButton;

            protected MigrationEntry(int n, int n2, int n3, int n4, class_327 class_3272, MigrationData migrationData, Status status, Consumer<MigrationEntry> consumer) {
                super(n, n2, n3, n4, 48);
                this.migration = migrationData;
                LinearLayoutWidget linearLayoutWidget3 = this.addLayout(LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlign(Alignment.CENTER), linearLayoutWidget -> linearLayoutWidget.setPositionAndDimensions(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()));
                linearLayoutWidget3.add(SpriteWidget.create(ClientPaintingRegistry.getInstance().getSprite(PackIcons.customId(migrationData.id().pack()))), (linearLayoutWidget, spriteWidget) -> spriteWidget.method_55445(36, 36));
                linearLayoutWidget3.add(FillerWidget.empty());
                LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().spacing(4);
                int n5 = Stream.of(LINE_SOURCE, LINE_ID, LINE_DESCRIPTION, LINE_PAIRS).mapToInt(arg_0 -> ((class_327)class_3272).method_27525(arg_0)).max().orElse(1);
                PackData packData = ClientPaintingRegistry.getInstance().getPacks().get(migrationData.id().pack());
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_SOURCE, packData == null ? null : packData.name()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_ID, migrationData.id().resource()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_DESCRIPTION, migrationData.description()), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget4.add(this.textLine(class_3272, n5, LINE_PAIRS, String.valueOf(migrationData.pairs().size())), (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setWidth(linearLayoutWidget.method_25368()));
                linearLayoutWidget3.add(linearLayoutWidget4, (linearLayoutWidget, linearLayoutWidget2) -> {
                    int n = this.getContentWidth();
                    n -= (linearLayoutWidget.getChildren().size() - 1) * linearLayoutWidget.getSpacing();
                    for (class_8021 class_80212 : linearLayoutWidget.getChildren()) {
                        if (class_80212 == linearLayoutWidget2) continue;
                        n -= class_80212.method_25368();
                    }
                    linearLayoutWidget2.setWidth(n);
                });
                linearLayoutWidget3.add(FillerWidget.empty());
                this.runButton = linearLayoutWidget3.add(new LoadingButtonWidget(0, 0, 80, 20, status.getButtonLabel(), class_41852 -> consumer.accept(this)));
                this.statusButton = linearLayoutWidget3.add(IconButtonWidget.builder(status.getTexture(), 18).dimensions(20).hideBackground().disableIconDim().tooltip(status.getTooltip()).build());
                this.statusButton.field_22764 = status != Status.NONE;
                this.statusButton.field_22763 = false;
                linearLayoutWidget3.method_48206(class_40682 -> {
                    class_339 cfr_ignored_0 = (class_339)this.addDrawableChild(class_40682);
                });
            }

            private LinearLayoutWidget textLine(class_327 class_3272, int n, class_2561 class_25612, String string) {
                LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2);
                class_2561 class_25613 = string == null || string.isBlank() ? NONE_PLACEHOLDER : class_2561.method_30163((String)string);
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, class_25612).hideBackground().showShadow().color(-6250336).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(n));
                linearLayoutWidget2.add(LabelWidget.builder(class_3272, class_25613).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368() - linearLayoutWidget.getSpacing() - n));
                return linearLayoutWidget2;
            }

            public CustomId getMigrationId() {
                return this.migration.id();
            }

            public void markLoading() {
                this.runButton.setLoading(true);
            }

            public void markFinished(boolean bl) {
                this.runButton.setLoading(false);
                Status status = Status.of(bl);
                this.statusButton.field_22764 = status != Status.NONE;
                this.statusButton.setTexture(status.getTexture());
                this.statusButton.method_25355(status.getButtonLabel());
                this.statusButton.method_47400(class_7919.method_47407((class_2561)status.getTooltip()));
            }

            public static FlowListWidget.EntryFactory<MigrationEntry> factory(class_327 class_3272, MigrationData migrationData, Status status, Consumer<MigrationEntry> consumer) {
                return (n, n2, n3, n4) -> new MigrationEntry(n, n2, n3, n4, class_3272, migrationData, status, consumer);
            }
        }

        private static abstract class Entry
        extends ParentElementEntryListWidget.Entry {
            protected Entry(int n, int n2, int n3, int n4, int n5) {
                super(n, n2, n3, n4, n5);
            }
        }
    }

    private static enum Status {
        NONE(LABEL_RUN, (class_2561)class_2561.method_43473(), null),
        SUCCESS(LABEL_RE_RUN, TOOLTIP_SUCCESS, class_2960.method_60656((String)"pending_invite/accept")),
        FAILURE(LABEL_RUN, TOOLTIP_FAILURE, class_2960.method_60656((String)"pending_invite/reject"));

        private final class_2561 buttonLabel;
        private final class_2561 tooltip;
        private final class_2960 texture;

        private Status(class_2561 class_25612, class_2561 class_25613, class_2960 class_29602) {
            this.buttonLabel = class_25612;
            this.tooltip = class_25613;
            this.texture = class_29602;
        }

        public static Status of(Boolean bl) {
            if (bl == null) {
                return NONE;
            }
            return bl != false ? SUCCESS : FAILURE;
        }

        public class_2561 getButtonLabel() {
            return this.buttonLabel;
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }
}

