/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui.widget;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.roundaround.custompaintings.client.gui.PaintingEditState;
import me.roundaround.custompaintings.client.gui.widget.PaintingSpriteWidget;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.util.GuiUtil;
import me.roundaround.custompaintings.roundalib.client.gui.widget.NarratableEntryListWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_8028;

@Environment(value=EnvType.CLIENT)
public class PaintingListWidget
extends NarratableEntryListWidget<Entry> {
    private final PaintingEditState state;
    private final Consumer<PaintingData> onPaintingSelect;
    private final Consumer<PaintingData> onPaintingConfirm;

    public PaintingListWidget(class_310 class_3102, PaintingEditState paintingEditState, Consumer<PaintingData> consumer, Consumer<PaintingData> consumer2) {
        super(class_3102, 0, 0, 0, 0);
        this.setAlternatingRowShading(true);
        this.setAutoPadForShading(false);
        this.state = paintingEditState;
        this.onPaintingSelect = consumer;
        this.onPaintingConfirm = consumer2;
        this.refreshPaintings();
    }

    public void refreshPaintings() {
        this.clearEntries();
        this.state.updatePaintingList();
        for (PaintingData paintingData : this.state.getCurrentPaintings()) {
            this.addEntry((n, n2, n3, n4) -> new PaintingEntry(n, n2, n3, n4, this.client.field_1772, paintingData, this.state.canStay(paintingData), this.onPaintingSelect, this.onPaintingConfirm));
        }
        if (this.getEntryCount() == 0 || this.state.areAnyPaintingsFiltered()) {
            this.addEntry((n, n2, n3, n4) -> new EmptyEntry(n, n2, n3, n4, this.client.field_1772));
        }
        this.method_48222();
    }

    @Override
    public void setSelected(Entry entry) {
        super.setSelected(entry);
        this.state.setCurrentPainting(entry.getPaintingData());
        this.onPaintingSelect.accept(this.state.getCurrentPainting());
    }

    public Optional<PaintingData> getSelectedPainting() {
        Entry entry = (Entry)this.getSelected();
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.paintingData);
    }

    public void selectPainting(PaintingData paintingData) {
        Optional<PaintingData> optional = this.getSelectedPainting();
        if (optional.isPresent() && optional.get().idEquals(paintingData)) {
            return;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!(class_3642 instanceof Entry)) continue;
            Entry entry = (Entry)class_3642;
            if (!entry.paintingData.idEquals(paintingData)) continue;
            this.setSelected(entry);
            this.ensureVisible(entry);
            return;
        }
    }

    @Override
    public boolean method_25402(class_11909 class_119092, boolean bl) {
        Entry entry = (Entry)this.getEntryAtPosition(class_119092.comp_4798(), class_119092.comp_4799());
        if (entry != null && entry.method_25402(class_119092, bl)) {
            return true;
        }
        return super.method_25402(class_119092, bl) || entry != null;
    }

    @Override
    protected Entry getNeighboringEntry(class_8028 class_80282) {
        return this.getNeighboringEntry(class_80282, entry -> !entry.getPaintingData().isEmpty());
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends NarratableEntryListWidget.Entry {
        protected static final int HEIGHT = 36;
        protected final PaintingData paintingData;

        public Entry(int n, int n2, int n3, int n4, int n5, PaintingData paintingData) {
            super(n, n2, n3, n4, n5);
            this.paintingData = paintingData;
        }

        public PaintingData getPaintingData() {
            return this.paintingData;
        }

        @Override
        public boolean method_25402(class_11909 class_119092, boolean bl) {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EmptyEntry
    extends Entry {
        private final LabelWidget label;

        public EmptyEntry(int n, int n2, int n3, int n4, class_327 class_3272) {
            super(n, n2, n3, n4, 36, PaintingData.EMPTY);
            this.label = LabelWidget.builder(class_3272, (class_2561)class_2561.method_43471((String)"custompaintings.painting.empty")).position(this.getContentCenterX(), this.getContentCenterY()).dimensions(this.getContentWidth(), this.getContentHeight()).alignSelfCenterX().alignSelfCenterY().hideBackground().showShadow().build();
            this.addDrawable(this.label);
        }

        @Override
        public class_2561 getNarration() {
            return this.label.getText();
        }

        @Override
        public void method_48222() {
            this.label.batchUpdates(() -> {
                this.label.method_48229(this.getContentCenterX(), this.getContentCenterY());
                this.label.method_55445(this.getContentWidth(), this.getContentHeight());
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PaintingEntry
    extends Entry {
        private final Consumer<PaintingData> onSelect;
        private final Consumer<PaintingData> onConfirm;
        private final boolean canStay;

        public PaintingEntry(int n, int n2, int n3, int n4, class_327 class_3272, PaintingData paintingData, boolean bl, Consumer<PaintingData> consumer, Consumer<PaintingData> consumer2) {
            super(n, n2, n3, n4, 36, paintingData);
            assert (paintingData != null);
            assert (!paintingData.isEmpty());
            this.onSelect = consumer;
            this.onConfirm = consumer2;
            this.canStay = bl;
            LinearLayoutWidget linearLayoutWidget3 = this.addLayout(LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlignCenter(), linearLayoutWidget -> {
                linearLayoutWidget.method_48229(this.getContentLeft(), this.getContentTop());
                linearLayoutWidget.setDimensions(this.getContentWidth(), this.getContentHeight());
            });
            linearLayoutWidget3.add(PaintingSpriteWidget.create(paintingData), (linearLayoutWidget, paintingSpriteWidget) -> {
                paintingSpriteWidget.method_55445(this.getPaintingWidth(), this.getPaintingHeight());
                paintingSpriteWidget.setActive(this.canStay);
            });
            LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().spacing(1).mainAxisContentAlignCenter();
            List<class_2561> list = this.getPaintingData().getInfoLines();
            list.forEach(class_25612 -> linearLayoutWidget4.add(LabelWidget.builder(class_3272, class_25612).alignTextLeft().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(linearLayoutWidget.method_25368())));
            linearLayoutWidget3.add(linearLayoutWidget4, (linearLayoutWidget, linearLayoutWidget2) -> linearLayoutWidget2.setDimensions(this.getContentWidth() - 4 - this.getPaintingWidth(), this.getContentHeight()));
            linearLayoutWidget3.method_48206(class_40682 -> {
                class_339 cfr_ignored_0 = (class_339)this.addDrawable(class_40682);
            });
        }

        private int getPaintingWidth() {
            return this.getContentHeight();
        }

        private int getPaintingHeight() {
            return this.getContentHeight();
        }

        @Override
        public class_2561 getNarration() {
            return !this.paintingData.hasLabel() ? class_2561.method_43470((String)this.paintingData.id().resource()) : this.paintingData.getLabel();
        }

        @Override
        public boolean method_25402(class_11909 class_119092, boolean bl) {
            if (bl) {
                if (this.canStay) {
                    this.onConfirm.accept(this.paintingData);
                    return true;
                }
                return false;
            }
            this.onSelect.accept(this.paintingData);
            return true;
        }

        public boolean method_25404(class_11908 class_119082) {
            if (class_119082.method_74230() && this.canStay) {
                GuiUtil.playClickSound();
                this.onConfirm.accept(this.paintingData);
                return true;
            }
            return false;
        }
    }
}

