/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.network;

import java.util.List;
import java.util.Map;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.ClientPaintingManager;
import me.roundaround.custompaintings.client.gui.PaintingEditState;
import me.roundaround.custompaintings.client.gui.screen.MainMenuScreen;
import me.roundaround.custompaintings.client.gui.screen.MigrationsScreen;
import me.roundaround.custompaintings.client.gui.screen.set.PackSelectScreen;
import me.roundaround.custompaintings.client.registry.ClientPaintingRegistry;
import me.roundaround.custompaintings.client.toast.CustomSystemToasts;
import me.roundaround.custompaintings.network.Networking;
import me.roundaround.custompaintings.network.PaintingAssignment;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.StringUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public final class ClientNetworking {
    private ClientNetworking() {
    }

    public static void sendHashesPacket(Map<CustomId, String> map) {
        ClientPlayNetworking.send((class_8710)new Networking.HashesC2S(map));
    }

    public static void sendReloadPacket() {
        ClientNetworking.sendReloadPacket(List.of(), List.of());
    }

    public static void sendReloadPacket(List<String> list, List<String> list2) {
        ClientPlayNetworking.send((class_8710)new Networking.ReloadC2S(list, list2));
    }

    public static void sendSetPaintingPacket(int n, CustomId customId) {
        ClientPlayNetworking.send((class_8710)new Networking.SetPaintingC2S(n, customId));
    }

    public static void sendRunMigrationPacket(CustomId customId) {
        ClientPlayNetworking.send((class_8710)new Networking.RunMigrationC2S(customId));
    }

    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(Networking.SummaryS2C.ID, ClientNetworking::handleSummary);
        ClientPlayNetworking.registerGlobalReceiver(Networking.DownloadSummaryS2C.ID, ClientNetworking::handleDownloadSummary);
        ClientPlayNetworking.registerGlobalReceiver(Networking.ImageS2C.ID, ClientNetworking::handleImage);
        ClientPlayNetworking.registerGlobalReceiver(Networking.ImageHeaderS2C.ID, ClientNetworking::handleImageHeader);
        ClientPlayNetworking.registerGlobalReceiver(Networking.ImageChunkS2C.ID, ClientNetworking::handleImageChunk);
        ClientPlayNetworking.registerGlobalReceiver(Networking.EditPaintingS2C.ID, ClientNetworking::handleEditPainting);
        ClientPlayNetworking.registerGlobalReceiver(Networking.SetPaintingS2C.ID, ClientNetworking::handleSetPainting);
        ClientPlayNetworking.registerGlobalReceiver(Networking.SyncAllDataS2C.ID, ClientNetworking::handleSyncAllData);
        ClientPlayNetworking.registerGlobalReceiver(Networking.MigrationFinishS2C.ID, ClientNetworking::handleMigrationFinish);
        ClientPlayNetworking.registerGlobalReceiver(Networking.OpenMenuS2C.ID, ClientNetworking::handleOpenMenu);
    }

    private static void handleSummary(Networking.SummaryS2C summaryS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_310 class_3102 = context.client();
            if (class_3102.method_1542() && summaryS2C.skipped()) {
                CustomSystemToasts.addPackLoadSkipped(class_3102);
            }
            if (class_3102.field_1724 != null && (class_3102.method_1542() || class_3102.field_1724.method_64475(3)) && summaryS2C.loadErrorOrSkipCount() > 0) {
                CustomSystemToasts.addPackLoadFailure(class_3102);
            }
            ClientPaintingRegistry.getInstance().processSummary(summaryS2C.packs(), summaryS2C.serverId(), summaryS2C.combinedImageHash(), summaryS2C.finishedMigrations());
        });
    }

    private static void handleDownloadSummary(Networking.DownloadSummaryS2C downloadSummaryS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ClientPaintingRegistry.getInstance().trackExpectedPackets(downloadSummaryS2C.ids(), downloadSummaryS2C.imageCount(), downloadSummaryS2C.byteCount()));
    }

    private static void handleImage(Networking.ImageS2C imageS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            CustomPaintingsMod.LOGGER.info("Received full image for {} ({}).", (Object)imageS2C.id(), (Object)StringUtil.formatBytes(imageS2C.image().getSize()));
            ClientPaintingRegistry.getInstance().setPaintingImage(imageS2C.id(), imageS2C.image());
        });
    }

    private static void handleImageHeader(Networking.ImageHeaderS2C imageHeaderS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            CustomPaintingsMod.LOGGER.info("Received image header for {}.", (Object)imageHeaderS2C.id());
            ClientPaintingRegistry.getInstance().setPaintingHeader(imageHeaderS2C.id(), imageHeaderS2C.width(), imageHeaderS2C.height(), imageHeaderS2C.totalChunks());
        });
    }

    private static void handleImageChunk(Networking.ImageChunkS2C imageChunkS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            CustomPaintingsMod.LOGGER.info("Received image chunk #{} for {} ({}).", (Object)imageChunkS2C.index(), (Object)imageChunkS2C.id(), (Object)StringUtil.formatBytes(imageChunkS2C.bytes().length));
            ClientPaintingRegistry.getInstance().setPaintingChunk(imageChunkS2C.id(), imageChunkS2C.index(), imageChunkS2C.bytes());
        });
    }

    private static void handleEditPainting(Networking.EditPaintingS2C editPaintingS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            PaintingEditState paintingEditState = new PaintingEditState(context.client(), editPaintingS2C.paintingId(), editPaintingS2C.pos(), editPaintingS2C.facing());
            context.client().method_1507((class_437)new PackSelectScreen(paintingEditState));
        });
    }

    private static void handleSetPainting(Networking.SetPaintingS2C setPaintingS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ClientPaintingManager.getInstance().trySetPaintingData(context.player().method_73183(), setPaintingS2C.assignment()));
    }

    private static void handleSyncAllData(Networking.SyncAllDataS2C syncAllDataS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_1937 class_19372 = context.player().method_73183();
            for (PaintingAssignment paintingAssignment : syncAllDataS2C.assignments()) {
                ClientPaintingManager.getInstance().trySetPaintingData(class_19372, paintingAssignment);
            }
        });
    }

    private static void handleMigrationFinish(Networking.MigrationFinishS2C migrationFinishS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            ClientPaintingRegistry.getInstance().markMigrationFinished(migrationFinishS2C.id(), migrationFinishS2C.succeeded());
            class_437 class_4372 = context.client().field_1755;
            if (!(class_4372 instanceof MigrationsScreen)) {
                return;
            }
            MigrationsScreen migrationsScreen = (MigrationsScreen)class_4372;
            migrationsScreen.onMigrationFinished(migrationFinishS2C.id(), migrationFinishS2C.succeeded());
        });
    }

    private static void handleOpenMenu(Networking.OpenMenuS2C openMenuS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_310 class_3102 = context.client();
            class_437 class_4372 = class_3102.field_1755;
            if (class_4372 == null || class_4372 instanceof class_408) {
                class_3102.method_1507((class_437)new MainMenuScreen(null));
            }
        });
    }
}

