/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.resource.MigrationResource;
import me.roundaround.custompaintings.resource.PackFileUid;
import me.roundaround.custompaintings.resource.PaintingResource;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.InvalidIdException;

public record PackResource(Integer format, String id, String name, String description, String sourceLegacyPack, List<PaintingResource> paintings, List<MigrationResource> migrations) {
    public PackData toData(PackFileUid packFileUid, boolean bl) {
        return new PackData(packFileUid.stringValue(), bl, packFileUid.fileSize(), this.id, this.name, Optional.ofNullable(this.description), Optional.ofNullable(this.sourceLegacyPack), this.paintings.stream().map(paintingResource -> paintingResource.toData(this.id)).toList(), this.migrations.stream().map(migrationResource -> migrationResource.toData(this.id)).toList());
    }

    public void validateIds() throws InvalidIdException {
        CustomId.validatePart(this.id, "pack");
        int n = 0;
        for (PaintingResource record : this.paintings) {
            record.validateId(n);
            ++n;
        }
        n = 0;
        for (MigrationResource migrationResource : this.migrations) {
            migrationResource.validateIds(n);
            ++n;
        }
    }

    public static class TypeAdapter
    extends com.google.gson.TypeAdapter<PackResource> {
        private final Gson gson = new Gson();
        private final com.google.gson.TypeAdapter<PaintingResource> paintingAdapter = this.gson.getAdapter(PaintingResource.class);
        private final com.google.gson.TypeAdapter<MigrationResource> migrationAdapter = this.gson.getAdapter(MigrationResource.class);

        public void write(JsonWriter jsonWriter, PackResource packResource) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name("format");
            jsonWriter.value((Number)packResource.format());
            jsonWriter.name("id");
            jsonWriter.value(packResource.id());
            jsonWriter.name("name");
            jsonWriter.value(packResource.name());
            if (packResource.description() != null && !packResource.description().isBlank()) {
                jsonWriter.name("description");
                jsonWriter.value(packResource.description());
            }
            if (packResource.sourceLegacyPack() != null && !packResource.sourceLegacyPack().isBlank()) {
                jsonWriter.name("sourceLegacyPack");
                jsonWriter.value(packResource.sourceLegacyPack());
            }
            jsonWriter.name("paintings");
            jsonWriter.beginArray();
            if (packResource.paintings() != null) {
                for (PaintingResource record : packResource.paintings()) {
                    this.paintingAdapter.write(jsonWriter, (Object)record);
                }
            }
            jsonWriter.endArray();
            if (packResource.migrations() != null && !packResource.migrations().isEmpty()) {
                jsonWriter.name("migrations");
                jsonWriter.beginArray();
                for (MigrationResource migrationResource : packResource.migrations()) {
                    this.migrationAdapter.write(jsonWriter, (Object)migrationResource);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }

        public PackResource read(JsonReader jsonReader) throws IOException {
            int n = 1;
            String string = "";
            String string2 = "";
            String string3 = null;
            String string4 = null;
            ArrayList<PaintingResource> arrayList = new ArrayList<PaintingResource>();
            ArrayList<MigrationResource> arrayList2 = new ArrayList<MigrationResource>();
            jsonReader.beginObject();
            block18: while (jsonReader.hasNext()) {
                switch (jsonReader.nextName()) {
                    case "format": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        n = jsonReader.nextInt();
                        continue block18;
                    }
                    case "id": {
                        string = jsonReader.nextString();
                        continue block18;
                    }
                    case "name": {
                        string2 = jsonReader.nextString();
                        continue block18;
                    }
                    case "description": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        string3 = jsonReader.nextString();
                        continue block18;
                    }
                    case "sourceLegacyPack": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        string4 = jsonReader.nextString();
                        continue block18;
                    }
                    case "paintings": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            arrayList.add((PaintingResource)this.paintingAdapter.read(jsonReader));
                        }
                        jsonReader.endArray();
                        continue block18;
                    }
                    case "migrations": {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            jsonReader.nextNull();
                            continue block18;
                        }
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            arrayList2.add((MigrationResource)this.migrationAdapter.read(jsonReader));
                        }
                        jsonReader.endArray();
                        continue block18;
                    }
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new PackResource(n, string, string2, string3, string4, List.copyOf(arrayList), List.copyOf(arrayList2));
        }
    }
}

