/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file;

public record FileUid(boolean isFile, String filename, long lastModified, long fileSize, String stringValue) {
    private static final int DIGITS_TIMESTAMP = 8;
    private static final int DIGITS_FILE_SIZE = 8;
    private static final String BASE62_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public FileUid(boolean bl, String string, long l, long l2) {
        this(bl, string, l, l2, FileUid.getStringValue(bl, string, l, l2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileUid)) {
            return false;
        }
        FileUid fileUid = (FileUid)object;
        return this.stringValue().equals(fileUid.stringValue());
    }

    private static String getStringValue(boolean bl, String string, long l, long l2) {
        String string2 = String.valueOf(bl ? 1 : 0);
        String string3 = FileUid.fnv1aHash(string);
        String string4 = FileUid.zeroPad(FileUid.toBase62(l), 8);
        String string5 = FileUid.zeroPad(FileUid.toBase62(l2), 8);
        return String.format("%s%s%s%s", string2, string3, string4, string5);
    }

    private static String fnv1aHash(String string) {
        long l = 1099511628211L;
        long l2 = -3750763034362895579L;
        for (byte by : string.getBytes()) {
            l2 ^= (long)by;
            l2 *= 1099511628211L;
        }
        return String.format("%016x", l2);
    }

    private static String zeroPad(String string, int n) {
        return String.format("%" + n + "s", string).replace(' ', '0');
    }

    private static String toBase62(long l) {
        if (l == 0L) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (l > 0L) {
            int n = (int)(l % 62L);
            stringBuilder.insert(0, BASE62_CHARS.charAt(n));
            l /= 62L;
        }
        return stringBuilder.toString();
    }
}

