/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file;

import java.util.List;
import java.util.Optional;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.resource.file.FileUid;
import me.roundaround.custompaintings.resource.file.Migration;
import me.roundaround.custompaintings.resource.file.Painting;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.InvalidIdException;

public record Pack(Integer format, String id, String name, String description, String sourceLegacyPack, List<Painting> paintings, List<Migration> migrations) {
    public Pack(String string, String string2, String string3, List<Painting> list, List<Migration> list2) {
        this(-1, string, string2, string3, null, list, list2);
    }

    public PackData toData(FileUid fileUid, boolean bl) {
        return new PackData(fileUid.stringValue(), bl, fileUid.fileSize(), this.id, this.name, Optional.ofNullable(this.description), Optional.ofNullable(this.sourceLegacyPack), this.paintings.stream().map(painting -> painting.toData(this.id)).toList(), this.migrations.stream().map(migration -> migration.toData(this.id)).toList());
    }

    public void validateIds() throws InvalidIdException {
        CustomId.validatePart(this.id, "pack");
        int n = 0;
        for (Painting record : this.paintings) {
            record.validateId(n);
            ++n;
        }
        n = 0;
        for (Migration migration : this.migrations) {
            migration.validateIds(n);
            ++n;
        }
    }
}

