/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file.accessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.roundaround.custompaintings.resource.file.accessor.FileAccessor;

public class ZipAccessor
extends FileAccessor {
    private ZipFile zip;
    private String folderPrefix;

    public ZipAccessor(Path path) throws IOException {
        super(path);
        this.zip = new ZipFile(this.path.toFile());
        this.folderPrefix = ZipAccessor.getFolderPrefix(this.zip);
    }

    @Override
    public boolean hasFile(String string) {
        return this.zip.getEntry(this.folderPrefix + string) != null;
    }

    @Override
    public BufferedReader getBufferedReader(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(this.zip.getInputStream(this.zip.getEntry(this.folderPrefix + string))));
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        return this.zip.getInputStream(this.zip.getEntry(this.folderPrefix + string));
    }

    @Override
    public boolean isZip() {
        return true;
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    private static String getFolderPrefix(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        if (!enumeration.hasMoreElements()) {
            return "";
        }
        ZipEntry zipEntry = enumeration.nextElement();
        if (!zipEntry.isDirectory()) {
            return "";
        }
        String string = zipEntry.getName();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (zipEntry2.getName().startsWith(string)) continue;
            return "";
        }
        return string;
    }
}

