/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.nightconfig.core.serde;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.custompaintings.roundalib.nightconfig.core.NullObject;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.Util;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdeAssert;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdeDefault;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdePhase;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdeSkipDeserializingIf;
import me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.SerdeSkipSerializingIf;

final class AnnotationProcessor {
    AnnotationProcessor() {
    }

    static Predicate<?> resolveAssertPredicate(SerdeAssert[] serdeAssertArray, Object object, SerdePhase serdePhase, Field field) {
        ArrayList arrayList = new ArrayList(serdeAssertArray.length);
        for (SerdeAssert serdeAssert : serdeAssertArray) {
            SerdePhase serdePhase2 = serdeAssert.phase();
            SerdeAssert.AssertThat[] assertThatArray = serdeAssert.value();
            SerdeAssertSanityCheck serdeAssertSanityCheck = new SerdeAssertSanityCheck();
            if (serdePhase2 == serdePhase || serdePhase2 == SerdePhase.BOTH) {
                for (int i = 0; i < assertThatArray.length; ++i) {
                    SerdeAssert.AssertThat assertThat = assertThatArray[i];
                    arrayList.add(AnnotationProcessor.resolveAssertPredicate1(assertThat, serdeAssert, object, serdePhase, field.getType(), serdeAssertSanityCheck));
                }
            }
            serdeAssertSanityCheck.check(serdeAssert);
        }
        return AnnotationProcessor.combineAnd(arrayList);
    }

    private static Predicate<?> resolveAssertPredicate1(SerdeAssert.AssertThat assertThat, SerdeAssert serdeAssert, Object object2, SerdePhase serdePhase, Class<?> clazz, SerdeAssertSanityCheck serdeAssertSanityCheck) {
        Class<?> clazz2 = serdeAssert.customClass();
        String string = serdeAssert.customCheck();
        if (assertThat == SerdeAssert.AssertThat.CUSTOM) {
            serdeAssertSanityCheck.hasCustomAssert = true;
            if (string.isEmpty()) {
                throw new SerdeException(String.format("Invalid annotation %s: with AssertThat.CUSTOM, parameter `customCheck` must be provided and non-empty.", AnnotationProcessor.annotToString(serdeAssert)));
            }
            return AnnotationProcessor.findCustomPredicate("assert predicate", serdeAssert, clazz2, string, object2, clazz);
        }
        boolean bl = serdeAssertSanityCheck.hasCustomParam = !string.isEmpty() || clazz2 != Object.class;
        if (assertThat == SerdeAssert.AssertThat.NOT_NULL) {
            return object -> object != null;
        }
        if (assertThat == SerdeAssert.AssertThat.NOT_EMPTY) {
            return object -> object == null || !Util.isEmpty(object);
        }
        assert (false) : "missing case";
        return null;
    }

    static Predicate<?> resolveSkipDeserializingIfPredicate(SerdeSkipDeserializingIf serdeSkipDeserializingIf, Object object) {
        SerdeSkipDeserializingIf.SkipDeIf[] skipDeIfArray = serdeSkipDeserializingIf.value();
        Predicate[] predicateArray = new Predicate[skipDeIfArray.length];
        for (int i = 0; i < predicateArray.length; ++i) {
            SerdeSkipDeserializingIf.SkipDeIf skipDeIf = skipDeIfArray[i];
            predicateArray[i] = AnnotationProcessor.resolveSkipDeserializingIfPredicate1(skipDeIf, serdeSkipDeserializingIf, object, Object.class);
        }
        return AnnotationProcessor.combineOr(predicateArray);
    }

    private static Predicate<?> resolveSkipDeserializingIfPredicate1(SerdeSkipDeserializingIf.SkipDeIf skipDeIf, SerdeSkipDeserializingIf serdeSkipDeserializingIf, Object object2, Class<?> clazz) {
        Class<?> clazz2 = serdeSkipDeserializingIf.customClass();
        String string = serdeSkipDeserializingIf.customCheck();
        if (skipDeIf == SerdeSkipDeserializingIf.SkipDeIf.CUSTOM) {
            if (string.isEmpty()) {
                throw new SerdeException(String.format("Invalid annotation %s: with SkipDeIf.CUSTOM, parameter `customCheck` must be provided and non-empty.", AnnotationProcessor.annotToString(serdeSkipDeserializingIf)));
            }
            return AnnotationProcessor.findCustomPredicate("skip predicate", serdeSkipDeserializingIf, clazz2, string, object2, clazz);
        }
        if (!string.isEmpty() || clazz2 != Object.class) {
            throw new SerdeException(String.format("Invalid annotation %s: with SkipDeIf.%s, no additional parameter must be specified.", AnnotationProcessor.annotToString(serdeSkipDeserializingIf), skipDeIf.name()));
        }
        if (skipDeIf == SerdeSkipDeserializingIf.SkipDeIf.IS_MISSING) {
            return object -> object == null;
        }
        if (skipDeIf == SerdeSkipDeserializingIf.SkipDeIf.IS_NULL) {
            return object -> object == NullObject.NULL_OBJECT;
        }
        if (skipDeIf == SerdeSkipDeserializingIf.SkipDeIf.IS_EMPTY) {
            return object -> object != null && Util.isEmpty(object);
        }
        assert (false) : "missing case";
        return null;
    }

    static Predicate<?> resolveSkipSerializingIfPredicate(SerdeSkipSerializingIf serdeSkipSerializingIf, Object object, Field field) {
        SerdeSkipSerializingIf.SkipSerIf[] skipSerIfArray = serdeSkipSerializingIf.value();
        Predicate[] predicateArray = new Predicate[skipSerIfArray.length];
        for (int i = 0; i < predicateArray.length; ++i) {
            SerdeSkipSerializingIf.SkipSerIf skipSerIf = skipSerIfArray[i];
            predicateArray[i] = AnnotationProcessor.resolveSkipSerializingIfPredicate1(skipSerIf, serdeSkipSerializingIf, object, field.getType());
        }
        return AnnotationProcessor.combineOr(predicateArray);
    }

    private static Predicate<?> resolveSkipSerializingIfPredicate1(SerdeSkipSerializingIf.SkipSerIf skipSerIf, SerdeSkipSerializingIf serdeSkipSerializingIf, Object object2, Class<?> clazz) {
        Class<?> clazz2 = serdeSkipSerializingIf.customClass();
        String string = serdeSkipSerializingIf.customCheck();
        if (skipSerIf == SerdeSkipSerializingIf.SkipSerIf.CUSTOM) {
            if (string.isEmpty()) {
                throw new SerdeException(String.format("Invalid annotation %s: with SkipSerIf.CUSTOM, parameter `customCheck` must be provided and non-empty.", AnnotationProcessor.annotToString(serdeSkipSerializingIf)));
            }
            return AnnotationProcessor.findCustomPredicate("skip predicate", serdeSkipSerializingIf, clazz2, string, object2, clazz);
        }
        if (!string.isEmpty() || clazz2 != Object.class) {
            throw new SerdeException(String.format("Invalid annotation %s: with SkipSerIf.%s, no additional parameter must be specified.", AnnotationProcessor.annotToString(serdeSkipSerializingIf), skipSerIf.name()));
        }
        if (skipSerIf == SerdeSkipSerializingIf.SkipSerIf.IS_NULL) {
            return object -> object == null;
        }
        if (skipSerIf == SerdeSkipSerializingIf.SkipSerIf.IS_EMPTY) {
            return object -> object != null && Util.isEmpty(object);
        }
        assert (false) : "missing case";
        return null;
    }

    private static Predicate<?> pedicateFromField(String string, Field field, Object object, boolean bl) {
        return AnnotationProcessor.anyFromField(Predicate.class, string, field, object, bl);
    }

    static EnumMap<SerdePhase, EnumMap<SerdeDefault.WhenValue, SerdeDefault>> getConfigDefaultAnnotations(Field field) {
        EnumMap<SerdePhase, EnumMap<SerdeDefault.WhenValue, SerdeDefault>> enumMap = new EnumMap<SerdePhase, EnumMap<SerdeDefault.WhenValue, SerdeDefault>>(SerdePhase.class);
        for (SerdeDefault serdeDefault : (SerdeDefault[])field.getAnnotationsByType(SerdeDefault.class)) {
            SerdePhase[] serdePhaseArray = serdeDefault.phase() == SerdePhase.BOTH ? new SerdePhase[]{SerdePhase.BOTH, SerdePhase.SERIALIZING, SerdePhase.DESERIALIZING} : new SerdePhase[]{serdeDefault.phase()};
            for (SerdePhase serdePhase2 : serdePhaseArray) {
                EnumMap enumMap2 = enumMap.computeIfAbsent(serdePhase2, serdePhase -> new EnumMap(SerdeDefault.WhenValue.class));
                for (SerdeDefault.WhenValue whenValue : serdeDefault.whenValue()) {
                    SerdeDefault serdeDefault2 = enumMap2.put(whenValue, serdeDefault);
                    if (serdeDefault2 == null) continue;
                    String string = String.format("Annotation %s is conflicting with annotation %s on field `%s`. Only one @SerdeDefault must be applicable in a given situation.", AnnotationProcessor.annotToString(serdeDefault), serdeDefault2, field);
                    throw new SerdeException(string);
                }
            }
        }
        return enumMap;
    }

    static Supplier<?> resolveConfigDefaultProvider(SerdeDefault serdeDefault, Object object) {
        Class<?> clazz = serdeDefault.cls();
        String string = serdeDefault.provider();
        Class[] classArray = new Class[]{};
        Object object2 = clazz == Object.class ? AnnotationProcessor.findFieldOrMethodIn(object.getClass(), string, true, classArray) : AnnotationProcessor.findFieldOrMethodIn(clazz, string, false, classArray);
        if (object2 == null) {
            String string2 = String.format("Default value provider `%s` not found for annotation %s", string, AnnotationProcessor.annotToString(serdeDefault));
            throw new SerdeException(string2);
        }
        return object2 instanceof Field ? AnnotationProcessor.defaultSupplierFromField((Field)object2, object, clazz != Object.class) : AnnotationProcessor.defaultSupplierFromMethod((Method)object2, object, clazz != Object.class);
    }

    private static <T> Predicate<T> combineOr(Predicate<T>[] predicateArray) {
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        return object -> {
            for (Predicate predicate : predicateArray) {
                if (!predicate.test(object)) continue;
                return true;
            }
            return false;
        };
    }

    private static <T> Predicate<T> combineAnd(List<Predicate<T>> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return object -> {
            for (Predicate predicate : list) {
                if (predicate.test(object)) continue;
                return false;
            }
            return true;
        };
    }

    private static Predicate<?> findCustomPredicate(String string, Annotation annotation, Class<?> clazz, String string2, Object object, Class<?> clazz2) {
        Class[] classArray = new Class[]{clazz2};
        Object object2 = clazz == Object.class ? AnnotationProcessor.findFieldOrMethodIn(object.getClass(), string2, true, classArray) : AnnotationProcessor.findFieldOrMethodIn(clazz, string2, false, classArray);
        if (object2 == null) {
            String string3 = String.format("Custom %s `%s` not found for annotation %s", string, string2, AnnotationProcessor.annotToString(annotation));
            throw new SerdeException(string3);
        }
        return object2 instanceof Field ? AnnotationProcessor.pedicateFromField(string, (Field)object2, object, clazz != Object.class) : AnnotationProcessor.predicateFromMethod(string, (Method)object2, object, clazz != Object.class, clazz2);
    }

    private static Object findFieldOrMethodIn(Class<?> clazz, String string, boolean bl, Class<?>[] classArray) {
        boolean bl2 = false;
        if (string.endsWith("()")) {
            bl2 = true;
            string = string.substring(0, string.length() - 2);
        }
        while (true) {
            if (!bl2) {
                try {
                    return clazz.getDeclaredField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (bl && (clazz = clazz.getSuperclass()) != Object.class) continue;
                return null;
            }
            break;
        }
    }

    private static Supplier<?> defaultSupplierFromField(Field field, Object object, boolean bl) {
        return AnnotationProcessor.anyFromField(Supplier.class, "default value provider", field, object, bl);
    }

    private static Supplier<?> defaultSupplierFromMethod(Method method, Object object, boolean bl) {
        return AnnotationProcessor.supplierFromMethod("default value provider", method, object, bl);
    }

    private static <T> T anyFromField(Class<T> clazz, String string, Field field, Object object, boolean bl) {
        Object object2;
        int n = field.getModifiers();
        if (!Modifier.isPublic(n)) {
            field.setAccessible(true);
        }
        if (bl && !Modifier.isStatic(n)) {
            String string2 = String.format("Invalid %s: field %s should be declared as static.", string, field);
            throw new SerdeException(string2);
        }
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            String string3 = String.format("Could not read the %s `%s` on object `%s`.", string, field, object);
            throw new SerdeException(string3, exception);
        }
        if (object2 == null) {
            throw new SerdeException(String.format("Invalid %s: field `%s` is null in object `%s`.", string, field, object));
        }
        if (!clazz.isAssignableFrom(object2.getClass())) {
            throw new SerdeException(String.format("Invalid %s: field `%s` must be of type `%s`.", string, field.getName(), clazz));
        }
        return (T)object2;
    }

    private static Supplier<?> supplierFromMethod(String string, Method method, Object object, boolean bl) {
        if (method.getParameterCount() > 0) {
            throw new SerdeException(String.format("Invalid %s: method %s should take no parameter.", string, method));
        }
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            method.setAccessible(true);
        }
        if (Modifier.isStatic(n)) {
            return () -> {
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    throw new SerdeException(String.format("Could not invoke the %s `%s`", string, exception));
                }
            };
        }
        if (bl) {
            String string2 = String.format("Invalid %s: method %s should be declared as static.", string, method);
            throw new SerdeException(string2);
        }
        return () -> {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new SerdeException(String.format("Could not invoke the %s `%s` on object %s", string, method, object), exception);
            }
        };
    }

    private static Predicate<?> predicateFromMethod(String string, Method method, Object object3, boolean bl, Class<?> clazz) {
        if (method.getParameterCount() != 1) {
            throw new SerdeException(String.format("Invalid %s: method %s should take exactly one parameter of type %s.", string, method, clazz));
        }
        if (method.getReturnType() != Boolean.TYPE) {
            throw new SerdeException(String.format("Invalid %s: method %s should return a boolean.", string, method));
        }
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            method.setAccessible(true);
        }
        if (Modifier.isStatic(n)) {
            return object -> {
                try {
                    return (Boolean)method.invoke(null, object);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    throw new SerdeException(String.format("Could not invoke the %s `%s`", string, exception));
                }
            };
        }
        if (bl) {
            String string2 = String.format("Invalid %s: method %s should be declared as static.", string, method);
            throw new SerdeException(string2);
        }
        return object2 -> {
            try {
                return (Boolean)method.invoke(object3, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new SerdeException(String.format("Could not invoke the %s `%s` on object %s", string, method, object3), exception);
            }
        };
    }

    static String annotToString(Annotation annotation) {
        return annotation.toString().replace("@me.roundaround.custompaintings.roundalib.nightconfig.core.serde.annotations.", "@");
    }

    private static class SerdeAssertSanityCheck {
        boolean hasCustomAssert;
        boolean hasCustomParam;

        private SerdeAssertSanityCheck() {
        }

        void check(SerdeAssert serdeAssert) {
            if (this.hasCustomParam && !this.hasCustomAssert) {
                throw new SerdeException(String.format("Invalid annotation %s: without AssertThat.CUSTOM, no additional parameter must be specified.", AnnotationProcessor.annotToString(serdeAssert)));
            }
        }
    }
}

