/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.mmmtweaks.feature;

import club.someoneice.mmmtweaks.Config;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Objects;

public class Cache<K, V> {
    LinkedHashMap<K, Node> cache = Maps.newLinkedHashMap();

    public void put(K key, V value) {
        Node node = this.cache.getOrDefault(key, new Node(value).reset());
        this.cache.put(key, node);
    }

    public V get(K key) {
        Node node = this.cache.get(key);
        if (Objects.isNull(node)) {
            return null;
        }
        node.reset();
        this.cache.entrySet().removeIf(entry -> ((Node)entry.getValue()).addCallRound().shouldRemove());
        return node.value;
    }

    public V getOrDefault(K key, V defaultValue) {
        V value = this.get(key);
        return Objects.isNull(value) ? defaultValue : value;
    }

    private class Node {
        V value;
        int callRounds = 0;

        Node(V value) {
            this.value = value;
        }

        Node set(V value) {
            this.value = value;
            return this;
        }

        Node addCallRound() {
            ++this.callRounds;
            return this;
        }

        Node reset() {
            this.callRounds = 0;
            return this;
        }

        boolean shouldRemove() {
            return this.callRounds > Config.CRAFTING_CACHE_LIVE_ROUND;
        }
    }
}

