/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.mmmtweaks.feature;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class CleanEntityEvent {
    private static final Map<World, Set<Chunk>> taskMap = Maps.newHashMap();

    @SubscribeEvent
    public void onChunkLoaded(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        Set<Chunk> set = taskMap.getOrDefault(event.world, Sets.newHashSet());
        set.add(event.getChunk());
        taskMap.put(event.world, set);
    }

    @SubscribeEvent
    public void onChunkUnloaded(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        CleanEntityEvent.setMobsDeadFromChunk(event.getChunk());
    }

    @SubscribeEvent
    public void worldTicks(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Set<Chunk> set = taskMap.get(event.world);
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator<Chunk> iterator = set.iterator();
        while (iterator.hasNext()) {
            Chunk chunk = iterator.next();
            if (!chunk.field_76636_d) continue;
            CleanEntityEvent.setMobsDeadFromChunk(chunk);
            iterator.remove();
        }
    }

    private static void setMobsDeadFromChunk(Chunk chunk) {
        Arrays.stream(chunk.field_76645_j).map(it -> it).flatMap(Collection::stream).filter(CleanEntityEvent::isIn).forEach(Entity::func_70106_y);
    }

    private static boolean isIn(Entity entity) {
        return entity instanceof EntityMob || entity instanceof IProjectile || entity instanceof EntityItem;
    }
}

