/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.mmmtweaks.overload;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.tileentity.TileEntityCrystalZ;

public final class CollectHandler {
    private CollectHandler() {
    }

    public static void onWork(TileEntityCrystalZ tile, World world) {
        Chunk[] chunks = CollectHandler.getChunkRange(tile.field_145851_c, tile.field_145849_e, tile.range, world);
        ArrayList items = Lists.newArrayList();
        Arrays.stream(chunks).flatMap(it -> Arrays.stream(it.field_76645_j)).map(it -> it).forEach(it -> CollectHandler.findEntityInChunk(it, tile, items));
        for (EntityItem itemEntity : items) {
            ItemStack item = itemEntity.func_92059_d();
            int size = item.field_77994_a;
            if (MMM.tryInsertStack((IInventory)tile.getTarget(), (ItemStack)item)) {
                itemEntity.func_70106_y();
            }
            if (item.field_77994_a == size) {
                return;
            }
            if (!M3Config.AutoCrystalEffec) {
                return;
            }
            CollectHandler.sendPackage(itemEntity, tile, world);
        }
    }

    private static void sendPackage(EntityItem item, TileEntityCrystalZ tile, World world) {
        if (Objects.isNull(tile.targetpoint)) {
            tile.targetpoint = new NetworkRegistry.TargetPoint(MMM.getDimensionID((World)world), (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 16.0);
        }
        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(1, item.field_70165_t, item.field_70163_u, item.field_70161_v, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), tile.targetpoint);
    }

    private static void findEntityInChunk(List<Entity> entities, TileEntityCrystalZ tile, List<EntityItem> items) {
        entities.stream().filter(it -> it instanceof EntityItem).filter(it -> CollectHandler.canEffect((TileEntity)tile, it, tile.range)).map(it -> (EntityItem)it).forEach(items::add);
    }

    private static boolean canEffect(TileEntity tile, Entity entity, int range) {
        return Math.abs(entity.field_70163_u - (double)tile.field_145848_d) < (double)range && Math.max(Math.abs(entity.field_70165_t - (double)tile.field_145851_c), Math.abs(entity.field_70161_v - (double)tile.field_145849_e)) < (double)range;
    }

    private static Chunk[] getChunkRange(int x, int z, int range, World world) {
        Chunk chunk = world.func_72938_d(x, z);
        x = Math.abs(x) % 16;
        z = Math.abs(z) % 16;
        if (range < 7 && x >= range && x <= 16 - range && z >= range && z <= 16 - range) {
            return new Chunk[]{chunk};
        }
        int rangeX = x > 8 ? 1 : -1;
        int rangeZ = z > 8 ? 1 : -1;
        return new Chunk[]{chunk, world.func_72964_e(chunk.field_76635_g + rangeX, chunk.field_76647_h), world.func_72964_e(chunk.field_76635_g, chunk.field_76647_h + rangeZ), world.func_72964_e(chunk.field_76635_g + rangeX, chunk.field_76647_h + rangeZ)};
    }
}

