/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.mmmtweaks.overload;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.ILogisticsBox;
import project.studio.manametalmod.core.ItemType;

public final class SortingHandler {
    private SortingHandler() {
    }

    public static void scanInventory(IInventory inventory, World world, Multimap<ItemType, ChunkPosition> cache) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            for (ChunkPosition pos : cache.get((Object)ItemType.Other)) {
                TileEntity tile = world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                if (!(tile instanceof IInventory)) {
                    cache.remove((Object)ItemType.Other, (Object)pos);
                    continue;
                }
                IInventory inv = (IInventory)tile;
                if (MMM.hasItemStack((ItemStack)stack, (IInventory)inv) && !MMM.tryInsertStack((IInventory)inv, (ItemStack)stack)) continue;
                break;
            }
            if (stack.field_77994_a <= 0) continue;
            List itemTypes = ItemType.getTypeFromItem((ItemStack)stack);
            for (ItemType type : itemTypes) {
                if (!cache.containsKey((Object)type)) continue;
                SortingHandler.insertStackTo(world, stack, cache, type);
                if (stack.field_77994_a > 0) continue;
                break;
            }
            if (stack.field_77994_a <= 0 || !cache.containsKey((Object)ItemType.Any)) break;
            SortingHandler.insertStackTo(world, stack, cache, ItemType.Any);
        }
    }

    private static void insertStackTo(World world, ItemStack stack, Multimap<ItemType, ChunkPosition> cache, ItemType type) {
        for (ChunkPosition position : cache.get((Object)type)) {
            TileEntity tile = world.func_147438_o(position.field_151329_a, position.field_151327_b, position.field_151328_c);
            if (!(tile instanceof IInventory)) {
                cache.remove((Object)type, (Object)position);
                continue;
            }
            IInventory inv = (IInventory)tile;
            if (!MMM.tryInsertStack((IInventory)inv, (ItemStack)stack)) continue;
            break;
        }
    }

    public static Multimap<ItemType, ChunkPosition> findAndCache(World world, ChunkPosition pos) {
        HashMultimap table = HashMultimap.create();
        for (int y = 0; y <= 3; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    ILogisticsBox box;
                    int posX = pos.field_151329_a + x;
                    int posY = pos.field_151327_b + y;
                    int posZ = pos.field_151328_c + z;
                    TileEntity tile = world.func_147438_o(posX, posY, posZ);
                    if (!(tile instanceof ILogisticsBox) || !(box = (ILogisticsBox)tile).canInput()) continue;
                    table.put((Object)box.getBoxType(), (Object)pos);
                }
            }
        }
        return table;
    }
}

