/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.mmmtweaks.overload.crystal_crafting;

import club.someoneice.json.Pair;
import club.someoneice.mmmtweaks.feature.Cache;
import club.someoneice.mmmtweaks.overload.crystal_crafting.DataCraftCrystal;
import club.someoneice.pineapplepsychic.util.Util;
import club.someoneice.togocup.tags.Ingredient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CraftingHelper {
    static final Cache<Integer, Cache<Integer, ImmutableMap<ImmutableList<Ingredient>, ItemStack>>> RECIPE_CACHE_POOL = new Cache();

    private CraftingHelper() {
    }

    public static DataCraftCrystal checkData(DataCraftCrystal dataCache, ItemStack item) {
        if (Objects.nonNull(dataCache) && Util.itemStackEquals((ItemStack)dataCache.getItemStack(), (ItemStack)item)) {
            return dataCache;
        }
        return new DataCraftCrystal(item);
    }

    public static ImmutableMap<ImmutableList<Ingredient>, ItemStack> findCacheOrRegister(ItemStack item) {
        int id = Item.func_150891_b((Item)item.func_77973_b());
        int meta = item.func_77960_j();
        Cache<Integer, ImmutableMap<ImmutableList<Ingredient>, ItemStack>> cache = RECIPE_CACHE_POOL.get(id);
        if (Objects.isNull(cache)) {
            return CraftingHelper.registerCache(item);
        }
        ImmutableMap<ImmutableList<Ingredient>, ItemStack> cached = cache.get(meta);
        return Objects.isNull(cached) ? CraftingHelper.registerCache(item) : cached;
    }

    public static ImmutableMap<ImmutableList<Ingredient>, ItemStack> registerCache(ItemStack item) {
        int id = Item.func_150891_b((Item)item.func_77973_b());
        int meta = item.func_77960_j();
        ImmutableMap<ImmutableList<Ingredient>, ItemStack> recipes = CraftingHelper.findRecipeByItemStack(item);
        RECIPE_CACHE_POOL.getOrDefault(id, new Cache()).put(meta, recipes);
        return recipes;
    }

    public static ImmutableMap<ImmutableList<Ingredient>, ItemStack> findRecipeByItemStack(ItemStack recipeOut) {
        List recipeList = CraftingManager.func_77594_a().func_77592_b().stream().filter(it -> Util.itemStackEquals((ItemStack)it.func_77571_b(), (ItemStack)recipeOut)).collect(Collectors.toList());
        if (recipeList.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder recipes = ImmutableMap.builder();
        recipeList.stream().map(CraftingHelper::getInputs).forEach(pair -> recipes.put(pair.getKey(), (Object)((ItemStack)pair.getValue()).func_77946_l()));
        return recipes.build();
    }

    @Nullable
    private static Ingredient getIngredientByOreDictionaryObject(Object item) {
        if (item instanceof ItemStack) {
            return new Ingredient((ItemStack)item);
        }
        if (!(item instanceof List)) {
            return null;
        }
        List list = (List)item;
        list.removeIf(Objects::isNull);
        ItemStack[] items = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            items[i] = (ItemStack)list.get(i);
        }
        return new Ingredient(items);
    }

    private static Pair<ImmutableList<Ingredient>, ItemStack> getInputs(IRecipe recipeInput) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (recipeInput instanceof ShapedRecipes) {
            ShapedRecipes subRecipe = (ShapedRecipes)recipeInput;
            Arrays.stream(subRecipe.field_77574_d).forEach(item -> builder.add((Object)new Ingredient(item)));
            return new Pair((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapelessRecipes) {
            ShapelessRecipes subRecipe = (ShapelessRecipes)recipeInput;
            subRecipe.field_77579_b.forEach(item -> builder.add((Object)new Ingredient(item)));
            return new Pair((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapedOreRecipe) {
            ShapedOreRecipe subRecipe = (ShapedOreRecipe)recipeInput;
            Arrays.stream(subRecipe.getInput()).forEach(obj -> {
                Ingredient ingredient = CraftingHelper.getIngredientByOreDictionaryObject(obj);
                if (ingredient != null) {
                    builder.add((Object)ingredient);
                }
            });
            return new Pair((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe subRecipe = (ShapelessOreRecipe)recipeInput;
            subRecipe.getInput().forEach(obj -> {
                Ingredient ingredient = CraftingHelper.getIngredientByOreDictionaryObject(obj);
                if (ingredient != null) {
                    builder.add((Object)ingredient);
                }
            });
            return new Pair((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        return new Pair((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
    }
}

