/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod;

import dev.yesBad.servermod.command.DelHome;
import dev.yesBad.servermod.command.Endersee;
import dev.yesBad.servermod.command.Home;
import dev.yesBad.servermod.command.Invsee;
import dev.yesBad.servermod.command.Leaderboard;
import dev.yesBad.servermod.command.ListHome;
import dev.yesBad.servermod.command.Nick;
import dev.yesBad.servermod.command.Randomtp;
import dev.yesBad.servermod.command.Rank;
import dev.yesBad.servermod.command.Servermod;
import dev.yesBad.servermod.command.SetHome;
import dev.yesBad.servermod.command.Tpa;
import dev.yesBad.servermod.command.Tpaccept;
import dev.yesBad.servermod.utils.Messages;
import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.PlayerUtils;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="servermod", name="yesBad's ServerMod", version="1.2", serverSideOnly=true, acceptableRemoteVersions="*")
public class servermod {
    public static final String MODID = "servermod";
    public static final String NAME = "yesBad's ServerMod";
    public static final Logger LOGGER = LogManager.getLogger((String)"servermod");
    public static final String VERSION = "1.2";
    private static final LinkedList<ScheduledTask> scheduledTasks = new LinkedList();

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent preinit) {
        ModConfig.init(new File(Launch.minecraftHome, "config" + File.separator + "servermod.cfg"));
        LOGGER.info("yesBad's ServerMod v1.2 has been loaded...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Messages());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Servermod());
        LOGGER.info("Registered command: /servermod");
        if (ModConfig.enableInvsee) {
            event.registerServerCommand((ICommand)new Invsee());
        }
        LOGGER.info("Registered command: /invsee");
        if (ModConfig.enableEndersee) {
            event.registerServerCommand((ICommand)new Endersee());
        }
        LOGGER.info("Registered command: /endersee");
        if (ModConfig.enableLeaderboard) {
            event.registerServerCommand((ICommand)new Leaderboard());
        }
        LOGGER.info("Registered command: /leaderboard");
        if (ModConfig.enableTPA) {
            event.registerServerCommand((ICommand)new Tpa());
            LOGGER.info("Registered command: /tpa");
            event.registerServerCommand((ICommand)new Tpaccept());
            LOGGER.info("Registered command: /tpaccept");
        }
        if (ModConfig.enableRTP) {
            event.registerServerCommand((ICommand)new Randomtp());
        }
        LOGGER.info("Registered command: /rtp");
        if (ModConfig.enableNicknameSystem) {
            event.registerServerCommand((ICommand)new Rank());
            LOGGER.info("Registered command: /rank");
            event.registerServerCommand((ICommand)new Nick());
            LOGGER.info("Registered command: /nick");
        }
        if (ModConfig.maxHomes != 0) {
            event.registerServerCommand((ICommand)new SetHome());
            LOGGER.info("Registered command: /sethome");
            event.registerServerCommand((ICommand)new Home());
            LOGGER.info("Registered command: /home");
            event.registerServerCommand((ICommand)new ListHome());
            LOGGER.info("Registered command: /listhome");
            event.registerServerCommand((ICommand)new DelHome());
            LOGGER.info("Registered command: /delhome");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayerMP player = PlayerUtils.getPlayerFromName(event.player.func_70005_c_());
        if (player != null) {
            NBTTagCompound playerData = player.getEntityData();
            long last_seen = player.field_70170_p.func_82737_E();
            playerData.func_74772_a("last_seen", last_seen);
            LOGGER.info("Set last_seen for " + player.func_70005_c_() + " to " + last_seen);
        } else {
            LOGGER.warn("Player left funnily, last_seen set failed.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = PlayerUtils.getPlayerFromName(event.player.func_70005_c_());
        if (player != null) {
            NBTTagCompound playerData = player.getEntityData();
            long last_seen = player.field_70170_p.func_82737_E();
            playerData.func_74772_a("last_seen", last_seen);
            if (ModConfig.joinMessage != null && !ModConfig.joinMessage.isEmpty()) {
                String joinMsgRaw = ModConfig.joinMessage;
                String linkUrl = ModConfig.joinLink != null ? ModConfig.joinLink : "";
                String formattedMsg = ModConfig.format(joinMsgRaw, "user", player.getDisplayNameString());
                TextComponentString clickableMsg = new TextComponentString(Parser.Color(formattedMsg));
                clickableMsg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, linkUrl));
                player.func_145747_a((ITextComponent)clickableMsg);
            }
            LOGGER.info("Set last_seen for " + player.func_70005_c_() + " to " + last_seen + " & sent join message (if enabled)");
        } else {
            LOGGER.warn("Player joined funnily, last_seen set failed.");
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator it = scheduledTasks.iterator();
        while (it.hasNext()) {
            ScheduledTask t = (ScheduledTask)it.next();
            --t.ticksLeft;
            if (t.ticksLeft > 0) continue;
            try {
                t.task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            it.remove();
        }
    }

    public static void scheduleTask(int ticks, Runnable task) {
        scheduledTasks.add(new ScheduledTask(ticks, task));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (!ModConfig.enableSleepPerc) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        servermod.scheduleTask(40, () -> {
            if (!player.func_70608_bn()) {
                return;
            }
            LOGGER.info("Player " + player.func_70005_c_() + " is sleeping, checking sleep percentage...");
            long sleepingPlayers = world.field_73010_i.stream().filter(p -> p.func_70608_bn()).count();
            int totalPlayers = world.field_73010_i.size();
            int percentConfig = ModConfig.sleepPerc;
            int requiredSleeping = (int)Math.ceil((double)totalPlayers * ((double)percentConfig / 100.0));
            if (!world.func_72935_r()) {
                TextComponentString message = new TextComponentString(Parser.Color(ModConfig.format(ModConfig.userIsSleeping, "user", player.getDisplayNameString(), "sleepers", sleepingPlayers, "required", requiredSleeping)));
                world.field_73010_i.forEach(p -> p.func_145747_a((ITextComponent)message));
                if (sleepingPlayers >= (long)requiredSleeping) {
                    TextComponentString skippedMessage = new TextComponentString(Parser.Color(ModConfig.goodMorning));
                    world.field_73010_i.forEach(p -> p.func_145747_a((ITextComponent)skippedMessage));
                    long dayTime = world.func_72820_D() + 24000L;
                    world.func_72877_b(dayTime - dayTime % 24000L);
                    world.func_72912_H().func_76080_g(0);
                    world.func_72912_H().func_76084_b(false);
                    world.func_72912_H().func_76090_f(0);
                    world.func_72912_H().func_76069_a(false);
                    LOGGER.info("Night skipped");
                }
            }
        });
    }

    private static class ScheduledTask {
        int ticksLeft;
        Runnable task;

        ScheduledTask(int ticks, Runnable task) {
            this.ticksLeft = ticks;
            this.task = task;
        }
    }
}

