/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.yesBad.servermod.servermod;
import java.io.File;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;

public class PlayerRankData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File DATA_FILE = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "player_rank_data.json");
    private static final JsonParser JSON_PARSER = new JsonParser();

    public static void set(EntityPlayerMP player, String tag, Object value) {
        String uuid;
        JsonObject data = PlayerRankData.loadData();
        if (!data.has(uuid = player.func_110124_au().toString())) {
            data.add(uuid, (JsonElement)new JsonObject());
        }
        JsonObject playerData = data.get(uuid).getAsJsonObject();
        if (value instanceof String) {
            playerData.addProperty(tag, (String)value);
        } else if (value instanceof Boolean) {
            playerData.addProperty(tag, (Boolean)value);
        } else if (value instanceof Number) {
            playerData.addProperty(tag, (Number)value);
        } else {
            throw new IllegalArgumentException();
        }
        PlayerRankData.saveData(data);
    }

    public static String getString(EntityPlayerMP player, String tag) {
        String uuid;
        JsonObject data = PlayerRankData.loadData();
        if (!data.has(uuid = player.func_110124_au().toString())) {
            return null;
        }
        JsonObject playerData = data.get(uuid).getAsJsonObject();
        String value = null;
        if (playerData.has(tag)) {
            value = playerData.get(tag).getAsString();
        }
        return value;
    }

    public static Boolean getBoolean(EntityPlayerMP player, String tag) {
        String uuid;
        JsonObject data = PlayerRankData.loadData();
        if (!data.has(uuid = player.func_110124_au().toString())) {
            return null;
        }
        JsonObject playerData = data.get(uuid).getAsJsonObject();
        Boolean value = null;
        if (playerData.has(tag)) {
            value = playerData.get(tag).getAsBoolean();
        }
        return value;
    }

    public static Number getNumber(EntityPlayerMP player, String tag) {
        String uuid;
        JsonObject data = PlayerRankData.loadData();
        if (!data.has(uuid = player.func_110124_au().toString())) {
            return null;
        }
        JsonObject playerData = data.get(uuid).getAsJsonObject();
        Number value = null;
        if (playerData.has(tag)) {
            value = playerData.get(tag).getAsNumber();
        }
        return value;
    }

    public static void clear(EntityPlayerMP player) {
        JsonObject data = PlayerRankData.loadData();
        String uuid = player.func_110124_au().toString();
        data.remove(uuid);
        PlayerRankData.saveData(data);
    }

    private static JsonObject loadData() {
        if (!DATA_FILE.exists()) {
            return new JsonObject();
        }
        try {
            String json = FileUtils.readFileToString((File)DATA_FILE, (String)"UTF-8");
            return JSON_PARSER.parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            servermod.LOGGER.warn((Object)e);
            JsonObject jsonObject = new JsonObject();
            PlayerRankData.saveData(jsonObject);
            return jsonObject;
        }
    }

    private static void saveData(JsonObject data) {
        try {
            FileUtils.writeStringToFile((File)DATA_FILE, (String)GSON.toJson((JsonElement)data), (String)"UTF-8");
        }
        catch (IOException e) {
            servermod.LOGGER.warn((Object)e);
        }
    }
}

