/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.command;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import dev.yesBad.servermod.servermod;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.PlayerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.io.FileUtils;

public class Leaderboard
extends CommandBase {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final String USAGE = "/leaderboard <type> (page)";

    public String func_71517_b() {
        return "leaderboard";
    }

    public String func_71518_a(ICommandSender sender) {
        return USAGE;
    }

    public List<String> func_71514_a() {
        return Arrays.asList("lb", "leaderboards");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return Leaderboard.func_175762_a((String[])args, Arrays.asList("playtime", "deaths", "mob_kills", "last_seen"));
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        new Thread(() -> {
            Map<String, Long> leaderboardData;
            if (args.length < 1 || args.length > 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&4/leaderboard <type> (page)")));
                return;
            }
            String type = args[0];
            int page = 1;
            if (args.length == 2) {
                try {
                    page = Integer.parseInt(args[1]);
                    if (page < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&cInvalid page number.")));
                    return;
                }
            }
            if ((leaderboardData = this.getLeaderboardData(server, type)).isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&cUnknown leaderboard, try these: &6playtime&8, &6mob_kills&8, &6deaths&8, &6last_seen&8.")));
                return;
            }
            servermod.LOGGER.info(sender.func_70005_c_() + " requested /lb " + type + " " + page);
            List sortedEntries = leaderboardData.entrySet().stream().sorted(type.equals("last_seen") ? Map.Entry.comparingByValue() : Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
            int entriesPerPage = 15;
            int totalPages = (int)Math.ceil((double)sortedEntries.size() / (double)entriesPerPage);
            if (page > totalPages) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&cPage &6" + page + " &cdoes not exist. &bTotal pages: &6" + totalPages)));
                return;
            }
            int startIndex = (page - 1) * entriesPerPage;
            int endIndex = Math.min(startIndex + entriesPerPage, sortedEntries.size());
            sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&b&l" + this.getTitle(type))));
            for (int i = startIndex; i < endIndex; ++i) {
                Map.Entry entry = (Map.Entry)sortedEntries.get(i);
                int rank = i + 1;
                sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&7&o" + rank + " &8 ") + Parser.Color(this.getPlayerName(server, (String)entry.getKey(), sender.func_70005_c_())) + Parser.Color("&8 | &3" + Leaderboard.formatValue((Long)entry.getValue(), type))));
            }
            if (page != totalPages) {
                TextComponentString paging = new TextComponentString(Parser.Color("&bClick for next page. &7&o(Page &3&o" + page + " &7&oof total &3&o" + totalPages + "&7&o)"));
                ClickEvent pagination = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/lb " + type + " " + (page + 1));
                paging.func_150255_a(paging.func_150256_b().func_150241_a(pagination));
                sender.func_145747_a((ITextComponent)paging);
            }
        }).start();
    }

    private Map<String, Long> getLeaderboardData(MinecraftServer server, String type) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>();
        File worldDir = server.func_71218_a(0).getChunkSaveLocation();
        File statsDir = new File(worldDir, "stats");
        File playerDataDir = new File(worldDir, "playerdata");
        switch (type) {
            case "playtime": 
            case "deaths": 
            case "mob_kills": {
                this.loadStatData(dataMap, statsDir, type);
                break;
            }
            case "last_seen": {
                this.loadLastSeenData(dataMap, playerDataDir, server);
            }
        }
        return dataMap;
    }

    private void loadStatData(Map<String, Long> dataMap, File statsDir, String type) {
        if (statsDir.isDirectory()) {
            for (File file : statsDir.listFiles((dir, name) -> name.endsWith(".json"))) {
                try {
                    JsonObject data = JSON_PARSER.parse(FileUtils.readFileToString((File)file, (String)"UTF-8")).getAsJsonObject();
                    String UUID = file.getName().replace(".json", "");
                    switch (type) {
                        case "playtime": {
                            long e = data.has("stat.playOneMinute") ? data.get("stat.playOneMinute").getAsLong() : 0L;
                            dataMap.put(UUID, e);
                            break;
                        }
                        case "deaths": {
                            long a = data.has("stat.deaths") ? data.get("stat.deaths").getAsLong() : 0L;
                            dataMap.put(UUID, a);
                            break;
                        }
                        case "mob_kills": {
                            long f = data.has("stat.mobKills") ? data.get("stat.mobKills").getAsLong() : 0L;
                            dataMap.put(UUID, f);
                        }
                    }
                }
                catch (IOException e) {
                    servermod.LOGGER.warn("Error reading stats for " + file.getName(), (Throwable)e);
                }
            }
        }
    }

    private void loadLastSeenData(Map<String, Long> dataMap, File playerDataDir, MinecraftServer server) {
        if (playerDataDir.isDirectory()) {
            for (File file : playerDataDir.listFiles((dir, name) -> name.endsWith(".dat"))) {
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                    NBTTagCompound forgeData = nbt.func_74775_l("ForgeData");
                    long lastSeen = forgeData.func_74763_f("last_seen");
                    long elapsedTime = server.func_71218_a(0).func_82737_E() - lastSeen;
                    String UUID = file.getName().replace(".dat", "");
                    dataMap.put(UUID, elapsedTime);
                }
                catch (IOException e) {
                    servermod.LOGGER.warn("Error reading player data for " + file.getName(), (Throwable)e);
                }
            }
        }
    }

    private String getPlayerName(MinecraftServer server, String UUID2, String senderName) {
        String name;
        GameProfile profile = server.func_152358_ax().func_152652_a(UUID.fromString(UUID2));
        String string = name = profile != null ? profile.getName() : PlayerUtils.getUserName(UUID2);
        return name == null ? UUID2 : (name.equals(senderName) ? "&a" + senderName : "&6" + name);
    }

    private String getTitle(String type) {
        switch (type) {
            case "playtime": {
                return "Playtime:";
            }
            case "mob_kills": {
                return "Mob Kills:";
            }
            case "deaths": {
                return "Deaths:";
            }
            case "last_seen": {
                return "Last Seen:";
            }
        }
        return "";
    }

    public static String formatValue(long ticks, String type) {
        String suffix;
        if (type.equals("mob_kills") || type.equals("deaths")) {
            return String.valueOf(ticks);
        }
        int TICKS_PER_SECOND = 20;
        int TICKS_PER_MINUTE = 1200;
        int TICKS_PER_HOUR = 72000;
        String string = suffix = type.equals("last_seen") ? " ago" : "";
        if (ticks < 2400L) {
            long seconds = ticks / 20L;
            return seconds + " seconds" + suffix;
        }
        if (ticks < 144000L) {
            long minutes = ticks / 1200L;
            return minutes + " minutes" + suffix;
        }
        long hours = ticks / 72000L;
        return hours + " hours" + suffix;
    }
}

