/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.command;

import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.PlayerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class Randomtp
extends CommandBase {
    public static final Map<String, Long> lastExecutionTime = new HashMap<String, Long>();
    private static final long cooldownSeconds = ModConfig.cooldownRTP;

    public String func_71517_b() {
        return "rtp";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("rtp");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rtp";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (sender instanceof EntityPlayer) {
            int y;
            int z;
            int x;
            BlockPos pos;
            IBlockState blockState;
            Block block;
            EntityPlayer player = (EntityPlayer)sender;
            World world = player.func_130014_f_();
            if (world.field_73011_w.getDimension() != 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&4This command only works in the overworld.")));
                return;
            }
            if (this.isOnCooldown(player.func_70005_c_()) && !PlayerUtils.isPlayerOp(sender)) {
                String timeString;
                long remainingCooldown = this.getRemainingCooldown(player.func_70005_c_());
                if (remainingCooldown >= 7200L) {
                    double hours = (double)remainingCooldown / 3600.0;
                    timeString = String.format("%.1f", hours) + " hours";
                } else if (remainingCooldown >= 120L) {
                    double minutes = (double)remainingCooldown / 60.0;
                    timeString = String.format("%.1f", minutes) + " minutes";
                } else {
                    timeString = remainingCooldown + " seconds";
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&6Cooldown ends in &e" + timeString + "&6.")));
                return;
            }
            int centerX = (int)world.func_175723_af().func_177731_f();
            int centerZ = (int)world.func_175723_af().func_177721_g();
            int range = (int)world.func_175723_af().func_177741_h() / 2;
            Random rand = new Random();
            do {
                x = centerX + rand.nextInt(range) - range / 2;
                z = centerZ + rand.nextInt(range) - range / 2;
                pos = world.func_175672_r(new BlockPos(x, 0, z));
                y = pos.func_177956_o();
            } while ((block = (blockState = world.func_180495_p(pos)).func_177230_c()) instanceof BlockLiquid || !world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2)));
            player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&aTeleporting to a random location...")));
            lastExecutionTime.put(player.func_70005_c_(), System.currentTimeMillis());
            player.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        }
    }

    private boolean isOnCooldown(String playerName) {
        if (lastExecutionTime.containsKey(playerName)) {
            long cooldownMillis;
            long lastExecution = lastExecutionTime.get(playerName);
            long currentTime = System.currentTimeMillis();
            return currentTime - lastExecution < (cooldownMillis = cooldownSeconds * 1000L);
        }
        return false;
    }

    private long getRemainingCooldown(String playerName) {
        if (lastExecutionTime.containsKey(playerName)) {
            long lastExecution = lastExecutionTime.get(playerName);
            long currentTime = System.currentTimeMillis();
            long cooldownMillis = cooldownSeconds * 1000L;
            long remainingCooldownMillis = cooldownMillis - (currentTime - lastExecution);
            return remainingCooldownMillis / 1000L;
        }
        return 0L;
    }
}

