/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.command;

import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.Teleports;
import dev.yesBad.servermod.utils.tp.Teleport;
import dev.yesBad.servermod.utils.tp.ToTeleport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class Tpa
extends CommandBase {
    public static final Map<String, Long> lastExecutionTime = new HashMap<String, Long>();
    private static final long cooldownSeconds = ModConfig.cooldownTPA;

    public String func_71517_b() {
        return "tpa";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/tpa <username>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public List<String> func_71514_a() {
        return Arrays.asList("tpa", "tpask");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World targetter;
        String playerName = sender.func_70005_c_();
        if (!sender.func_70003_b(4, "tpa") && this.isOnCooldown(playerName)) {
            String timeString;
            long remainingCooldown = this.getRemainingCooldown(playerName);
            if (remainingCooldown >= 7200L) {
                double hours = (double)remainingCooldown / 3600.0;
                timeString = String.format("%.1f", hours) + " hours";
            } else if (remainingCooldown >= 120L) {
                double minutes = (double)remainingCooldown / 60.0;
                timeString = String.format("%.1f", minutes) + " minutes";
            } else {
                timeString = remainingCooldown + " seconds";
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&6Cooldown ends in &e" + timeString + "&6.")));
            return;
        }
        if (args.length != 1) {
            throw new CommandException(Parser.Color("&4Incorrect argument count! Usage: " + this.func_71518_a(sender)), new Object[0]);
        }
        if (args[0].equalsIgnoreCase(sender.func_70005_c_())) {
            throw new CommandException(Parser.Color("&4You cannot teleport to yourself!"), new Object[0]);
        }
        EntityPlayerMP targetPlayer = server.func_184103_al().func_152612_a(args[0]);
        if (targetPlayer == null) {
            throw new CommandException(Parser.Color("&4Player &9" + args[0] + "&4 is not on the server!"), new Object[0]);
        }
        World targetted = targetPlayer.func_130014_f_();
        if (targetted != (targetter = sender.func_130014_f_())) {
            throw new CommandException(Parser.Color("&4Player &9" + args[0] + "&4 is not in the same dimension!"), new Object[0]);
        }
        Teleport remove = Teleports.getRequestTP(sender.func_70005_c_());
        if (remove != null) {
            Teleports.tps.remove(remove);
            Teleports.notifyCanceledTP(remove);
        }
        ToTeleport teleport = new ToTeleport(sender.func_70005_c_(), args[0]);
        Teleports.tps.put(teleport, 6000);
        targetPlayer.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&9" + sender.func_70005_c_() + "&6 has requested to teleport to you. Type &e/tpaccept &6to accept.")));
        sender.func_145747_a((ITextComponent)new TextComponentString(Parser.Color("&6Requested to teleport to &9" + args[0] + "&6.")));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        List<String> playerNames = Arrays.asList(server.func_184103_al().func_72369_d());
        if (args.length > 0) {
            String partialName = args[args.length - 1];
            return playerNames.stream().filter(name -> name.toLowerCase().startsWith(partialName.toLowerCase())).collect(Collectors.toList());
        }
        return playerNames;
    }

    public boolean func_82358_a(String[] args, int index) {
        return true;
    }

    private boolean isOnCooldown(String playerName) {
        if (lastExecutionTime.containsKey(playerName)) {
            long cooldownMillis;
            long lastExecution = lastExecutionTime.get(playerName);
            long currentTime = System.currentTimeMillis();
            return currentTime - lastExecution < (cooldownMillis = cooldownSeconds * 1000L);
        }
        return false;
    }

    private long getRemainingCooldown(String playerName) {
        if (lastExecutionTime.containsKey(playerName)) {
            long lastExecution = lastExecutionTime.get(playerName);
            long currentTime = System.currentTimeMillis();
            long cooldownMillis = cooldownSeconds * 1000L;
            long remainingCooldownMillis = cooldownMillis - (currentTime - lastExecution);
            return remainingCooldownMillis / 1000L;
        }
        return 0L;
    }
}

