/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.command;

import dev.yesBad.servermod.utils.BackManager;
import dev.yesBad.servermod.utils.HomeManager;
import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.tp.CooldownManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class Home
extends CommandBase {
    public String func_71517_b() {
        return "home";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/home <name>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public List<String> func_71514_a() {
        return Arrays.asList("home", "aroofoveroneshead");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        BlockPos pos;
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length < 1) {
            player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color(ModConfig.HomeUsage.replace("sethome", "home"))));
            return;
        }
        String name = args[0];
        String playerName = player.func_70005_c_();
        long cooldown = ModConfig.homeCooldown;
        boolean shared = ModConfig.cooldownShareGroup.contains("home");
        long seconds = 0L;
        if (!sender.func_70003_b(4, "home")) {
            boolean onCooldown;
            if (shared) {
                onCooldown = CooldownManager.isOnCooldown(playerName, cooldown, true);
                seconds = CooldownManager.getRemainingCooldown(playerName, cooldown, true);
            } else {
                long last;
                Map<String, Long> lastHomeUse = CooldownManager.lastHomeUse;
                long now = System.currentTimeMillis();
                boolean bl = onCooldown = now - (last = lastHomeUse.getOrDefault(playerName, 0L).longValue()) < cooldown * 1000L;
                if (onCooldown) {
                    seconds = cooldown - (now - last) / 1000L;
                }
            }
            if (onCooldown) {
                String timeString;
                if (seconds >= 7200L) {
                    double hours = (double)seconds / 3600.0;
                    timeString = String.format("%.1f", hours) + " hours";
                } else if (seconds >= 120L) {
                    double minutes = (double)seconds / 60.0;
                    timeString = String.format("%.1f", minutes) + " minutes";
                } else {
                    timeString = seconds + " seconds";
                }
                player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color(ModConfig.format(ModConfig.CooldownTime, "time", timeString))));
                return;
            }
        }
        if ((pos = HomeManager.getHome(player, name)) == null) {
            String msg = ModConfig.HomeNotFound.replace("{name}", name);
            player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color(msg)));
            return;
        }
        BackManager.saveLocation(player);
        player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        String msg = ModConfig.HomeTeleported.replace("{name}", name);
        player.func_145747_a((ITextComponent)new TextComponentString(Parser.Color(msg)));
        if (shared) {
            CooldownManager.setCooldown(playerName, true);
        } else {
            CooldownManager.lastHomeUse.put(playerName, System.currentTimeMillis());
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (sender instanceof EntityPlayerMP && args.length == 1) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            return HomeManager.getHomeNames(player).stream().filter(homeName -> homeName.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

