/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.utils;

import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.Parser;
import dev.yesBad.servermod.utils.PlayerRankData;
import dev.yesBad.servermod.utils.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Messages {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        EntityPlayer ep = event.getEntityPlayer();
        if (ep instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)ep;
            Boolean perms = PlayerRankData.getBoolean(player, "nick");
            if (perms == null || !perms.booleanValue()) {
                return;
            }
            String name = PlayerRankData.getString(player, "name");
            if (name == null || name.isEmpty()) {
                return;
            }
            String playerName = Parser.Color(name);
            event.setDisplayname(playerName);
        }
    }

    @SubscribeEvent
    public void onChatReceived(ServerChatEvent event) {
        String senderName = event.getUsername();
        EntityPlayerMP player = PlayerUtils.getPlayerFromName(senderName);
        assert (player != null);
        String messageContent = event.getMessage();
        Boolean perms = PlayerRankData.getBoolean(player, "nick");
        if (perms != null && perms.booleanValue()) {
            String name = PlayerRankData.getString(player, "name");
            if (name != null && !name.isEmpty()) {
                senderName = Parser.Color(name);
            }
            messageContent = Parser.Color(event.getMessage());
        }
        String formattedMessage = Parser.Color(ModConfig.format(ModConfig.messageTranscriber, "user", senderName));
        TextComponentString newMessage = new TextComponentString(ModConfig.format(formattedMessage, "msg", messageContent));
        event.setComponent((ITextComponent)newMessage);
    }
}

