/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod.utils.tp;

import java.util.HashMap;
import java.util.Map;

public class CooldownManager {
    public static final Map<String, Long> lastExecutionTime = new HashMap<String, Long>();
    public static final Map<String, Long> lastHomeUse = new HashMap<String, Long>();
    public static final Map<String, Long> lastTpaUse = new HashMap<String, Long>();
    public static final Map<String, Long> lastBackUse = new HashMap<String, Long>();

    public static boolean isOnCooldown(String playerName, long cooldownSeconds, boolean shared) {
        Map<String, Long> map;
        Map<String, Long> map2 = map = shared ? lastExecutionTime : null;
        if (!shared) {
            return false;
        }
        if (map.containsKey(playerName)) {
            long last = map.get(playerName);
            long now = System.currentTimeMillis();
            return now - last < cooldownSeconds * 1000L;
        }
        return false;
    }

    public static long getRemainingCooldown(String playerName, long cooldownSeconds, boolean shared) {
        Map<String, Long> map;
        Map<String, Long> map2 = map = shared ? lastExecutionTime : null;
        if (!shared) {
            return 0L;
        }
        if (map.containsKey(playerName)) {
            long last = map.get(playerName);
            long now = System.currentTimeMillis();
            long remaining = cooldownSeconds * 1000L - (now - last);
            return remaining > 0L ? remaining / 1000L : 0L;
        }
        return 0L;
    }

    public static void setCooldown(String playerName, boolean shared) {
        if (shared) {
            lastExecutionTime.put(playerName, System.currentTimeMillis());
        }
    }
}

