/*
 * Decompiled with CFR 0.152.
 */
package dev.yesBad.servermod;

import dev.yesBad.servermod.command.Endersee;
import dev.yesBad.servermod.command.Invsee;
import dev.yesBad.servermod.command.Leaderboard;
import dev.yesBad.servermod.command.Nick;
import dev.yesBad.servermod.command.Randomtp;
import dev.yesBad.servermod.command.Rank;
import dev.yesBad.servermod.command.Servermod;
import dev.yesBad.servermod.command.Tpa;
import dev.yesBad.servermod.command.Tpaccept;
import dev.yesBad.servermod.utils.Messages;
import dev.yesBad.servermod.utils.ModConfig;
import dev.yesBad.servermod.utils.PlayerUtils;
import dev.yesBad.servermod.utils.tp.Handler;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="servermod", name="yesBad's ServerMod", version="1.1", serverSideOnly=true, acceptableRemoteVersions="*")
public class servermod {
    public static final String MODID = "servermod";
    public static final String NAME = "yesBad's ServerMod";
    public static final String VERSION = "1.1";
    public static final Logger LOGGER = LogManager.getLogger((String)"servermod");

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent preinit) {
        ModConfig.init(new File(Launch.minecraftHome, "config" + File.separator + "servermod.cfg"));
        LOGGER.info("yesBad's ServerMod v1.1 has been loaded...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Messages());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Servermod());
        if (ModConfig.enableInvsee) {
            event.registerServerCommand((ICommand)new Invsee());
        }
        if (ModConfig.enableEndersee) {
            event.registerServerCommand((ICommand)new Endersee());
        }
        if (ModConfig.enableLeaderboard) {
            event.registerServerCommand((ICommand)new Leaderboard());
        }
        if (ModConfig.enableTPA) {
            event.registerServerCommand((ICommand)new Tpa());
        }
        if (ModConfig.enableTPA) {
            event.registerServerCommand((ICommand)new Tpaccept());
        }
        if (ModConfig.enableRTP) {
            event.registerServerCommand((ICommand)new Randomtp());
        }
        if (ModConfig.enableNicknameSystem) {
            event.registerServerCommand((ICommand)new Rank());
        }
        if (ModConfig.enableNicknameSystem) {
            event.registerServerCommand((ICommand)new Nick());
        }
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayerMP player = PlayerUtils.getPlayerFromName(event.player.func_70005_c_());
        if (player != null) {
            NBTTagCompound playerData = player.getEntityData();
            long last_seen = player.field_70170_p.func_82737_E();
            playerData.func_74772_a("last_seen", last_seen);
        } else {
            LOGGER.warn("Player left funnily, last_seen set failed.");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = PlayerUtils.getPlayerFromName(event.player.func_70005_c_());
        if (player != null) {
            NBTTagCompound playerData = player.getEntityData();
            long last_seen = player.field_70170_p.func_82737_E();
            playerData.func_74772_a("last_seen", last_seen);
        } else {
            LOGGER.warn("Player joined funnily, last_seen set failed.");
        }
    }
}

