/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.api.entity;

import com.mojang.authlib.GameProfile;
import com.xinyihl.ymadditions.api.IListObject;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class User
implements IListObject {
    private UUID uuid;
    private String name;
    private Perm perm;

    private User() {
    }

    public static User create(NBTTagCompound tag) {
        return new User().of(tag);
    }

    public static User create(UUID uuid, String name, Perm perm) {
        User user = new User();
        user.uuid = uuid;
        user.name = name;
        user.perm = perm;
        return user;
    }

    public static User create(UUID uuid, String name) {
        return User.create(uuid, name, Perm.NONE);
    }

    public static User create(GameProfile profile, Perm perm) {
        return User.create(profile.getId(), profile.getName(), perm);
    }

    public static User create(GameProfile profile) {
        return User.create(profile.getId(), profile.getName(), Perm.NONE);
    }

    public static User create(EntityPlayer player, Perm perm) {
        return User.create(player.getGameProfile(), perm);
    }

    public static User create(EntityPlayer player) {
        return User.create(player.getGameProfile(), Perm.NONE);
    }

    public static User empty() {
        return new User();
    }

    public boolean isOwner() {
        return this.perm == Perm.OWNER;
    }

    public boolean isAdmin() {
        return this.perm == Perm.ADMIN;
    }

    public boolean isMember() {
        return this.perm == Perm.USER;
    }

    public boolean isGuest() {
        return this.perm == Perm.NONE;
    }

    public void update(NBTTagCompound tag) {
        this.of(tag);
    }

    public User of(NBTTagCompound tag) {
        if (tag.hasUniqueId("uuid")) {
            this.uuid = tag.getUniqueId("uuid");
        }
        if (tag.hasKey("name")) {
            this.name = tag.getString("name");
        }
        if (tag.hasKey("perm")) {
            this.perm = Perm.valueOf(tag.getString("perm"));
        }
        return this;
    }

    public NBTTagCompound to(NBTTagCompound tag) {
        if (this.uuid != null) {
            tag.setUniqueId("uuid", this.uuid);
        }
        tag.setString("name", this.name);
        tag.setString("perm", this.perm.name());
        return tag;
    }

    public User deepCopy() {
        return User.create(this.to(new NBTTagCompound()));
    }

    @Override
    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Perm getPerm() {
        return this.perm;
    }

    public void setPerm(Perm perm) {
        this.perm = perm;
    }

    public boolean isUser(User user) {
        return this.equals(user);
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.uuid, user.uuid) && Objects.equals(this.name, user.name);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name);
    }

    public static enum Perm {
        NONE,
        USER,
        ADMIN,
        OWNER;

    }
}

