/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.client.component;

import com.xinyihl.ymadditions.api.IListItem;
import com.xinyihl.ymadditions.api.IListObject;
import com.xinyihl.ymadditions.common.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class ListCtrl<T extends IListObject>
extends Gui {
    public final int width;
    public final int height;
    public final int x;
    public final int y;
    public final Minecraft mc;
    private final int itemHeight;
    private final Collection<T> items;
    private final List<IListItem<T>> drawItems = new ArrayList<IListItem<T>>();
    private boolean scrollByItem = false;
    private boolean scroll = false;
    private boolean isSelected = false;
    private String filter = "";
    private Object selected;
    private int scrollOffset;
    private int listHeight;
    private int maxScrollOffset;
    private int scrollBarHeight;
    private int scrollBarY;
    private boolean isScrolling;
    private int scrollWidth = 3;
    private int lastItemsSize = -1;
    private int lastMouseY;

    public ListCtrl(Minecraft mc, int x, int y, int width, int height, int itemHeight, Collection<T> items) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.itemHeight = itemHeight == 0 ? 1 : itemHeight;
        this.items = items;
        this.mc = mc;
    }

    public void setScrollByItem(boolean scrollByItem) {
        this.scrollByItem = scrollByItem;
    }

    public void setScroll(boolean scroll) {
        this.scroll = scroll;
    }

    public void setScrollWidth(int width) {
        this.scrollWidth = width;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setSelected(Object selected) {
        this.selected = selected;
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    public void setFilter(String filter) {
        this.filter = Utils.escapeExprSpecialWord(filter);
    }

    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (this.lastItemsSize != this.items.size()) {
            this.lastItemsSize = this.items.size();
            this.refresh();
        }
        int scaleFactor = new ScaledResolution(this.mc).getScaleFactor();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.x * scaleFactor), (int)(this.mc.displayHeight - (this.y + this.height) * scaleFactor), (int)(this.width * scaleFactor), (int)(this.height * scaleFactor));
        for (IListItem<T> item : this.drawItems) {
            item.draw(this.mc, mouseX, mouseY, partialTicks);
        }
        GL11.glDisable((int)3089);
        this.listHeight = (int)this.items.stream().filter(n -> Pattern.compile(this.filter).matcher(n.getName()).find()).count() * this.itemHeight;
        this.maxScrollOffset = Math.max(this.listHeight - this.height, 0);
        if (this.scroll) {
            this.scrollBarHeight = this.height;
            if (this.maxScrollOffset > 0) {
                this.scrollBarHeight = (int)((float)this.height * (float)this.height / (float)this.listHeight);
                this.scrollBarHeight = Math.max(10, this.scrollBarHeight);
            }
            this.scrollBarY = this.y;
            if (this.maxScrollOffset > 0) {
                this.scrollBarY += (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(this.height - this.scrollBarHeight));
            }
            ListCtrl.drawRect((int)(this.x + this.width - this.scrollWidth - 1), (int)this.y, (int)(this.x + this.width - 1), (int)(this.y + this.height), (int)-6513508);
            ListCtrl.drawRect((int)(this.x + this.width - this.scrollWidth - 1), (int)this.scrollBarY, (int)(this.x + this.width - 1), (int)(this.scrollBarY + this.scrollBarHeight), (int)-13158601);
        }
        for (IListItem<T> item : this.drawItems) {
            List<String> tooltip;
            if (!item.isMouseOver(mouseX, mouseY) || (tooltip = item.getTooltip()) == null || tooltip.isEmpty()) continue;
            GuiUtils.drawHoveringText(tooltip.stream().map(x$0 -> I18n.format((String)x$0, (Object[])new Object[0])).collect(Collectors.toList()), (int)mouseX, (int)mouseY, (int)9999, (int)9999, (int)-1, (FontRenderer)this.mc.fontRenderer);
        }
    }

    public void refresh() {
        int index;
        this.drawItems.clear();
        int drawSize = this.height / this.itemHeight + 2;
        List filter = this.items.stream().filter(n -> Pattern.compile(this.filter).matcher(n.getName()).find()).collect(Collectors.toList());
        for (int i = 0; i < drawSize && (index = this.scrollOffset / this.itemHeight + i) < filter.size(); ++i) {
            IListItem<IListObject> item = this.getItem(((IListObject)filter.get(index)).getUuid(), ((IListObject)filter.get(index)).getName(), (IListObject)filter.get(index), this.x, this.y + i * this.itemHeight - this.scrollOffset % this.itemHeight, this.width - (this.scroll ? this.scrollWidth + 2 : 0), this.itemHeight);
            if (this.isSelected) {
                item.setSelected(Objects.equals(this.selected, item.getId()));
            }
            this.drawItems.add(item);
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) {
        int mouseWheel;
        if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height && (mouseWheel = Mouse.getEventDWheel()) != 0) {
            this.scrollOffset = MathHelper.clamp((int)(this.scrollOffset - (int)Math.signum(mouseWheel) * (this.scrollByItem ? this.itemHeight : 3)), (int)0, (int)this.maxScrollOffset);
            this.refresh();
        }
        if (this.isScrolling) {
            int deltaY = mouseY - this.lastMouseY;
            int scrollBarMaxY = this.height - this.scrollBarHeight;
            if (this.maxScrollOffset > 0 && scrollBarMaxY > 0) {
                float ratio = (float)this.maxScrollOffset / (float)scrollBarMaxY;
                this.scrollOffset += (int)((float)deltaY * ratio);
                this.scrollOffset = MathHelper.clamp((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
            }
            this.lastMouseY = mouseY;
            this.refresh();
        }
    }

    protected abstract IListItem<T> getItem(Object var1, String var2, T var3, int var4, int var5, int var6, int var7);

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.scroll && !this.isScrolling && this.isMouseOverScrollBar(mouseX, mouseY)) {
            this.lastMouseY = mouseY;
            this.isScrolling = true;
        }
        boolean r = false;
        for (IListItem<T> item : this.drawItems) {
            if (!item.isMouseOver(mouseX, mouseY)) continue;
            item.click();
            item.playPressSound(this.mc.getSoundHandler());
            if (!this.isSelected) continue;
            this.setSelected(item.getId());
            r = true;
        }
        if (r) {
            this.refresh();
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.scroll && this.isScrolling) {
            this.isScrolling = false;
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    private boolean isMouseOverScrollBar(int mouseX, int mouseY) {
        int scrollLeft = this.x + this.width - this.scrollWidth - 1;
        int scrollRight = this.x + this.width - 1;
        int scrollTop = this.scrollBarY;
        int scrollBottom = this.scrollBarY + this.scrollBarHeight;
        return mouseX >= scrollLeft && mouseX <= scrollRight && mouseY >= scrollTop && mouseY <= scrollBottom;
    }
}

