/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.client.gui;

import com.xinyihl.ymadditions.YMAdditions;
import com.xinyihl.ymadditions.api.IListItem;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.client.component.ListCtrl;
import com.xinyihl.ymadditions.client.control.IconButton;
import com.xinyihl.ymadditions.client.control.ListItem;
import com.xinyihl.ymadditions.client.control.MyButton;
import com.xinyihl.ymadditions.client.control.MyLockIconButton;
import com.xinyihl.ymadditions.client.control.MyTextField;
import com.xinyihl.ymadditions.client.gui.GuiNetworkHubUser;
import com.xinyihl.ymadditions.common.container.ContainerNetworkHub;
import com.xinyihl.ymadditions.common.network.PacketClientToServer;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLockIconButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiNetworkHubCore
extends GuiContainer {
    private static String searchNet = "";
    private final ContainerNetworkHub containerNetworkHub;
    private ListCtrl<Network> listCtrl;
    private GuiTextField searchField;
    private GuiLockIconButton lockButton;
    private GuiButton createButton;
    private GuiButton deleteButton;
    private GuiButton connectButton;
    private GuiButton disConnectButton;
    private GuiTextField createField;
    private boolean isCreating = false;
    private IconButton userScreen;

    public GuiNetworkHubCore(ContainerNetworkHub containerNetworkHub) {
        super((Container)containerNetworkHub);
        this.containerNetworkHub = containerNetworkHub;
        this.xSize = 200;
        this.ySize = 159;
    }

    public List<Rectangle> getExtraAreas() {
        ArrayList<Rectangle> extraAreas = new ArrayList<Rectangle>();
        extraAreas.add(new Rectangle(this.userScreen.x, this.userScreen.y, this.userScreen.width, this.userScreen.height));
        extraAreas.add(new Rectangle(this.lockButton.x, this.lockButton.y, this.lockButton.width, this.lockButton.height));
        return extraAreas;
    }

    public void initGui() {
        super.initGui();
        this.userScreen = new IconButton(99999, this.guiLeft + 201, this.guiTop + 5, 60, 146);
        this.listCtrl = new ListCtrl<Network>(this.mc, this.guiLeft + 7, this.guiTop + 35, 86, 116, 20, this.containerNetworkHub.networks.values()){

            @Override
            protected IListItem<Network> getItem(Object id, String text, Network o, int x, int y, int width, int height) {
                return new ListItem<Network>(id, text, o, x, y, width, height){

                    @Override
                    public void click() {
                        UUID uuid = ((Network)this.get()).getUuid();
                        if (uuid == null) {
                            return;
                        }
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.setInteger("button", 0);
                        tag.setUniqueId("networkUuid", uuid);
                        YMAdditions.instance.networkWrapper.sendToServer((IMessage)new PacketClientToServer(PacketClientToServer.ClientToServer.BUTTON_ACTION, tag));
                    }
                };
            }
        };
        this.listCtrl.setScroll(true);
        this.listCtrl.setIsSelected(true);
        this.listCtrl.setFilter(searchNet);
        this.listCtrl.setSelected(this.containerNetworkHub.selectedNetwork);
        this.listCtrl.setScrollByItem(true);
        this.listCtrl.refresh();
        this.searchField = new GuiTextField(1001, this.fontRenderer, this.guiLeft + 9, this.guiTop + 17, 85, 11);
        this.searchField.setVisible(true);
        this.searchField.setMaxStringLength(10);
        this.searchField.setEnableBackgroundDrawing(false);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setText(searchNet);
        this.searchField.setFocused(false);
        this.createButton = new MyButton(995, this.guiLeft + 105, this.guiTop + 113, 37, 14, I18n.format((String)"gui.ymadditions.network_hub.button.create", (Object[])new Object[0]));
        this.deleteButton = new MyButton(996, this.guiLeft + 105, this.guiTop + 133, 37, 14, I18n.format((String)"gui.ymadditions.network_hub.button.delete", (Object[])new Object[0]));
        this.connectButton = new MyButton(997, this.guiLeft + 151, this.guiTop + 113, 37, 14, I18n.format((String)"gui.ymadditions.network_hub.button.connect", (Object[])new Object[0]));
        this.disConnectButton = new MyButton(998, this.guiLeft + 151, this.guiTop + 133, 37, 14, I18n.format((String)"gui.ymadditions.network_hub.button.disconnect", (Object[])new Object[0]));
        this.lockButton = new MyLockIconButton(999, this.guiLeft + 201, this.guiTop + 25);
        this.createField = new MyTextField(this.mc, 1000, this.fontRenderer, this.guiLeft + 105, this.guiTop + 113, 82, 14);
        if (this.containerNetworkHub.networkHub.isConnected()) {
            this.createButton.enabled = false;
        }
        if (this.containerNetworkHub.networkHub.isHead()) {
            this.createButton.enabled = false;
            this.connectButton.enabled = false;
            this.disConnectButton.enabled = false;
        }
        this.lockButton.enabled = this.containerNetworkHub.selectedNetwork != null;
        this.lockButton.setLocked(!this.selected().isOvert());
        this.createField.setVisible(false);
        this.createField.setMaxStringLength(10);
        this.createField.setEnableBackgroundDrawing(false);
        this.buttonList.add(this.userScreen);
        this.buttonList.add(this.createButton);
        this.buttonList.add(this.deleteButton);
        this.buttonList.add(this.connectButton);
        this.buttonList.add(this.disConnectButton);
        this.buttonList.add(this.lockButton);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        boolean isSelected = this.containerNetworkHub.selectedNetwork != null;
        boolean isHead = this.containerNetworkHub.networkHub.isHead();
        boolean isConnected = this.containerNetworkHub.networkHub.isConnected();
        this.lockButton.setLocked(!this.selected().isOvert());
        this.lockButton.enabled = isSelected;
        this.createButton.enabled = !isHead && !isConnected;
        this.disConnectButton.enabled = isSelected && !isHead && isConnected;
        this.connectButton.enabled = isSelected && !isHead;
        this.deleteButton.enabled = isSelected;
        this.listCtrl.draw(mouseX, mouseY, partialTicks);
        this.createField.drawTextBox();
        this.searchField.drawTextBox();
        if (this.isMouseOverButton((GuiButton)this.lockButton, mouseX, mouseY)) {
            this.drawHoveringText(I18n.format((String)"gui.ymadditions.network_hub.button.public.desc", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(new ResourceLocation("ymadditions", "textures/gui/background.png"));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.mc.getTextureManager().bindTexture(new ResourceLocation("ymadditions", "textures/gui/network_hub.png"));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private Network selected() {
        return this.containerNetworkHub.getSelected();
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawCenteredString(this.mc.fontRenderer, I18n.format((String)"tile.ymadditions.network_hub.name", (Object[])new Object[0]), this.xSize / 2, 4, -1);
        int rightPanelX = 103;
        int rightPanelY = 19;
        String name = this.selected().getName();
        Integer surplusChannels = this.containerNetworkHub.surplusChannels;
        BlockPosDim posDim = this.selected().getSendPos();
        boolean overt = this.selected().isOvert();
        boolean connected = this.containerNetworkHub.networkHub.isConnected();
        long power = (long)this.containerNetworkHub.networkHub.getPower();
        this.fontRenderer.drawString(I18n.format((String)"gui.ymadditions.network_hub.info.network_name", (Object[])new Object[0]) + " " + name, rightPanelX, rightPanelY, 0xFFFFFF);
        this.fontRenderer.drawString(I18n.format((String)"gui.ymadditions.network_hub.info.surplus_channels", (Object[])new Object[0]) + " " + (surplusChannels == null ? "Unknown" : surplusChannels), rightPanelX, rightPanelY += 12, 0xFFFFFF);
        this.fontRenderer.drawString(I18n.format((String)"gui.ymadditions.network_hub.info.dimension_id", (Object[])new Object[0]) + " " + (posDim == null ? "Unknown" : Integer.valueOf(posDim.getDimension())), rightPanelX, rightPanelY += 12, 0xFFFFFF);
        this.fontRenderer.drawString(I18n.format((String)("gui.ymadditions.network_hub.info.public." + overt), (Object[])new Object[0]), rightPanelX, rightPanelY += 12, 0xFFFFFF);
        this.fontRenderer.drawString(I18n.format((String)("gui.ymadditions.network_hub.info.state." + connected), (Object[])new Object[0]), rightPanelX, rightPanelY += 12, 0xFFFFFF);
        this.fontRenderer.drawString(I18n.format((String)"gui.ymadditions.network_hub.info.power", (Object[])new Object[0]) + " " + power + " RF/t", rightPanelX, rightPanelY + 12, 0xFFFFFF);
    }

    protected void actionPerformed(@Nonnull GuiButton ba) {
        if (this.createButton.id == ba.id) {
            this.createButton.enabled = false;
            this.createButton.visible = false;
            this.connectButton.visible = false;
            this.isCreating = true;
            this.createField.setVisible(true);
            this.createField.setFocused(true);
            return;
        }
        if (this.userScreen.id == ba.id) {
            this.mc.displayGuiScreen((GuiScreen)new GuiNetworkHubUser(this.containerNetworkHub));
        }
        if (this.containerNetworkHub.selectedNetwork == null) {
            return;
        }
        if (ba.id >= 900 && ba.id <= 999) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setInteger("button", ba.id);
            YMAdditions.instance.networkWrapper.sendToServer((IMessage)new PacketClientToServer(PacketClientToServer.ClientToServer.BUTTON_ACTION, tag));
        }
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.isCreating) {
            this.createField.textboxKeyTyped(typedChar, keyCode);
            if (keyCode == 28 || keyCode == 156) {
                this.connectButton.enabled = false;
                this.disConnectButton.enabled = false;
                this.createButton.visible = true;
                this.connectButton.visible = true;
                this.isCreating = false;
                this.createField.setVisible(false);
                NBTTagCompound tag = new NBTTagCompound();
                tag.setInteger("button", 1);
                tag.setString("name", this.createField.getText());
                YMAdditions.instance.networkWrapper.sendToServer((IMessage)new PacketClientToServer(PacketClientToServer.ClientToServer.BUTTON_ACTION, tag));
                this.createField.setText("");
            }
            return;
        }
        if (this.searchField.isFocused()) {
            if (this.searchField.textboxKeyTyped(typedChar, keyCode)) {
                searchNet = this.searchField.getText();
                this.listCtrl.setFilter(searchNet);
                this.listCtrl.setScrollOffset(0);
                this.listCtrl.refresh();
            }
            return;
        }
        super.keyTyped(typedChar, keyCode);
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int j = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.listCtrl.handleMouseInput(i, j);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.listCtrl.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isCreating && !this.isMouseOverTextField(this.createField, mouseX, mouseY)) {
            this.createButton.enabled = true;
            this.createButton.visible = true;
            this.connectButton.visible = true;
            this.isCreating = false;
            this.createField.setVisible(false);
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.listCtrl.mouseClicked(mouseX, mouseY, mouseButton);
        this.searchField.setFocused(this.isMouseOverTextField(this.searchField, mouseX, mouseY));
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.listCtrl.mouseReleased(mouseX, mouseY, state);
    }

    private boolean isMouseOverTextField(GuiTextField textField, int mouseX, int mouseY) {
        return mouseX >= textField.x && mouseX < textField.x + textField.width && mouseY >= textField.y && mouseY < textField.y + textField.height;
    }

    private boolean isMouseOverButton(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.x && mouseY >= button.y && mouseX < button.x + button.width && mouseY < button.y + button.height;
    }
}

