/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.client.gui;

import com.xinyihl.ymadditions.YMAdditions;
import com.xinyihl.ymadditions.api.IListItem;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.client.component.ListCtrl;
import com.xinyihl.ymadditions.client.control.IconButton;
import com.xinyihl.ymadditions.client.control.ListItem;
import com.xinyihl.ymadditions.client.gui.GuiNetworkHubCore;
import com.xinyihl.ymadditions.common.container.ContainerNetworkHub;
import com.xinyihl.ymadditions.common.network.PacketClientToServer;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiNetworkHubUser
extends GuiContainer {
    private final ContainerNetworkHub containerNetworkHub;
    private ListCtrl<User> listCtrl;
    private IconButton netScreen;

    public GuiNetworkHubUser(ContainerNetworkHub containerNetworkHub) {
        super((Container)containerNetworkHub);
        this.containerNetworkHub = containerNetworkHub;
        this.xSize = 200;
        this.ySize = 159;
    }

    public List<Rectangle> getExtraAreas() {
        ArrayList<Rectangle> extraAreas = new ArrayList<Rectangle>();
        extraAreas.add(new Rectangle(this.netScreen.x, this.netScreen.y, this.netScreen.width, this.netScreen.height));
        return extraAreas;
    }

    public void initGui() {
        super.initGui();
        this.netScreen = new IconButton(99998, this.guiLeft + 201, this.guiTop + 5, 40, 146);
        this.buttonList.add(this.netScreen);
        List<User> users = this.containerNetworkHub.getGroup().getUsers();
        this.listCtrl = new ListCtrl<User>(this.mc, this.guiLeft + 20, this.guiTop + 15, 165, 136, 20, users){

            @Override
            protected IListItem<User> getItem(Object id, String text, User o, int x, int y, int width, int height) {
                return new ListItem<User>(id, text, o, x, y, width, height){

                    @Override
                    public void draw(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                        int i = 1;
                        if (((User)this.get()).getPerm() == User.Perm.OWNER) {
                            i = 5;
                        }
                        if (this.isMouseOver(mouseX, mouseY)) {
                            i = 2;
                        }
                        mc.getTextureManager().bindTexture(new ResourceLocation("ymadditions", "textures/gui/widgets.png"));
                        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.drawTexturedModalRect(this.x, this.y + 3, 0, i * 14, this.width / 2, 14);
                        this.drawTexturedModalRect(this.x + this.width / 2, this.y + 3, 200 - this.width / 2, i * 14, this.width / 2, 14);
                        this.drawCenteredString(mc.fontRenderer, this.text + "[" + I18n.format((String)this.getPermText(), (Object[])new Object[0]) + "]", this.x + this.width / 2, this.y + (this.height - 8) / 2, -1);
                    }

                    @Override
                    public List<String> getTooltip() {
                        ArrayList<String> tooltip = new ArrayList<String>();
                        tooltip.add(this.getPermText());
                        return tooltip;
                    }

                    public String getPermText() {
                        if (((User)this.get()).isGuest()) {
                            return "gui.ymadditions.network_hub.user.none";
                        }
                        if (((User)this.get()).isMember()) {
                            return "gui.ymadditions.network_hub.user.user";
                        }
                        if (((User)this.get()).isAdmin()) {
                            return "gui.ymadditions.network_hub.user.admin";
                        }
                        if (((User)this.get()).isOwner()) {
                            return "gui.ymadditions.network_hub.user.owner";
                        }
                        return "";
                    }

                    @Override
                    public void click() {
                        UUID uuid = ((User)this.get()).getUuid();
                        String name = ((User)this.get()).getName();
                        if (uuid == null || name == null) {
                            return;
                        }
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.setInteger("button", 2);
                        tag.setUniqueId("user", uuid);
                        tag.setString("name", name);
                        if (Keyboard.getEventKeyState() && Keyboard.getEventKey() == 42) {
                            tag.setBoolean("isShifting", true);
                        }
                        YMAdditions.instance.networkWrapper.sendToServer((IMessage)new PacketClientToServer(PacketClientToServer.ClientToServer.BUTTON_ACTION, tag));
                    }
                };
            }
        };
        this.listCtrl.setScroll(true);
        this.listCtrl.setScrollByItem(true);
        this.listCtrl.refresh();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        if (this.containerNetworkHub.selectedNetwork != null) {
            this.listCtrl.draw(mouseX, mouseY, partialTicks);
        } else {
            this.drawCenteredString(this.mc.fontRenderer, I18n.format((String)"gui.ymadditions.network_hub.user.no_selected", (Object[])new Object[0]), this.guiLeft + this.xSize / 2, 100, -1);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(new ResourceLocation("ymadditions", "textures/gui/background.png"));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawCenteredString(this.mc.fontRenderer, I18n.format((String)"tile.ymadditions.network_hub.name", (Object[])new Object[0]), this.xSize / 2, 4, -1);
    }

    protected void actionPerformed(@Nonnull GuiButton ba) {
        if (this.netScreen.id == ba.id) {
            this.mc.displayGuiScreen((GuiScreen)new GuiNetworkHubCore(this.containerNetworkHub));
        }
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int j = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.listCtrl.handleMouseInput(i, j);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.listCtrl.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.listCtrl.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.listCtrl.mouseReleased(mouseX, mouseY, state);
    }
}

