/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.block;

import appeng.util.Platform;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.data.DataStorage;
import com.xinyihl.ymadditions.common.registry.Registry;
import com.xinyihl.ymadditions.common.title.TileNetworkHub;
import com.xinyihl.ymadditions.common.utils.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockNetworkHub
extends Block {
    public static final PropertyBool CONNECT = PropertyBool.create((String)"connect");

    public BlockNetworkHub() {
        super(Material.ROCK);
        this.setCreativeTab(Registry.CREATIVE_TAB);
        this.setRegistryName(new ResourceLocation("ymadditions", "network_hub"));
        this.setTranslationKey("ymadditions.network_hub");
        this.setHardness(3.0f);
        this.setResistance(5.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)CONNECT, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)CONNECT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)CONNECT) != false ? 1 : 0;
    }

    @Nonnull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECT});
    }

    @Nonnull
    public IBlockState getActualState(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity tile;
        boolean connect = false;
        TileEntity tileEntity = tile = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.getTileEntity(pos);
        if (tile instanceof TileNetworkHub) {
            TileNetworkHub tn = (TileNetworkHub)tile;
            connect = tn.isConnected();
        }
        return super.getActualState(state, worldIn, pos).withProperty((IProperty)CONNECT, (Comparable)Boolean.valueOf(connect));
    }

    public boolean onBlockActivated(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.isRemote) {
            IBlockState blockState;
            Block block;
            ItemStack heldItem;
            if (!playerIn.getHeldItem(hand).isEmpty() && Platform.isWrench((EntityPlayer)playerIn, (ItemStack)(heldItem = playerIn.getHeldItem(hand)), (BlockPos)pos) && playerIn.isSneaking() && (block = (blockState = worldIn.getBlockState(pos)).getBlock()).removedByPlayer(blockState, worldIn, pos, playerIn, false)) {
                worldIn.spawnEntity((Entity)new EntityItem(worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack(block)));
                worldIn.setBlockToAir(pos);
                return true;
            }
            TileEntity te = worldIn.getTileEntity(pos);
            if (te instanceof TileNetworkHub) {
                Network network = DataStorage.get(worldIn).getNetwork(((TileNetworkHub)te).getNetworkUuid());
                if (network == null || network.hasPermission(playerIn, User.Perm.USER)) {
                    Utils.openGui(playerIn, 1, worldIn, pos.getX(), pos.getY(), pos.getZ());
                } else {
                    playerIn.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                }
            }
        }
        return true;
    }

    public void onBlockPlacedBy(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity te;
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof TileNetworkHub && placer instanceof EntityPlayer) {
            TileNetworkHub tn = (TileNetworkHub)te;
            tn.setOwner((EntityPlayer)placer);
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState iBlockState) {
        return new TileNetworkHub();
    }

    public void breakBlock(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof TileNetworkHub) {
            TileNetworkHub tn = (TileNetworkHub)te;
            tn.breakConnection();
        }
        super.breakBlock(world, pos, state);
    }
}

