/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.container;

import com.xinyihl.ymadditions.YMAdditions;
import com.xinyihl.ymadditions.api.IContaierTickable;
import com.xinyihl.ymadditions.api.IInputHandler;
import com.xinyihl.ymadditions.api.ISyncable;
import com.xinyihl.ymadditions.api.entity.Group;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.data.DataStorage;
import com.xinyihl.ymadditions.common.network.PacketServerToClient;
import com.xinyihl.ymadditions.common.title.TileNetworkHub;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerNetworkHub
extends Container
implements IInputHandler,
IContaierTickable,
ISyncable {
    public EntityPlayer player;
    public TileNetworkHub networkHub;
    public UUID selectedNetwork;
    public DataStorage storage;
    public Integer surplusChannels;
    public Map<UUID, Network> networks = new LinkedHashMap<UUID, Network>();
    public Map<UUID, Group> groups = new LinkedHashMap<UUID, Group>();

    public ContainerNetworkHub(EntityPlayer player, TileNetworkHub networkHub) {
        this.player = player;
        this.networkHub = networkHub;
        if (player.world.isRemote) {
            return;
        }
        this.storage = DataStorage.get(networkHub.getWorld());
        this.networks = this.storage.getNetworks();
        this.groups = this.storage.getGroups();
        this.selectedNetwork = networkHub.getNetworkUuid();
    }

    public Network getSelected() {
        return this.networks.getOrDefault(this.selectedNetwork, Network.empty());
    }

    public Group getGroup() {
        return this.groups.getOrDefault(this.getSelected().getOwner(), Group.empty());
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return playerIn.getDistanceSq(this.networkHub.getPos()) <= 64.0;
    }

    @Override
    public void update() {
        if (this.player.world.isRemote) {
            return;
        }
        if (!(this.player.world.getTileEntity(this.networkHub.getPos()) instanceof TileNetworkHub)) {
            this.player.closeScreen();
            return;
        }
        if (!this.getSelected().hasPermission(this.player, User.Perm.USER)) {
            this.player.closeScreen();
        }
        this.sync();
    }

    @Override
    public void onGuiAtion(NBTTagCompound compound) {
        if (this.player.world.isRemote) {
            return;
        }
        int button = compound.getInteger("button");
        switch (button) {
            case 0: {
                UUID uuid = compound.getUniqueId("networkUuid");
                Network network = this.storage.getNetwork(uuid);
                if (network != null && network.hasPermission(this.player, User.Perm.USER)) {
                    this.selectedNetwork = uuid;
                }
                this.sync();
                break;
            }
            case 1: {
                String name = compound.getString("name");
                Network network = this.storage.createNetwork(this.player, name, false, new BlockPosDim(this.networkHub.getPos(), this.networkHub.getWorld().provider.getDimension()));
                this.networkHub.setHead(true);
                this.networkHub.setNetworkUuid(network.getUuid());
                this.selectedNetwork = network.getUuid();
                this.storage.markDirty();
                this.networkHub.sync();
                this.sync();
                break;
            }
            case 2: {
                UUID uuid = compound.getUniqueId("user");
                String name = compound.getString("name");
                Group group = this.getGroup();
                if (group != null && group.hasPermission(this.player, User.Perm.ADMIN)) {
                    User user = group.getUser(User.create(uuid, name));
                    if (user != null) {
                        if (user.getPerm() == User.Perm.ADMIN && group.hasPermission(this.player, User.Perm.OWNER)) {
                            group.removeUser(user);
                        }
                        if (user.getPerm() == User.Perm.USER) {
                            if (group.hasPermission(this.player, User.Perm.OWNER)) {
                                user.setPerm(User.Perm.ADMIN);
                            } else {
                                group.removeUser(user);
                            }
                        }
                        if (user.getPerm() == User.Perm.NONE) {
                            user.setPerm(User.Perm.USER);
                        }
                    } else {
                        group.addUser(User.create(uuid, name, User.Perm.USER));
                    }
                    this.storage.markDirty();
                    this.networkHub.sync();
                    this.sync();
                    break;
                }
                this.player.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                break;
            }
            case 996: {
                Network network = this.storage.getNetwork(this.selectedNetwork);
                if (network != null && network.hasPermission(this.player, User.Perm.ADMIN)) {
                    this.storage.removeNetwork(this.selectedNetwork);
                    this.selectedNetwork = Objects.equals(this.selectedNetwork, this.networkHub.getNetworkUuid()) ? null : this.networkHub.getNetworkUuid();
                    this.storage.markDirty();
                    this.networkHub.sync();
                    this.sync();
                    break;
                }
                this.player.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                break;
            }
            case 997: {
                Network network = this.storage.getNetwork(this.selectedNetwork);
                if (network != null && network.hasPermission(this.player, User.Perm.USER)) {
                    if (!Objects.equals(this.selectedNetwork, this.networkHub.getNetworkUuid())) {
                        this.networkHub.breakConnection();
                    }
                    this.storage.markDirty();
                    this.networkHub.setNetworkUuid(this.selectedNetwork);
                    this.networkHub.sync();
                    this.sync();
                    break;
                }
                this.player.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                break;
            }
            case 998: {
                Network network = this.storage.getNetwork(this.networkHub.getNetworkUuid());
                if (network != null && network.hasPermission(this.player, User.Perm.USER)) {
                    this.networkHub.breakConnection();
                    this.selectedNetwork = null;
                    this.storage.markDirty();
                    this.networkHub.sync();
                    this.sync();
                    break;
                }
                this.player.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                break;
            }
            case 999: {
                Network network = this.storage.getNetwork(this.selectedNetwork);
                if (network != null && network.hasPermission(this.player, User.Perm.ADMIN)) {
                    network.setOvert(!network.isOvert());
                    this.storage.markDirty();
                    this.networkHub.sync();
                    this.sync();
                    break;
                }
                this.player.sendStatusMessage((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                break;
            }
        }
    }

    @Override
    public void sync() {
        TileEntity tile;
        WorldServer thatWorld;
        BlockPosDim pos;
        if (this.networkHub.isHead()) {
            this.surplusChannels = this.networkHub.getSurplusChannels();
        } else if (this.selectedNetwork != null && (pos = this.getSelected().getSendPos()) != null && (thatWorld = DimensionManager.getWorld((int)pos.getDimension())) != null && thatWorld.isBlockLoaded(pos.toBlockPos()) && (tile = thatWorld.getTileEntity(pos.toBlockPos())) instanceof TileNetworkHub) {
            TileNetworkHub that = (TileNetworkHub)tile;
            this.surplusChannels = that.getSurplusChannels();
        }
        YMAdditions.instance.networkWrapper.sendTo((IMessage)new PacketServerToClient(PacketServerToClient.ServerToClient.CONTAINER_SYNC, this.getSyncData(new NBTTagCompound())), (EntityPlayerMP)this.player);
    }

    @Override
    public NBTTagCompound getSyncData(NBTTagCompound tag) {
        if (this.selectedNetwork != null) {
            tag.setUniqueId("networkUuid", this.selectedNetwork);
        }
        if (this.surplusChannels != null) {
            tag.setInteger("surplusChannels", this.surplusChannels.intValue());
        }
        NBTTagList list1 = new NBTTagList();
        NBTTagList list2 = new NBTTagList();
        for (Network network : this.networks.values().stream().filter(v -> v.hasPermission(this.player, User.Perm.USER)).collect(Collectors.toList())) {
            list1.appendTag((NBTBase)network.to(new NBTTagCompound()));
        }
        for (Group group : this.groups.values().stream().filter(u -> u.hasPermission(this.player, User.Perm.USER)).collect(Collectors.toList())) {
            list2.appendTag((NBTBase)group.deepCopy().injectOnlinePlayers().injectOwnerToUsers().to(new NBTTagCompound()));
        }
        tag.setTag("networks", (NBTBase)list1);
        tag.setTag("groups", (NBTBase)list2);
        return tag;
    }

    @Override
    public void doSyncFrom(NBTTagCompound tag) {
        this.selectedNetwork = tag.hasUniqueId("networkUuid") ? tag.getUniqueId("networkUuid") : null;
        this.surplusChannels = tag.hasKey("surplusChannels") ? Integer.valueOf(tag.getInteger("surplusChannels")) : null;
        this.updateNetworks(tag);
        this.updateGroups(tag);
    }

    private void updateNetworks(NBTTagCompound tag) {
        NBTTagList list = tag.getTagList("networks", 10);
        HashSet<UUID> uuidsToKeep = new HashSet<UUID>();
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound nbt = list.getCompoundTagAt(i);
            UUID uuid2 = nbt.getUniqueId("uuid");
            uuidsToKeep.add(uuid2);
            Network net = this.networks.get(uuid2);
            if (net != null) {
                net.update(nbt);
                continue;
            }
            Network newNet = Network.create(nbt);
            this.networks.put(newNet.getUuid(), newNet);
        }
        this.networks.keySet().removeIf(uuid -> !uuidsToKeep.contains(uuid));
    }

    private void updateGroups(NBTTagCompound tag) {
        NBTTagList list = tag.getTagList("groups", 10);
        HashSet<UUID> uuidsToKeep = new HashSet<UUID>();
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound nbt = list.getCompoundTagAt(i);
            UUID uuid2 = nbt.getUniqueId("uuid");
            uuidsToKeep.add(uuid2);
            Group group = this.groups.get(uuid2);
            if (group != null) {
                group.update(nbt);
                continue;
            }
            Group newGroup = Group.create(nbt);
            this.groups.put(newGroup.getUuid(), newGroup);
        }
        this.groups.keySet().removeIf(uuid -> !uuidsToKeep.contains(uuid));
    }
}

