/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.data;

import com.xinyihl.ymadditions.api.entity.Group;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class DataStorage
extends WorldSavedData {
    private final Map<UUID, Network> networks = new LinkedHashMap<UUID, Network>();
    private final Map<UUID, Group> groups = new LinkedHashMap<UUID, Group>();

    public DataStorage(String name) {
        super(name);
    }

    public static DataStorage get(World world) {
        DataStorage data = null;
        if (world.getMapStorage() != null) {
            data = (DataStorage)world.getMapStorage().getOrLoadData(DataStorage.class, "ymadditions_data");
        }
        if (data == null) {
            data = new DataStorage("ymadditions_data");
            if (world.getMapStorage() != null) {
                world.getMapStorage().setData("ymadditions_data", (WorldSavedData)data);
            }
        }
        return data;
    }

    @Nullable
    public Network getNetwork(UUID network) {
        return this.networks.get(network);
    }

    public Map<UUID, Network> getNetworks() {
        return this.networks;
    }

    public Map<UUID, Group> getGroups() {
        return this.groups;
    }

    public void removeNetwork(UUID network) {
        this.networks.remove(network);
        this.markDirty();
    }

    @Nullable
    public Group getGroup(UUID group) {
        return this.groups.get(group);
    }

    @Nullable
    public Group getGroupByOwner(User owner) {
        return this.groups.values().stream().filter(v -> v.isOwner(owner)).findFirst().orElse(null);
    }

    private Group getOrCreateGroup(User owner) {
        Group group = this.getGroupByOwner(owner);
        if (group == null) {
            group = Group.create(owner);
            this.groups.put(group.getUuid(), group);
        }
        this.markDirty();
        return group;
    }

    public Network createNetwork(EntityPlayer player, String name, boolean overt, BlockPosDim sendPos) {
        User owner = User.create(player, User.Perm.OWNER);
        Group group = this.getOrCreateGroup(owner);
        Network network = Network.create(group.getUuid(), name, overt, sendPos);
        this.networks.put(network.getUuid(), network);
        this.markDirty();
        return network;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.networks.clear();
        NBTTagList list1 = nbt.getTagList("networks", 10);
        for (int i = 0; i < list1.tagCount(); ++i) {
            Network net = Network.create(list1.getCompoundTagAt(i));
            this.networks.put(net.getUuid(), net);
        }
        this.groups.clear();
        NBTTagList list2 = nbt.getTagList("groups", 10);
        for (int i = 0; i < list2.tagCount(); ++i) {
            Group group = Group.create(list2.getCompoundTagAt(i));
            this.groups.put(group.getUuid(), group);
        }
    }

    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tag) {
        NBTTagList list1 = new NBTTagList();
        NBTTagList list2 = new NBTTagList();
        for (Network network : this.networks.values()) {
            list1.appendTag((NBTBase)network.to(new NBTTagCompound()));
        }
        for (Group group : this.groups.values()) {
            list2.appendTag((NBTBase)group.to(new NBTTagCompound()));
        }
        tag.setTag("networks", (NBTBase)list1);
        tag.setTag("groups", (NBTBase)list2);
        return tag;
    }
}

