/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.title.base;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import com.xinyihl.ymadditions.api.IHasProbeInfo;
import com.xinyihl.ymadditions.api.IReadyable;
import com.xinyihl.ymadditions.common.event.EventHandler;
import com.xinyihl.ymadditions.common.title.base.TileEntityBase;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileMeBase
extends TileEntityBase
implements IActionHost,
IGridProxyable,
IHasProbeInfo,
IReadyable {
    protected final AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "aeProxy", this.getVisualItemStack(), true);

    public abstract ItemStack getVisualItemStack();

    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.proxy.readFromNBT(tag);
    }

    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.proxy.writeToNBT(tag);
        return tag;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation aePartLocation) {
        return this.proxy.getNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.getWorld().destroyBlock(this.getPos(), true);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.proxy.onChunkUnload();
    }

    public void invalidate() {
        super.invalidate();
        this.proxy.invalidate();
    }

    public void validate() {
        super.validate();
        this.proxy.validate();
        EventHandler.enqueue(this);
    }

    @Override
    public void onReady() {
        if (!this.isInvalid()) {
            this.proxy.onReady();
            Platform.notifyBlocksOfNeighbors((World)this.world, (BlockPos)this.pos);
        }
    }

    public void setOwner(EntityPlayer placer) {
        this.proxy.setOwner(placer);
    }

    @Override
    public void addProbeInfo(Consumer<String> consumer, Function<String, String> loc) {
        if (this.proxy.isPowered()) {
            if (this.proxy.isActive()) {
                consumer.accept(loc.apply("tile_me_base.online"));
            } else {
                consumer.accept(loc.apply("tile_me_base.missing_channel"));
            }
        } else {
            consumer.accept(loc.apply("tile_me_base.offline"));
        }
    }
}

