/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.utils;

import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockPosDim
extends BlockPos {
    private final int dimension;

    public BlockPosDim(int x, int y, int z, int dimension) {
        super(x, y, z);
        this.dimension = dimension;
    }

    public BlockPosDim(BlockPos blockPos, int dimension) {
        super((Vec3i)blockPos);
        this.dimension = dimension;
    }

    public static BlockPosDim readFromNBT(NBTTagCompound tag) {
        return new BlockPosDim(BlockPos.fromLong((long)tag.getLong("bPos")), tag.getInteger("dim"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setLong("bPos", this.toLong());
        tag.setInteger("dim", this.dimension);
        return tag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockPosDim)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockPosDim that = (BlockPosDim)((Object)o);
        return this.dimension == that.dimension;
    }

    public BlockPos toBlockPos() {
        return new BlockPos((Vec3i)this);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }
}

