/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.api.entity;

import com.xinyihl.ymadditions.Configurations;
import com.xinyihl.ymadditions.api.IListObject;
import com.xinyihl.ymadditions.api.entity.Group;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.data.DataStorage;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Network
implements IListObject {
    private final Set<BlockPosDim> receivePos = new HashSet<BlockPosDim>();
    private UUID uuid = null;
    private UUID owner = null;
    private String name = "Unknown";
    private boolean overt = false;
    private BlockPosDim sendPos = null;

    private Network() {
    }

    public static Network create(NBTTagCompound tag) {
        return new Network().of(tag);
    }

    public static Network create(UUID owner, String name, boolean overt, BlockPosDim sendPos) {
        Network network = new Network();
        network.uuid = UUID.randomUUID();
        network.owner = owner;
        network.name = name;
        network.overt = overt;
        network.sendPos = sendPos;
        return network;
    }

    public static Network empty() {
        return new Network();
    }

    private boolean checkDimension(int dimension) {
        return Configurations.GENERAL_CONFIG.canRDimension || dimension == this.sendPos.getDimension();
    }

    public boolean hasPermission(@Nonnull EntityPlayer player, User.Perm perm) {
        if (this.uuid == null) {
            return true;
        }
        if (!this.checkDimension(player.field_70170_p.field_73011_w.getDimension())) {
            return false;
        }
        DataStorage storage = DataStorage.get(player.field_70170_p);
        Group group = storage.getGroup(this.owner);
        if (group == null) {
            return false;
        }
        if (this.overt && perm == User.Perm.USER) {
            return true;
        }
        return group.hasPermission(player, perm);
    }

    public void update(NBTTagCompound tag) {
        this.of(tag);
    }

    public Network of(NBTTagCompound tag) {
        if (tag.func_186855_b("uuid")) {
            this.uuid = tag.func_186857_a("uuid");
        }
        if (tag.func_186855_b("owner")) {
            this.owner = tag.func_186857_a("owner");
        }
        if (tag.func_74764_b("name")) {
            this.name = tag.func_74779_i("name");
        }
        if (tag.func_74764_b("overt")) {
            this.overt = tag.func_74767_n("overt");
        }
        if (tag.func_74764_b("sendPos")) {
            this.sendPos = BlockPosDim.readFromNBT(tag.func_74775_l("sendPos"));
        }
        return this;
    }

    public NBTTagCompound to(NBTTagCompound tag) {
        if (this.uuid != null) {
            tag.func_186854_a("uuid", this.uuid);
        }
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
        tag.func_74778_a("name", this.name);
        tag.func_74757_a("overt", this.overt);
        if (this.sendPos != null) {
            tag.func_74782_a("sendPos", (NBTBase)this.sendPos.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public Network deepCopy() {
        return Network.create(this.to(new NBTTagCompound()));
    }

    @Override
    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isOvert() {
        return this.overt;
    }

    public void setOvert(boolean overt) {
        this.overt = overt;
    }

    @Nullable
    public BlockPosDim getSendPos() {
        return this.sendPos;
    }

    @Nonnull
    public Set<BlockPosDim> getReceivePos() {
        return this.receivePos;
    }

    public void addReceivePos(BlockPosDim receivePos) {
        this.receivePos.add(receivePos);
    }

    public void removeReceivePos(BlockPosDim receivePos) {
        this.receivePos.remove((Object)receivePos);
    }
}

