/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.block;

import appeng.util.Platform;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.data.DataStorage;
import com.xinyihl.ymadditions.common.registry.Registry;
import com.xinyihl.ymadditions.common.title.TileNetworkHub;
import com.xinyihl.ymadditions.common.utils.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockNetworkHub
extends Block {
    public static final PropertyBool CONNECT = PropertyBool.func_177716_a((String)"connect");

    public BlockNetworkHub() {
        super(Material.field_151576_e);
        this.func_149647_a(Registry.CREATIVE_TAB);
        this.setRegistryName(new ResourceLocation("ymadditions", "network_hub"));
        this.func_149663_c("ymadditions.network_hub");
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CONNECT, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONNECT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CONNECT) != false ? 1 : 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECT});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity tile;
        boolean connect = false;
        TileEntity tileEntity = tile = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (tile instanceof TileNetworkHub) {
            TileNetworkHub tn = (TileNetworkHub)tile;
            connect = tn.isConnected();
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CONNECT, (Comparable)Boolean.valueOf(connect));
    }

    public boolean func_180639_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            IBlockState blockState;
            Block block;
            ItemStack heldItem;
            if (!playerIn.func_184586_b(hand).func_190926_b() && Platform.isWrench((EntityPlayer)playerIn, (ItemStack)(heldItem = playerIn.func_184586_b(hand)), (BlockPos)pos) && playerIn.func_70093_af() && (block = (blockState = worldIn.func_180495_p(pos)).func_177230_c()).removedByPlayer(blockState, worldIn, pos, playerIn, false)) {
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(block)));
                worldIn.func_175698_g(pos);
                return true;
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileNetworkHub) {
                Network network = DataStorage.get(worldIn).getNetwork(((TileNetworkHub)te).getNetworkUuid());
                if (network == null || network.hasPermission(playerIn, User.Perm.USER)) {
                    Utils.openGui(playerIn, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("statusmessage.ymadditions.info.nopermission", new Object[0]), true);
                }
            }
        }
        return true;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileNetworkHub && placer instanceof EntityPlayer) {
            TileNetworkHub tn = (TileNetworkHub)te;
            tn.setOwner((EntityPlayer)placer);
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState iBlockState) {
        return new TileNetworkHub();
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileNetworkHub) {
            TileNetworkHub tn = (TileNetworkHub)te;
            tn.breakConnection();
        }
        super.func_180663_b(world, pos, state);
    }
}

