/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.data;

import com.xinyihl.ymadditions.api.entity.Group;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.api.entity.User;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class DataStorage
extends WorldSavedData {
    private final Map<UUID, Network> networks = new LinkedHashMap<UUID, Network>();
    private final Map<UUID, Group> groups = new LinkedHashMap<UUID, Group>();

    public DataStorage(String name) {
        super(name);
    }

    public static DataStorage get(World world) {
        DataStorage data = null;
        if (world.func_175693_T() != null) {
            data = (DataStorage)world.func_175693_T().func_75742_a(DataStorage.class, "ymadditions_data");
        }
        if (data == null) {
            data = new DataStorage("ymadditions_data");
            if (world.func_175693_T() != null) {
                world.func_175693_T().func_75745_a("ymadditions_data", (WorldSavedData)data);
            }
        }
        return data;
    }

    @Nullable
    public Network getNetwork(UUID network) {
        return this.networks.get(network);
    }

    public Map<UUID, Network> getNetworks() {
        return this.networks;
    }

    public Map<UUID, Group> getGroups() {
        return this.groups;
    }

    public void removeNetwork(UUID network) {
        this.networks.remove(network);
        this.func_76185_a();
    }

    @Nullable
    public Group getGroup(UUID group) {
        return this.groups.get(group);
    }

    @Nullable
    public Group getGroupByOwner(User owner) {
        return this.groups.values().stream().filter(v -> v.isOwner(owner)).findFirst().orElse(null);
    }

    private Group getOrCreateGroup(User owner) {
        Group group = this.getGroupByOwner(owner);
        if (group == null) {
            group = Group.create(owner);
            this.groups.put(group.getUuid(), group);
        }
        this.func_76185_a();
        return group;
    }

    public Network createNetwork(EntityPlayer player, String name, boolean overt, BlockPosDim sendPos) {
        User owner = User.create(player, User.Perm.OWNER);
        Group group = this.getOrCreateGroup(owner);
        Network network = Network.create(group.getUuid(), name, overt, sendPos);
        this.networks.put(network.getUuid(), network);
        this.func_76185_a();
        return network;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.networks.clear();
        NBTTagList list1 = nbt.func_150295_c("networks", 10);
        for (int i = 0; i < list1.func_74745_c(); ++i) {
            Network net = Network.create(list1.func_150305_b(i));
            this.networks.put(net.getUuid(), net);
        }
        this.groups.clear();
        NBTTagList list2 = nbt.func_150295_c("groups", 10);
        for (int i = 0; i < list2.func_74745_c(); ++i) {
            Group group = Group.create(list2.func_150305_b(i));
            this.groups.put(group.getUuid(), group);
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound tag) {
        NBTTagList list1 = new NBTTagList();
        NBTTagList list2 = new NBTTagList();
        for (Network network : this.networks.values()) {
            list1.func_74742_a((NBTBase)network.to(new NBTTagCompound()));
        }
        for (Group group : this.groups.values()) {
            list2.func_74742_a((NBTBase)group.to(new NBTTagCompound()));
        }
        tag.func_74782_a("networks", (NBTBase)list1);
        tag.func_74782_a("groups", (NBTBase)list2);
        return tag;
    }
}

