/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.event;

import appeng.util.Platform;
import com.xinyihl.ymadditions.api.IContaierTickable;
import com.xinyihl.ymadditions.api.IReadyable;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="ymadditions")
public class EventHandler {
    private static final Deque<IReadyable> readyQueue = new ArrayDeque<IReadyable>();

    public static void enqueue(IReadyable tile) {
        if (Platform.isServer()) {
            readyQueue.offer(tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (!readyQueue.isEmpty()) {
                readyQueue.pop().onReady();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Container container;
        if (event.side.isClient()) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        if (event.player.field_70170_p.func_82737_E() % 20L == 0L && (container = event.player.field_71070_bA) instanceof IContaierTickable) {
            ((IContaierTickable)container).update();
        }
    }
}

