/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.ymadditions.common.title;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.AEConfig;
import com.xinyihl.ymadditions.Configurations;
import com.xinyihl.ymadditions.api.entity.Network;
import com.xinyihl.ymadditions.common.data.DataStorage;
import com.xinyihl.ymadditions.common.integration.crt.NetHubPowerUsage;
import com.xinyihl.ymadditions.common.registry.Registry;
import com.xinyihl.ymadditions.common.title.base.TileMeBase;
import com.xinyihl.ymadditions.common.utils.BlockPosDim;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TileNetworkHub
extends TileMeBase
implements ITickable {
    private boolean isHead = false;
    private UUID networkUuid = null;
    private boolean isConnected = false;
    private double power;
    private IGridConnection connection;
    private int tickCounter;
    private Integer surplusChannels;
    private long lastWorldTime;

    public TileNetworkHub() {
        this.power = Configurations.GENERAL_CONFIG.powerBase;
        this.connection = null;
        this.tickCounter = 0;
        this.lastWorldTime = -1L;
        this.proxy.setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    }

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(Registry.itemNetworkHub);
    }

    @Override
    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.DENSE_SMART;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if (this.lastWorldTime != totalWorldTime) {
            this.lastWorldTime = totalWorldTime;
            this.tickCounter = (this.tickCounter + 1) % 20;
            if (this.tickCounter % 20 == 0) {
                this.onTick();
                this.sync();
            }
        }
    }

    private void onTick() {
        if (this.networkUuid != null) {
            DataStorage storage = DataStorage.get(this.field_145850_b);
            Network network = storage.getNetwork(this.networkUuid);
            if (network == null) {
                this.unsetAll();
                return;
            }
            BlockPosDim pos = network.getSendPos();
            if (!this.isHead && pos != null && this.func_174877_v().equals((Object)pos.toBlockPos())) {
                this.setHead(true);
            }
            if (this.isHead) {
                if (this.isConnected) {
                    this.setConnected(!network.getReceivePos().isEmpty());
                }
                int howMany = 0;
                for (IGridConnection gc : this.getActionableNode().getConnections()) {
                    howMany = Math.max(gc.getUsedChannels(), howMany);
                }
                this.surplusChannels = Math.max(AEConfig.instance().getDenseChannelCapacity() - howMany, 0);
            }
            if (!this.isHead && this.connection == null) {
                this.setupConnection(network);
            }
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_186855_b("networkUuid")) {
            this.networkUuid = tag.func_186857_a("networkUuid");
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.networkUuid != null) {
            tag.func_186854_a("networkUuid", this.networkUuid);
        }
        return tag;
    }

    @Override
    public NBTTagCompound getSyncData(NBTTagCompound tag) {
        tag.func_74757_a("isHead", this.isHead);
        if (this.networkUuid != null) {
            tag.func_186854_a("networkUuid", this.networkUuid);
        }
        tag.func_74757_a("isConnected", this.isConnected);
        tag.func_74780_a("power", this.power);
        return tag;
    }

    @Override
    public void doSyncFrom(NBTTagCompound tag) {
        this.isHead = tag.func_74767_n("isHead");
        if (tag.func_186855_b("networkUuid")) {
            this.networkUuid = tag.func_186857_a("networkUuid");
        }
        this.isConnected = tag.func_74767_n("isConnected");
        this.power = tag.func_74769_h("power");
        if (this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 8);
        }
    }

    @Override
    public void addProbeInfo(Consumer<String> consumer, Function<String, String> loc) {
        super.addProbeInfo(consumer, loc);
        consumer.accept(loc.apply("tile_network_hub.state." + this.isConnected()));
        if (Configurations.GENERAL_CONFIG.doNetworkUUIDShow) {
            UUID uuid = this.getNetworkUuid();
            consumer.accept(loc.apply("tile_network_hub.network") + " " + (uuid == null ? "Unknown" : uuid.toString()));
        }
    }

    public void setupConnection(Network network) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPosDim pos = network.getSendPos();
        if (pos == null) {
            return;
        }
        WorldServer thatWorld = DimensionManager.getWorld((int)pos.getDimension());
        if (thatWorld == null || !thatWorld.func_175667_e(pos.toBlockPos())) {
            return;
        }
        TileEntity tile = thatWorld.func_175625_s(pos.toBlockPos());
        if (!(tile instanceof TileNetworkHub)) {
            DataStorage.get((World)thatWorld).removeNetwork(this.networkUuid);
            return;
        }
        TileNetworkHub that = (TileNetworkHub)tile;
        this.power = NetHubPowerUsage.calcNetHubPowerUsage(this.func_174877_v(), that.func_174877_v(), this.field_145850_b.field_73011_w.getDimension(), thatWorld.field_73011_w.getDimension());
        try {
            this.connection = AEApi.instance().grid().createGridConnection(this.getActionableNode(), that.getActionableNode());
            this.setConnected(true);
            that.setConnected(true);
            this.getProxy().setIdlePowerUsage(this.power);
            network.addReceivePos(new BlockPosDim(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension()));
            this.sync();
            that.sync();
        }
        catch (FailedConnectionException e) {
            this.unsetAll();
        }
    }

    public void breakConnection() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        DataStorage storage = DataStorage.get(this.field_145850_b);
        Network network = storage.getNetwork(this.networkUuid);
        if (network == null) {
            this.unsetAll();
            return;
        }
        if (this.isHead) {
            for (BlockPosDim pos : new HashSet<BlockPosDim>(network.getReceivePos())) {
                WorldServer thatWorld = DimensionManager.getWorld((int)pos.getDimension());
                TileEntity tile = thatWorld.func_175625_s(pos.toBlockPos());
                if (!(tile instanceof TileNetworkHub)) continue;
                ((TileNetworkHub)tile).breakConnection();
                ((TileNetworkHub)tile).sync();
            }
            storage.removeNetwork(this.networkUuid);
        } else {
            network.removeReceivePos(new BlockPosDim(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension()));
        }
        storage.func_76185_a();
        this.unsetAll();
    }

    public void unsetAll() {
        this.setHead(false);
        this.setConnected(false);
        this.setNetworkUuid(null);
        if (this.connection != null) {
            this.connection.destroy();
            this.connection = null;
        }
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        DataStorage storage = DataStorage.get(this.field_145850_b);
        Network network = storage.getNetwork(this.networkUuid);
        if (network == null) {
            this.unsetAll();
            return;
        }
        if (this.connection != null) {
            this.connection.destroy();
            this.connection = null;
        }
        this.setConnected(false);
        network.removeReceivePos(new BlockPosDim(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension()));
        storage.func_76185_a();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public void setHead(boolean head) {
        this.isHead = head;
    }

    public double getPower() {
        return this.power;
    }

    @Nullable
    public UUID getNetworkUuid() {
        return this.networkUuid;
    }

    public void setNetworkUuid(UUID networkUuid) {
        this.networkUuid = networkUuid;
    }

    public Integer getSurplusChannels() {
        return this.surplusChannels;
    }
}

